/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.enrichment.common.reports.UpiPostEnrichmentDataRule;
import drr.enrichment.common.reports.UpiPreEnrichmentDataRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.labels.MASTradeLabelProvider;
import drr.regulation.mas.rewrite.trade.reports.ActionTypeRule;
import drr.regulation.mas.rewrite.trade.reports.AssetClassRule;
import drr.regulation.mas.rewrite.trade.reports.BasketConstituentsRule;
import drr.regulation.mas.rewrite.trade.reports.BookingLocationRule;
import drr.regulation.mas.rewrite.trade.reports.CallAmountRule;
import drr.regulation.mas.rewrite.trade.reports.CallCurrencyRule;
import drr.regulation.mas.rewrite.trade.reports.CentralCounterpartyRule;
import drr.regulation.mas.rewrite.trade.reports.ClearedRule;
import drr.regulation.mas.rewrite.trade.reports.ClearingMemberRule;
import drr.regulation.mas.rewrite.trade.reports.ClearingTimestampRule;
import drr.regulation.mas.rewrite.trade.reports.CollateralPortfolioIndicatorRule;
import drr.regulation.mas.rewrite.trade.reports.ConfirmationTimestampRule;
import drr.regulation.mas.rewrite.trade.reports.ConfirmedRule;
import drr.regulation.mas.rewrite.trade.reports.ContractPriceScheduleRule;
import drr.regulation.mas.rewrite.trade.reports.ContractTypeRule;
import drr.regulation.mas.rewrite.trade.reports.Counterparty1Rule;
import drr.regulation.mas.rewrite.trade.reports.Counterparty2IdentifierTypeRule;
import drr.regulation.mas.rewrite.trade.reports.Counterparty2NameDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.Counterparty2Rule;
import drr.regulation.mas.rewrite.trade.reports.DataSubmitterRule;
import drr.regulation.mas.rewrite.trade.reports.DeliveryTypeRule;
import drr.regulation.mas.rewrite.trade.reports.DirectionRule;
import drr.regulation.mas.rewrite.trade.reports.EffectiveDateRule;
import drr.regulation.mas.rewrite.trade.reports.EventTypeRule;
import drr.regulation.mas.rewrite.trade.reports.ExchangeRateBasisRule;
import drr.regulation.mas.rewrite.trade.reports.ExchangeRateRule;
import drr.regulation.mas.rewrite.trade.reports.ExecutionAgentCounterparty1DTCCRule;
import drr.regulation.mas.rewrite.trade.reports.ExecutionAgentCounterparty2DTCCRule;
import drr.regulation.mas.rewrite.trade.reports.ExecutionTimestampRule;
import drr.regulation.mas.rewrite.trade.reports.ExpirationDateRule;
import drr.regulation.mas.rewrite.trade.reports.FinalContractualSettlementDateRule;
import drr.regulation.mas.rewrite.trade.reports.FirstExerciseDateRule;
import drr.regulation.mas.rewrite.trade.reports.InitialMarginCollateralPortfolioCodeDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.Leg1ReportRule;
import drr.regulation.mas.rewrite.trade.reports.Leg2ReportRule;
import drr.regulation.mas.rewrite.trade.reports.NameOfTheUnderlyingIndexDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.OptionPremiumAmountRule;
import drr.regulation.mas.rewrite.trade.reports.OptionPremiumCurrencyRule;
import drr.regulation.mas.rewrite.trade.reports.OptionStyleRule;
import drr.regulation.mas.rewrite.trade.reports.OptionTypeRule;
import drr.regulation.mas.rewrite.trade.reports.OtherPaymentRule;
import drr.regulation.mas.rewrite.trade.reports.PackageIdentifierRule;
import drr.regulation.mas.rewrite.trade.reports.PlatformIdentifierRule;
import drr.regulation.mas.rewrite.trade.reports.PriceCurrencyRule;
import drr.regulation.mas.rewrite.trade.reports.PriceNotationRule;
import drr.regulation.mas.rewrite.trade.reports.PriceRule;
import drr.regulation.mas.rewrite.trade.reports.PriceUnitOfMeasureRule;
import drr.regulation.mas.rewrite.trade.reports.PriorUTIProprietaryRule;
import drr.regulation.mas.rewrite.trade.reports.PriorUTIRule;
import drr.regulation.mas.rewrite.trade.reports.PutAmountRule;
import drr.regulation.mas.rewrite.trade.reports.PutCurrencyRule;
import drr.regulation.mas.rewrite.trade.reports.ReportingSpecifiedPersonRule;
import drr.regulation.mas.rewrite.trade.reports.ReportingTimestampRule;
import drr.regulation.mas.rewrite.trade.reports.StrikePriceCurrencyCurrencyPairRule;
import drr.regulation.mas.rewrite.trade.reports.StrikePriceNotationRule;
import drr.regulation.mas.rewrite.trade.reports.StrikePriceRule;
import drr.regulation.mas.rewrite.trade.reports.StrikePriceScheduleRule;
import drr.regulation.mas.rewrite.trade.reports.SwapLinkIDRule;
import drr.regulation.mas.rewrite.trade.reports.TechnicalRecordIdRule;
import drr.regulation.mas.rewrite.trade.reports.TraderLocationRule;
import drr.regulation.mas.rewrite.trade.reports.TradingCapacityOfSpecifiedPersonRule;
import drr.regulation.mas.rewrite.trade.reports.UnderlyingIdOtherDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.UnderlyingIdOtherSourceDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.UnderlyingIdentificationTypeDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.UnderlyingRule;
import drr.regulation.mas.rewrite.trade.reports.UniqueProductIdentifierRule;
import drr.regulation.mas.rewrite.trade.reports.UniqueTransactionIdentifierProprietaryRule;
import drr.regulation.mas.rewrite.trade.reports.UniqueTransactionIdentifierRule;
import drr.regulation.mas.rewrite.trade.reports.ValuationAmountRule;
import drr.regulation.mas.rewrite.trade.reports.ValuationCurrencyRule;
import drr.regulation.mas.rewrite.trade.reports.ValuationMethodRule;
import drr.regulation.mas.rewrite.trade.reports.ValuationTimestampRule;
import drr.regulation.mas.rewrite.trade.reports.VariationMarginCollateralPortfolioCodeDTCCRule;
import drr.standards.iosco.cde.version3.datetime.reports.EventTimestampRule;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.mas.rewrite.trade", body="MAS", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=MASTradeLabelProvider.class)
@ImplementedBy(value=MASTradeReportFunctionDefault.class)
public abstract class MASTradeReportFunction
implements ReportFunction<TransactionReportInstruction, MASTransactionReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected AssetClassRule assetClassRule;
    @Inject
    protected BasketConstituentsRule basketConstituentsRule;
    @Inject
    protected BookingLocationRule bookingLocationRule;
    @Inject
    protected CallAmountRule callAmountRule;
    @Inject
    protected CallCurrencyRule callCurrencyRule;
    @Inject
    protected CentralCounterpartyRule centralCounterpartyRule;
    @Inject
    protected ClearedRule clearedRule;
    @Inject
    protected ClearingMemberRule clearingMemberRule;
    @Inject
    protected ClearingTimestampRule clearingTimestampRule;
    @Inject
    protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
    @Inject
    protected ConfirmationTimestampRule confirmationTimestampRule;
    @Inject
    protected ConfirmedRule confirmedRule;
    @Inject
    protected ContractPriceScheduleRule contractPriceScheduleRule;
    @Inject
    protected ContractTypeRule contractTypeRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
    @Inject
    protected Counterparty2NameDTCCRule counterparty2NameDTCCRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected DataSubmitterRule dataSubmitterRule;
    @Inject
    protected DeliveryTypeRule deliveryTypeRule;
    @Inject
    protected DirectionRule directionRule;
    @Inject
    protected EffectiveDateRule effectiveDateRule;
    @Inject
    protected EnrichmentDataRule enrichmentDataRule;
    @Inject
    protected EventTimestampRule eventTimestampRule;
    @Inject
    protected EventTypeRule eventTypeRule;
    @Inject
    protected ExchangeRateBasisRule exchangeRateBasisRule;
    @Inject
    protected ExchangeRateRule exchangeRateRule;
    @Inject
    protected ExecutionAgentCounterparty1DTCCRule executionAgentCounterparty1DTCCRule;
    @Inject
    protected ExecutionAgentCounterparty2DTCCRule executionAgentCounterparty2DTCCRule;
    @Inject
    protected ExecutionTimestampRule executionTimestampRule;
    @Inject
    protected ExpirationDateRule expirationDateRule;
    @Inject
    protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
    @Inject
    protected FirstExerciseDateRule firstExerciseDateRule;
    @Inject
    protected InitialMarginCollateralPortfolioCodeDTCCRule initialMarginCollateralPortfolioCodeDTCCRule;
    @Inject
    protected Leg1ReportRule leg1ReportRule;
    @Inject
    protected Leg2ReportRule leg2ReportRule;
    @Inject
    protected NameOfTheUnderlyingIndexDTCCRule nameOfTheUnderlyingIndexDTCCRule;
    @Inject
    protected OptionPremiumAmountRule optionPremiumAmountRule;
    @Inject
    protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
    @Inject
    protected OptionStyleRule optionStyleRule;
    @Inject
    protected OptionTypeRule optionTypeRule;
    @Inject
    protected OtherPaymentRule otherPaymentRule;
    @Inject
    protected PackageIdentifierRule packageIdentifierRule;
    @Inject
    protected PlatformIdentifierRule platformIdentifierRule;
    @Inject
    protected PriceCurrencyRule priceCurrencyRule;
    @Inject
    protected PriceNotationRule priceNotationRule;
    @Inject
    protected PriceRule priceRule;
    @Inject
    protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
    @Inject
    protected PriorUTIProprietaryRule priorUTIProprietaryRule;
    @Inject
    protected PriorUTIRule priorUTIRule;
    @Inject
    protected PutAmountRule putAmountRule;
    @Inject
    protected PutCurrencyRule putCurrencyRule;
    @Inject
    protected ReportingSpecifiedPersonRule reportingSpecifiedPersonRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
    @Inject
    protected StrikePriceNotationRule strikePriceNotationRule;
    @Inject
    protected StrikePriceRule strikePriceRule;
    @Inject
    protected StrikePriceScheduleRule strikePriceScheduleRule;
    @Inject
    protected SwapLinkIDRule swapLinkIDRule;
    @Inject
    protected TechnicalRecordIdRule technicalRecordIdRule;
    @Inject
    protected TraderLocationRule traderLocationRule;
    @Inject
    protected TradingCapacityOfSpecifiedPersonRule tradingCapacityOfSpecifiedPersonRule;
    @Inject
    protected UnderlyingIdOtherDTCCRule underlyingIdOtherDTCCRule;
    @Inject
    protected UnderlyingIdOtherSourceDTCCRule underlyingIdOtherSourceDTCCRule;
    @Inject
    protected UnderlyingIdentificationTypeDTCCRule underlyingIdentificationTypeDTCCRule;
    @Inject
    protected UnderlyingRule underlyingRule;
    @Inject
    protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
    @Inject
    protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected UpiPostEnrichmentDataRule upiPostEnrichmentDataRule;
    @Inject
    protected UpiPreEnrichmentDataRule upiPreEnrichmentDataRule;
    @Inject
    protected ValuationAmountRule valuationAmountRule;
    @Inject
    protected ValuationCurrencyRule valuationCurrencyRule;
    @Inject
    protected ValuationMethodRule valuationMethodRule;
    @Inject
    protected ValuationTimestampRule valuationTimestampRule;
    @Inject
    protected VariationMarginCollateralPortfolioCodeDTCCRule variationMarginCollateralPortfolioCodeDTCCRule;

    public MASTransactionReport evaluate(TransactionReportInstruction input) {
        MASTransactionReport output;
        MASTransactionReport.MASTransactionReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(MASTransactionReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract MASTransactionReport.MASTransactionReportBuilder doEvaluate(TransactionReportInstruction var1);

    public static class MASTradeReportFunctionDefault
    extends MASTradeReportFunction {
        @Override
        protected MASTransactionReport.MASTransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
            MASTransactionReport.MASTransactionReportBuilder output = MASTransactionReport.builder();
            return this.assignOutput(output, input);
        }

        protected MASTransactionReport.MASTransactionReportBuilder assignOutput(MASTransactionReport.MASTransactionReportBuilder output, TransactionReportInstruction input) {
            output.setEffectiveDate(this.effectiveDateRule.evaluate(input));
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setExecutionTimestamp(this.executionTimestampRule.evaluate(input));
            output.setExpirationDate(this.expirationDateRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setCounterparty2IdentifierTypeOverriddenAsBoolean(this.counterparty2IdentifierTypeRule.evaluate(input));
            output.setCleared(this.clearedRule.evaluate(input));
            output.setCentralCounterparty(this.centralCounterpartyRule.evaluate(input));
            output.setClearingMember(this.clearingMemberRule.evaluate(input));
            output.setConfirmed(this.confirmedRule.evaluate(input));
            output.setCallAmount(this.callAmountRule.evaluate(input));
            output.setPutAmount(this.putAmountRule.evaluate(input));
            output.setCallCurrency(this.callCurrencyRule.evaluate(input));
            output.setPutCurrency(this.putCurrencyRule.evaluate(input));
            output.setPriceSchedule((List)this.contractPriceScheduleRule.evaluate(input));
            output.setStrikePriceSchedule((List)this.strikePriceScheduleRule.evaluate(input));
            output.setPrice(this.priceRule.evaluate(input));
            output.setPriceNotation(this.priceNotationRule.evaluate(input));
            output.setPriceCurrency(this.priceCurrencyRule.evaluate(input));
            output.setPackageIdentifier(this.packageIdentifierRule.evaluate(input));
            output.setStrikePrice(this.strikePriceRule.evaluate(input));
            output.setStrikePriceNotation(this.strikePriceNotationRule.evaluate(input));
            output.setStrikePriceCurrency(this.strikePriceCurrencyCurrencyPairRule.evaluate(input));
            output.setPriceUnitOfMeasure(this.priceUnitOfMeasureRule.evaluate(input));
            output.setOptionPremiumAmount(this.optionPremiumAmountRule.evaluate(input));
            output.setOptionPremiumCurrency(this.optionPremiumCurrencyRule.evaluate(input));
            output.setExchangeRate(this.exchangeRateRule.evaluate(input));
            output.setExchangeRateBasis(this.exchangeRateBasisRule.evaluate(input));
            output.setCollateralPortfolioIndicator(this.collateralPortfolioIndicatorRule.evaluate(input));
            output.setFirstExerciseDate(this.firstExerciseDateRule.evaluate(input));
            output.setFinalContractualSettlementDate(this.finalContractualSettlementDateRule.evaluate(input));
            output.setPriorUTI(this.priorUTIRule.evaluate(input));
            output.setValuationAmount(this.valuationAmountRule.evaluate(input));
            output.setValuationCurrency(this.valuationCurrencyRule.evaluate(input));
            output.setValuationMethod(this.valuationMethodRule.evaluate(input));
            output.setValuationTimestamp(this.valuationTimestampRule.evaluate(input));
            output.setBasketConstituents((List)this.basketConstituentsRule.evaluate(input));
            output.setOtherPayment((List)this.otherPaymentRule.evaluate(input));
            output.setLeg1(this.leg1ReportRule.evaluate(input));
            output.setLeg2(this.leg2ReportRule.evaluate(input));
            output.setUnderlyingIdOther(this.underlyingIdOtherDTCCRule.evaluate(input));
            output.setUnderlyingIdOtherSource(this.underlyingIdOtherSourceDTCCRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setEventType(this.eventTypeRule.evaluate(input));
            output.setEventTimestampOverriddenAsZonedDateTime(this.eventTimestampRule.evaluate(input));
            output.setCounterparty2Name(this.counterparty2NameDTCCRule.evaluate(input));
            output.setExecutionAgentCounterparty1(this.executionAgentCounterparty1DTCCRule.evaluate(input));
            output.setExecutionAgentCounterparty2(this.executionAgentCounterparty2DTCCRule.evaluate(input));
            output.setReportSubmittingEntityID(this.dataSubmitterRule.evaluate(input));
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietary(this.uniqueTransactionIdentifierProprietaryRule.evaluate(input));
            output.setPriorUTIProprietary(this.priorUTIProprietaryRule.evaluate(input));
            output.setUniqueProductIdentifier(this.uniqueProductIdentifierRule.evaluate(input));
            output.setContractTypeOverriddenAsCommonContractType(this.contractTypeRule.evaluate(input));
            output.setAssetClassOverriddenAsCommonAssetClass(this.assetClassRule.evaluate(input));
            output.setClearingTimestamp(this.clearingTimestampRule.evaluate(input));
            output.setPlatformIdentifier(this.platformIdentifierRule.evaluate(input));
            output.setDirection1(this.directionRule.evaluate(input));
            output.setNameOfTheUnderlyingIndex(this.nameOfTheUnderlyingIndexDTCCRule.evaluate(input));
            output.setOptionType(this.optionTypeRule.evaluate(input));
            output.setOptionStyle(this.optionStyleRule.evaluate(input));
            output.setDeliveryType(this.deliveryTypeRule.evaluate(input));
            output.setBookingLocation(this.bookingLocationRule.evaluate(input));
            output.setTraderLocation(this.traderLocationRule.evaluate(input));
            output.setTradingCapacity(this.tradingCapacityOfSpecifiedPersonRule.evaluate(input));
            output.setTechnicalRecordIdOverriddenAsString(this.technicalRecordIdRule.evaluate(input));
            output.setInitialMarginCollateralPortfolioCode(this.initialMarginCollateralPortfolioCodeDTCCRule.evaluate(input));
            output.setVariationMarginCollateralPortfolioCodeOverriddenAsString(this.variationMarginCollateralPortfolioCodeDTCCRule.evaluate(input));
            output.setConfirmationTimestamp(this.confirmationTimestampRule.evaluate(input));
            output.setSwapLinkID(this.swapLinkIDRule.evaluate(input));
            output.setUnderlyingIdentification(this.underlyingRule.evaluate(input));
            output.setUnderlyingIdentificationType(this.underlyingIdentificationTypeDTCCRule.evaluate(input));
            output.getOrCreateNonReportable().setEnrichment(this.enrichmentDataRule.evaluate(input));
            output.getOrCreateNonReportable().setPreUpiData(this.upiPreEnrichmentDataRule.evaluate(input));
            output.getOrCreateNonReportable().setPostUpiData(this.upiPostEnrichmentDataRule.evaluate(input));
            output.setTradingCapacityOfSpecifiedPerson(this.tradingCapacityOfSpecifiedPersonRule.evaluate(input));
            output.setReportingSpecifiedPerson(this.reportingSpecifiedPersonRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

