/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.base.payment.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.standards.iosco.cde.base.payment.OtherPayment;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OtherPaymentTypeFormatValidator
implements Validator<OtherPayment> {
    private List<ComparisonResult> getComparisonResults(OtherPayment o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkNumber((String)"amount", (BigDecimal)o.getAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"payer", (String)o.getPayer(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"receiver", (String)o.getReceiver(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, OtherPayment o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"OtherPayment", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"OtherPayment", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"OtherPayment", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"OtherPayment", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

