/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.base.price;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.standards.iosco.cde.base.price.meta.PriceFormatMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PriceFormat", builder=PriceFormatBuilderImpl.class, version="6.17.1")
@RuneDataType(value="PriceFormat", model="drr", builder=PriceFormatBuilderImpl.class, version="6.17.1")
public interface PriceFormat
extends RosettaModelObject {
    public static final PriceFormatMeta metaData = new PriceFormatMeta();

    public BigDecimal getMonetary();

    public BigDecimal getDecimal();

    public BigDecimal getPercentage();

    public BigDecimal getBasis();

    public PriceFormat build();

    public PriceFormatBuilder toBuilder();

    public static PriceFormatBuilder builder() {
        return new PriceFormatBuilderImpl();
    }

    default public RosettaMetaData<? extends PriceFormat> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PriceFormat> getType() {
        return PriceFormat.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("monetary"), BigDecimal.class, (Object)this.getMonetary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("decimal"), BigDecimal.class, (Object)this.getDecimal(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("percentage"), BigDecimal.class, (Object)this.getPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("basis"), BigDecimal.class, (Object)this.getBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PriceFormatBuilderImpl
    implements PriceFormatBuilder {
        protected BigDecimal monetary;
        protected BigDecimal decimal;
        protected BigDecimal percentage;
        protected BigDecimal basis;

        @Override
        @RosettaAttribute(value="monetary")
        @RuneAttribute(value="monetary")
        public BigDecimal getMonetary() {
            return this.monetary;
        }

        @Override
        @RosettaAttribute(value="decimal")
        @RuneAttribute(value="decimal")
        public BigDecimal getDecimal() {
            return this.decimal;
        }

        @Override
        @RosettaAttribute(value="percentage")
        @RuneAttribute(value="percentage")
        public BigDecimal getPercentage() {
            return this.percentage;
        }

        @Override
        @RosettaAttribute(value="basis")
        @RuneAttribute(value="basis")
        public BigDecimal getBasis() {
            return this.basis;
        }

        @Override
        @RosettaAttribute(value="monetary")
        @RuneAttribute(value="monetary")
        public PriceFormatBuilder setMonetary(BigDecimal _monetary) {
            this.monetary = _monetary == null ? null : _monetary;
            return this;
        }

        @Override
        @RosettaAttribute(value="decimal")
        @RuneAttribute(value="decimal")
        public PriceFormatBuilder setDecimal(BigDecimal _decimal) {
            this.decimal = _decimal == null ? null : _decimal;
            return this;
        }

        @Override
        @RosettaAttribute(value="percentage")
        @RuneAttribute(value="percentage")
        public PriceFormatBuilder setPercentage(BigDecimal _percentage) {
            this.percentage = _percentage == null ? null : _percentage;
            return this;
        }

        @Override
        @RosettaAttribute(value="basis")
        @RuneAttribute(value="basis")
        public PriceFormatBuilder setBasis(BigDecimal _basis) {
            this.basis = _basis == null ? null : _basis;
            return this;
        }

        @Override
        public PriceFormat build() {
            return new PriceFormatImpl(this);
        }

        @Override
        public PriceFormatBuilder toBuilder() {
            return this;
        }

        @Override
        public PriceFormatBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getMonetary() != null) {
                return true;
            }
            if (this.getDecimal() != null) {
                return true;
            }
            if (this.getPercentage() != null) {
                return true;
            }
            return this.getBasis() != null;
        }

        public PriceFormatBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PriceFormatBuilder o = (PriceFormatBuilder)other;
            merger.mergeBasic((Object)this.getMonetary(), (Object)o.getMonetary(), this::setMonetary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDecimal(), (Object)o.getDecimal(), this::setDecimal, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPercentage(), (Object)o.getPercentage(), this::setPercentage, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBasis(), (Object)o.getBasis(), this::setBasis, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceFormat _that = this.getType().cast(o);
            if (!Objects.equals(this.monetary, _that.getMonetary())) {
                return false;
            }
            if (!Objects.equals(this.decimal, _that.getDecimal())) {
                return false;
            }
            if (!Objects.equals(this.percentage, _that.getPercentage())) {
                return false;
            }
            return Objects.equals(this.basis, _that.getBasis());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.monetary != null ? this.monetary.hashCode() : 0);
            _result = 31 * _result + (this.decimal != null ? this.decimal.hashCode() : 0);
            _result = 31 * _result + (this.percentage != null ? this.percentage.hashCode() : 0);
            _result = 31 * _result + (this.basis != null ? this.basis.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceFormatBuilder {monetary=" + String.valueOf(this.monetary) + ", decimal=" + String.valueOf(this.decimal) + ", percentage=" + String.valueOf(this.percentage) + ", basis=" + String.valueOf(this.basis) + "}";
        }
    }

    public static interface PriceFormatBuilder
    extends PriceFormat,
    RosettaModelObjectBuilder {
        public PriceFormatBuilder setMonetary(BigDecimal var1);

        public PriceFormatBuilder setDecimal(BigDecimal var1);

        public PriceFormatBuilder setPercentage(BigDecimal var1);

        public PriceFormatBuilder setBasis(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("monetary"), BigDecimal.class, (Object)this.getMonetary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("decimal"), BigDecimal.class, (Object)this.getDecimal(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("percentage"), BigDecimal.class, (Object)this.getPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("basis"), BigDecimal.class, (Object)this.getBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PriceFormatBuilder prune();
    }

    public static class PriceFormatImpl
    implements PriceFormat {
        private final BigDecimal monetary;
        private final BigDecimal decimal;
        private final BigDecimal percentage;
        private final BigDecimal basis;

        protected PriceFormatImpl(PriceFormatBuilder builder) {
            this.monetary = builder.getMonetary();
            this.decimal = builder.getDecimal();
            this.percentage = builder.getPercentage();
            this.basis = builder.getBasis();
        }

        @Override
        @RosettaAttribute(value="monetary")
        @RuneAttribute(value="monetary")
        public BigDecimal getMonetary() {
            return this.monetary;
        }

        @Override
        @RosettaAttribute(value="decimal")
        @RuneAttribute(value="decimal")
        public BigDecimal getDecimal() {
            return this.decimal;
        }

        @Override
        @RosettaAttribute(value="percentage")
        @RuneAttribute(value="percentage")
        public BigDecimal getPercentage() {
            return this.percentage;
        }

        @Override
        @RosettaAttribute(value="basis")
        @RuneAttribute(value="basis")
        public BigDecimal getBasis() {
            return this.basis;
        }

        @Override
        public PriceFormat build() {
            return this;
        }

        @Override
        public PriceFormatBuilder toBuilder() {
            PriceFormatBuilder builder = PriceFormat.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PriceFormatBuilder builder) {
            Optional.ofNullable(this.getMonetary()).ifPresent(builder::setMonetary);
            Optional.ofNullable(this.getDecimal()).ifPresent(builder::setDecimal);
            Optional.ofNullable(this.getPercentage()).ifPresent(builder::setPercentage);
            Optional.ofNullable(this.getBasis()).ifPresent(builder::setBasis);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceFormat _that = this.getType().cast(o);
            if (!Objects.equals(this.monetary, _that.getMonetary())) {
                return false;
            }
            if (!Objects.equals(this.decimal, _that.getDecimal())) {
                return false;
            }
            if (!Objects.equals(this.percentage, _that.getPercentage())) {
                return false;
            }
            return Objects.equals(this.basis, _that.getBasis());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.monetary != null ? this.monetary.hashCode() : 0);
            _result = 31 * _result + (this.decimal != null ? this.decimal.hashCode() : 0);
            _result = 31 * _result + (this.percentage != null ? this.percentage.hashCode() : 0);
            _result = 31 * _result + (this.basis != null ? this.basis.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceFormat {monetary=" + String.valueOf(this.monetary) + ", decimal=" + String.valueOf(this.decimal) + ", percentage=" + String.valueOf(this.percentage) + ", basis=" + String.valueOf(this.basis) + "}";
        }
    }
}

