/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.base.quantity.functions;

import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.TradableProductForEvent;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetProductForQuantityDefault.class)
public abstract class GetProductForQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected IsActionTypeTERM isActionTypeTERM;
    @Inject
    protected TradableProductForEvent tradableProductForEvent;

    public TradableProduct evaluate(TransactionReportInstruction transactionReportInstruction) {
        TradableProduct product;
        TradableProduct.TradableProductBuilder productBuilder = this.doEvaluate(transactionReportInstruction);
        if (productBuilder == null) {
            product = null;
        } else {
            product = productBuilder.build();
            this.objectValidator.validate(TradableProduct.class, (RosettaModelObject)product);
        }
        return product;
    }

    protected abstract TradableProduct.TradableProductBuilder doEvaluate(TransactionReportInstruction var1);

    public static class GetProductForQuantityDefault
    extends GetProductForQuantity {
        @Override
        protected TradableProduct.TradableProductBuilder doEvaluate(TransactionReportInstruction transactionReportInstruction) {
            TradableProduct.TradableProductBuilder product = TradableProduct.builder();
            return this.assignOutput(product, transactionReportInstruction);
        }

        protected TradableProduct.TradableProductBuilder assignOutput(TradableProduct.TradableProductBuilder product, TransactionReportInstruction transactionReportInstruction) {
            Boolean _boolean = this.isActionTypeTERM.evaluate(transactionReportInstruction);
            product = _boolean != null && _boolean != false ? (TradableProduct.TradableProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.beforeTradeForEvent.evaluate(transactionReportInstruction)).map("getTradableProduct", trade -> trade.getTradableProduct()).get()) : (TradableProduct.TradableProductBuilder)this.toBuilder((RosettaModelObject)this.tradableProductForEvent.evaluate(transactionReportInstruction));
            return Optional.ofNullable(product).map(o -> o.prune()).orElse(null);
        }
    }
}

