/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.payment.reports;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.FormatToMax3Number;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=PaymentFrequencyPeriodMultiplierRuleDefault.class)
public abstract class PaymentFrequencyPeriodMultiplierRule
implements ReportFunction<InterestRatePayout, BigDecimal> {
    @Inject
    protected FormatToMax3Number formatToMax3Number;

    public BigDecimal evaluate(InterestRatePayout input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(InterestRatePayout var1);

    public static class PaymentFrequencyPeriodMultiplierRuleDefault
    extends PaymentFrequencyPeriodMultiplierRule {
        @Override
        protected BigDecimal doEvaluate(InterestRatePayout input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, InterestRatePayout input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> item.map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).map("getPeriodMultiplier", frequency -> frequency.getPeriodMultiplier()));
            Integer integer = (Integer)thenArg.get();
            output = (BigDecimal)MapperS.of((Object)this.formatToMax3Number.evaluate(integer == null ? null : BigDecimal.valueOf(integer.intValue()))).get();
            return output;
        }
    }
}

