/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.functions.Contract_Price_Monetary;
import drr.standards.iosco.cde.base.price.functions.PriceOfZeroCouponSwaps;
import drr.standards.iosco.cde.version1.price.reports.PriceNotationRule;
import javax.inject.Inject;

@ImplementedBy(value=PriceCurrencyRuleDefault.class)
public abstract class PriceCurrencyRule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected Contract_Price_Monetary contract_Price_Monetary;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
    @Inject
    protected PriceNotationRule priceNotationRule;
    @Inject
    protected PriceOfZeroCouponSwaps priceOfZeroCouponSwaps;
    @Inject
    protected ProductForEvent productForEvent;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class PriceCurrencyRuleDefault
    extends PriceCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperC ifThenElseResult;
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)this.priceNotationRule.evaluate((ReportableEvent)item.get()))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).get());
            Boolean _boolean = this.isFixedFloatZeroCouponSwapKnownAmount.evaluate(this.productForEvent.evaluate((ReportableEvent)thenArg0.get()));
            if (_boolean != null && _boolean.booleanValue()) {
                MapperC thenArg1 = MapperC.of(this.priceOfZeroCouponSwaps.evaluate((ReportableEvent)thenArg0.get()));
                ifThenElseResult = thenArg1.mapItem(item -> item.map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()));
            } else {
                ifThenElseResult = MapperC.of(this.contract_Price_Monetary.evaluate((ReportableEvent)thenArg0.get())).mapItem(item -> item.map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()));
            }
            MapperS thenArg2 = MapperS.of((Object)((FieldWithMetaString)ifThenElseResult.get()));
            output = (ISOCurrencyCodeEnum)thenArg2.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

