/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.functions.Contract_StrikePrice;
import drr.standards.iosco.cde.version1.price.reports.StrikePriceNotationEnumRule;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceCurrencyRuleDefault.class)
public abstract class StrikePriceCurrencyRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected Contract_StrikePrice contract_StrikePrice;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected StrikePriceNotationEnumRule strikePriceNotationEnumRule;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class StrikePriceCurrencyRuleDefault
    extends StrikePriceCurrencyRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperC thenArg0 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)this.strikePriceNotationEnumRule.evaluate(input))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)input).mapSingleToList(item -> MapperC.of(this.contract_StrikePrice.evaluate((ReportableEvent)item.get()))) : MapperC.ofNull();
            MapperS thenArg1 = MapperS.of((Object)((PriceSchedule)thenArg0.get()));
            output = (String)thenArg1.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.exists((Mapper)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCurrency", unitType -> unitType.getCurrency()))).and(ExpressionOperators.exists((Mapper)item.map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    FieldWithMetaString fieldWithMetaString0 = (FieldWithMetaString)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCurrency", unitType -> unitType.getCurrency()).get();
                    FieldWithMetaString fieldWithMetaString1 = (FieldWithMetaString)item.map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get();
                    return MapperMaths.add((Mapper)MapperMaths.add((Mapper)MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue())).map("to-string", ISOCurrencyCodeEnum::toDisplayString), (Mapper)MapperS.of((Object)"/")), (Mapper)MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue())).map("to-string", ISOCurrencyCodeEnum::toDisplayString));
                }
                FieldWithMetaString fieldWithMetaString2 = (FieldWithMetaString)item.map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue())).map("to-string", ISOCurrencyCodeEnum::toDisplayString);
            }).get();
            return output;
        }
    }
}

