/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.quantity.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.PayoutLegWithAuxiliary;
import drr.regulation.common.functions.FormatToNonNegativeShortFraction5DecimalNumber;
import drr.standards.iosco.cde.version1.quantity.functions.NotionalAmount;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=NotionalAmountFormatDefault.class)
public abstract class NotionalAmountFormat
implements RosettaFunction {
    @Inject
    protected FormatToNonNegativeShortFraction5DecimalNumber formatToNonNegativeShortFraction5DecimalNumber;
    @Inject
    protected NotionalAmount notionalAmount;

    public BigDecimal evaluate(PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
        BigDecimal _notionalAmount = this.doEvaluate(payout, defaultValue);
        return _notionalAmount;
    }

    protected abstract BigDecimal doEvaluate(PayoutLegWithAuxiliary var1, BigDecimal var2);

    public static class NotionalAmountFormatDefault
    extends NotionalAmountFormat {
        @Override
        protected BigDecimal doEvaluate(PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
            BigDecimal _notionalAmount = null;
            return this.assignOutput(_notionalAmount, payout, defaultValue);
        }

        protected BigDecimal assignOutput(BigDecimal _notionalAmount, PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
            _notionalAmount = this.formatToNonNegativeShortFraction5DecimalNumber.evaluate(this.notionalAmount.evaluate(payout, defaultValue));
            return _notionalAmount;
        }
    }
}

