/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.quantity.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.event.common.Trade;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.IsCallOption;
import drr.regulation.common.functions.IsEquityOption;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iosco.cde.base.quantity.functions.CallQuantity;
import drr.standards.iosco.cde.base.quantity.functions.GetTradeForQuantity;
import javax.inject.Inject;

@ImplementedBy(value=CallCurrencyRuleDefault.class)
public abstract class CallCurrencyRule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected CallQuantity callQuantity;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected FixedPriceLeg1 fixedPriceLeg1;
    @Inject
    protected GetTradeForQuantity getTradeForQuantity;
    @Inject
    protected IsCallOption isCallOption;
    @Inject
    protected IsEquityOption isEquityOption;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_Commodity_Option qualify_Commodity_Option;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class CallCurrencyRuleDefault
    extends CallCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.getTradeForQuantity.evaluate((TransactionReportInstruction)item.get())));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())));
            MapperC thenArg2 = thenArg1.mapSingleToList(item -> {
                Boolean boolean0 = this.isCallOption.evaluate((Product)item.get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    Boolean boolean1 = this.qualify_Commodity_Option.evaluate((EconomicTerms)item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
                    if (boolean1 != null && boolean1.booleanValue()) {
                        return item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
                    }
                    Boolean boolean2 = this.qualify_Commodity_Swaption.evaluate((EconomicTerms)item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
                    if (boolean2 != null && boolean2.booleanValue()) {
                        return MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.fixedPriceLeg1.evaluate(this.underlierForProduct.evaluate((Product)item.get()))).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", fixedPrice -> fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())});
                    }
                    if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isEquityOption.evaluate((Product)item.get()))).and(ExpressionOperators.exists((Mapper)item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
                    }
                    if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isEquityOption.evaluate((Product)item.get()))).and(ExpressionOperators.exists((Mapper)item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
                    }
                    return MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.callQuantity.evaluate((Product)item.get())).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())});
                }
                return MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.callQuantity.evaluate((Product)item.get())).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())});
            });
            MapperC thenArg3 = thenArg2.mapItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            });
            output = (ISOCurrencyCodeEnum)MapperS.of((Object)((ISOCurrencyCodeEnum)thenArg3.get())).get();
            return output;
        }
    }
}

