/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version3;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.standards.iosco.cde.base.basket.BasketConstituentsReport;
import drr.standards.iosco.cde.base.payment.OtherPayment;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.PricePeriod;
import drr.standards.iosco.cde.version1.LegV1;
import drr.standards.iosco.cde.version2.CriticalDataElementV2;
import drr.standards.iosco.cde.version2.LegV2;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iosco.cde.version3.meta.CriticalDataElementMeta;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CriticalDataElement", builder=CriticalDataElementBuilderImpl.class, version="6.17.1")
@RuneDataType(value="CriticalDataElement", model="drr", builder=CriticalDataElementBuilderImpl.class, version="6.17.1")
public interface CriticalDataElement
extends CriticalDataElementV2 {
    public static final CriticalDataElementMeta metaData = new CriticalDataElementMeta();

    @Override
    public Leg getLeg1();

    @Override
    public Leg getLeg2();

    public String getUnderlyingIdOther();

    public ProductIdTypeEnum getUnderlyingIdOtherSource();

    public String getUnderlyingAssetTradingPlatformIdentifier();

    public String getUnderlyingAssetPriceSource();

    public Boolean getCryptoAssetUnderlyingIndicator();

    public ReportLevelEnum getLevel();

    public ActionTypeEnum getActionType();

    public EventTypeEnum getEventType();

    public String getEventIdentifier();

    public ZonedDateTime getEventTimestamp();

    @Override
    public CriticalDataElement build();

    @Override
    public CriticalDataElementBuilder toBuilder();

    public static CriticalDataElementBuilder builder() {
        return new CriticalDataElementBuilderImpl();
    }

    default public RosettaMetaData<? extends CriticalDataElement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CriticalDataElement> getType() {
        return CriticalDataElement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, this.getPriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceFormat.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, this.getStrikePrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, this.getBasketConstituents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, this.getOtherPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg1"), processor, Leg.class, this.getLeg1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg2"), processor, Leg.class, this.getLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CriticalDataElementBuilderImpl
    implements CriticalDataElementBuilder {
        protected Date effectiveDate;
        protected Date earlyTerminationDate;
        protected ZonedDateTime reportingTimestamp;
        protected ZonedDateTime executionTimestamp;
        protected Date expirationDate;
        protected String counterparty1;
        protected String counterparty2;
        protected Boolean counterparty2IdentifierType;
        protected String beneficiary1;
        protected Boolean beneficiary1IdentifierTypeIndicator;
        protected String buyerIdentifier;
        protected String sellerIdentifier;
        protected ClearedEnum cleared;
        protected String centralCounterparty;
        protected String clearingMember;
        protected ConfirmationEnum confirmed;
        protected BigDecimal callAmount;
        protected BigDecimal putAmount;
        protected ISOCurrencyCodeEnum callCurrency;
        protected ISOCurrencyCodeEnum putCurrency;
        protected BigDecimal delta;
        protected List<PricePeriod.PricePeriodBuilder> priceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
        protected List<PricePeriod.PricePeriodBuilder> strikePriceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
        protected PriceFormat.PriceFormatBuilder price;
        protected PriceNotationEnum priceNotation;
        protected ISOCurrencyCodeEnum priceCurrency;
        protected PriceFormat.PriceFormatBuilder packageTransactionPrice;
        protected PriceNotationEnum packageTransactionPriceNotation;
        protected ISOCurrencyCodeEnum packageTransactionPriceCurrency;
        protected PriceFormat.PriceFormatBuilder packageTransactionSpread;
        protected PriceNotationEnum packageTransactionSpreadNotation;
        protected ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
        protected String packageIdentifier;
        protected PriceFormat.PriceFormatBuilder strikePrice;
        protected PriceNotationEnum strikePriceNotation;
        protected String strikePriceCurrency;
        protected String priceUnitOfMeasure;
        protected BigDecimal optionPremiumAmount;
        protected ISOCurrencyCodeEnum optionPremiumCurrency;
        protected Date optionPremiumPaymentDate;
        protected BigDecimal exchangeRate;
        protected String exchangeRateBasis;
        protected BigDecimal cdSIndexAttachmentPoint;
        protected BigDecimal cdSIndexDetachmentPoint;
        protected Boolean collateralPortfolioIndicator;
        protected Date firstExerciseDate;
        protected Date finalContractualSettlementDate;
        protected ISOCountryCodeEnum settlementLocation;
        protected String priorUTI;
        protected BigDecimal valuationAmount;
        protected ISOCurrencyCodeEnum valuationCurrency;
        protected ValuationType1Code valuationMethod;
        protected ZonedDateTime valuationTimestamp;
        protected String customBasketCode;
        protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
        protected List<OtherPayment.OtherPaymentBuilder> otherPayment = new ArrayList<OtherPayment.OtherPaymentBuilder>();
        protected Leg.LegBuilder leg1;
        protected Leg.LegBuilder leg2;
        protected String underlyingIdOther;
        protected ProductIdTypeEnum underlyingIdOtherSource;
        protected String underlyingAssetTradingPlatformIdentifier;
        protected String underlyingAssetPriceSource;
        protected Boolean cryptoAssetUnderlyingIndicator;
        protected ReportLevelEnum level;
        protected ActionTypeEnum actionType;
        protected EventTypeEnum eventType;
        protected String eventIdentifier;
        protected ZonedDateTime eventTimestamp;

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public Date getEarlyTerminationDate() {
            return this.earlyTerminationDate;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public String getBeneficiary1() {
            return this.beneficiary1;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public Boolean getBeneficiary1IdentifierTypeIndicator() {
            return this.beneficiary1IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public String getBuyerIdentifier() {
            return this.buyerIdentifier;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public String getSellerIdentifier() {
            return this.sellerIdentifier;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public String getCentralCounterparty() {
            return this.centralCounterparty;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public String getClearingMember() {
            return this.clearingMember;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public ConfirmationEnum getConfirmed() {
            return this.confirmed;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public BigDecimal getCallAmount() {
            return this.callAmount;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public BigDecimal getPutAmount() {
            return this.putAmount;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ISOCurrencyCodeEnum getCallCurrency() {
            return this.callCurrency;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ISOCurrencyCodeEnum getPutCurrency() {
            return this.putCurrency;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public List<? extends PricePeriod.PricePeriodBuilder> getPriceSchedule() {
            return this.priceSchedule;
        }

        @Override
        public PricePeriod.PricePeriodBuilder getOrCreatePriceSchedule(int index) {
            if (this.priceSchedule == null) {
                this.priceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
            }
            return (PricePeriod.PricePeriodBuilder)this.getIndex(this.priceSchedule, index, () -> {
                PricePeriod.PricePeriodBuilder newPriceSchedule = PricePeriod.builder();
                return newPriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public List<? extends PricePeriod.PricePeriodBuilder> getStrikePriceSchedule() {
            return this.strikePriceSchedule;
        }

        @Override
        public PricePeriod.PricePeriodBuilder getOrCreateStrikePriceSchedule(int index) {
            if (this.strikePriceSchedule == null) {
                this.strikePriceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
            }
            return (PricePeriod.PricePeriodBuilder)this.getIndex(this.strikePriceSchedule, index, () -> {
                PricePeriod.PricePeriodBuilder newStrikePriceSchedule = PricePeriod.builder();
                return newStrikePriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public PriceFormat.PriceFormatBuilder getPrice() {
            return this.price;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePrice() {
            PriceFormat.PriceFormatBuilder result = this.price != null ? this.price : (this.price = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public PriceNotationEnum getPriceNotation() {
            return this.priceNotation;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public ISOCurrencyCodeEnum getPriceCurrency() {
            return this.priceCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public PriceFormat.PriceFormatBuilder getPackageTransactionPrice() {
            return this.packageTransactionPrice;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePackageTransactionPrice() {
            PriceFormat.PriceFormatBuilder result = this.packageTransactionPrice != null ? this.packageTransactionPrice : (this.packageTransactionPrice = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public PriceNotationEnum getPackageTransactionPriceNotation() {
            return this.packageTransactionPriceNotation;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
            return this.packageTransactionPriceCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public PriceFormat.PriceFormatBuilder getPackageTransactionSpread() {
            return this.packageTransactionSpread;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePackageTransactionSpread() {
            PriceFormat.PriceFormatBuilder result = this.packageTransactionSpread != null ? this.packageTransactionSpread : (this.packageTransactionSpread = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public PriceNotationEnum getPackageTransactionSpreadNotation() {
            return this.packageTransactionSpreadNotation;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
            return this.packageTransactionSpreadCurrency;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public PriceFormat.PriceFormatBuilder getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreateStrikePrice() {
            PriceFormat.PriceFormatBuilder result = this.strikePrice != null ? this.strikePrice : (this.strikePrice = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public PriceNotationEnum getStrikePriceNotation() {
            return this.strikePriceNotation;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public String getStrikePriceCurrency() {
            return this.strikePriceCurrency;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public String getPriceUnitOfMeasure() {
            return this.priceUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public BigDecimal getOptionPremiumAmount() {
            return this.optionPremiumAmount;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
            return this.optionPremiumCurrency;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public Date getOptionPremiumPaymentDate() {
            return this.optionPremiumPaymentDate;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public String getExchangeRateBasis() {
            return this.exchangeRateBasis;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public BigDecimal getCdSIndexAttachmentPoint() {
            return this.cdSIndexAttachmentPoint;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public BigDecimal getCdSIndexDetachmentPoint() {
            return this.cdSIndexDetachmentPoint;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public Date getFirstExerciseDate() {
            return this.firstExerciseDate;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public Date getFinalContractualSettlementDate() {
            return this.finalContractualSettlementDate;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public ISOCountryCodeEnum getSettlementLocation() {
            return this.settlementLocation;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public String getPriorUTI() {
            return this.priorUTI;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public String getCustomBasketCode() {
            return this.customBasketCode;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents() {
            return this.basketConstituents;
        }

        @Override
        public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int index) {
            if (this.basketConstituents == null) {
                this.basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
            }
            return (BasketConstituentsReport.BasketConstituentsReportBuilder)this.getIndex(this.basketConstituents, index, () -> {
                BasketConstituentsReport.BasketConstituentsReportBuilder newBasketConstituents = BasketConstituentsReport.builder();
                return newBasketConstituents;
            });
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends OtherPayment.OtherPaymentBuilder> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        public OtherPayment.OtherPaymentBuilder getOrCreateOtherPayment(int index) {
            if (this.otherPayment == null) {
                this.otherPayment = new ArrayList<OtherPayment.OtherPaymentBuilder>();
            }
            return (OtherPayment.OtherPaymentBuilder)this.getIndex(this.otherPayment, index, () -> {
                OtherPayment.OtherPaymentBuilder newOtherPayment = OtherPayment.builder();
                return newOtherPayment;
            });
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public Leg.LegBuilder getLeg1() {
            return this.leg1;
        }

        @Override
        public Leg.LegBuilder getOrCreateLeg1() {
            Leg.LegBuilder result = this.leg1 != null ? this.leg1 : (this.leg1 = Leg.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public Leg.LegBuilder getLeg2() {
            return this.leg2;
        }

        @Override
        public Leg.LegBuilder getOrCreateLeg2() {
            Leg.LegBuilder result = this.leg2 != null ? this.leg2 : (this.leg2 = Leg.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public String getUnderlyingIdOther() {
            return this.underlyingIdOther;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public ProductIdTypeEnum getUnderlyingIdOtherSource() {
            return this.underlyingIdOtherSource;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public String getUnderlyingAssetTradingPlatformIdentifier() {
            return this.underlyingAssetTradingPlatformIdentifier;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public String getUnderlyingAssetPriceSource() {
            return this.underlyingAssetPriceSource;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public Boolean getCryptoAssetUnderlyingIndicator() {
            return this.cryptoAssetUnderlyingIndicator;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public ReportLevelEnum getLevel() {
            return this.level;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ActionTypeEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public EventTypeEnum getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public String getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public CriticalDataElementBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public CriticalDataElementBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
            this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public CriticalDataElementBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public CriticalDataElementBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
            this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public CriticalDataElementBuilder setExpirationDate(Date _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public CriticalDataElementBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public CriticalDataElementBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public CriticalDataElementBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public CriticalDataElementBuilder setBeneficiary1(String _beneficiary1) {
            this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public CriticalDataElementBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
            this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public CriticalDataElementBuilder setBuyerIdentifier(String _buyerIdentifier) {
            this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public CriticalDataElementBuilder setSellerIdentifier(String _sellerIdentifier) {
            this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public CriticalDataElementBuilder setCleared(ClearedEnum _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public CriticalDataElementBuilder setCentralCounterparty(String _centralCounterparty) {
            this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public CriticalDataElementBuilder setClearingMember(String _clearingMember) {
            this.clearingMember = _clearingMember == null ? null : _clearingMember;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public CriticalDataElementBuilder setConfirmed(ConfirmationEnum _confirmed) {
            this.confirmed = _confirmed == null ? null : _confirmed;
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public CriticalDataElementBuilder setCallAmount(BigDecimal _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public CriticalDataElementBuilder setPutAmount(BigDecimal _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public CriticalDataElementBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
            this.callCurrency = _callCurrency == null ? null : _callCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public CriticalDataElementBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
            this.putCurrency = _putCurrency == null ? null : _putCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public CriticalDataElementBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public CriticalDataElementBuilder addPriceSchedule(PricePeriod _priceSchedule) {
            if (_priceSchedule != null) {
                this.priceSchedule.add(_priceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CriticalDataElementBuilder addPriceSchedule(PricePeriod _priceSchedule, int idx) {
            this.getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
            return this;
        }

        @Override
        public CriticalDataElementBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            if (priceSchedules != null) {
                for (PricePeriod pricePeriod : priceSchedules) {
                    this.priceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceSchedule")
        public CriticalDataElementBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            this.priceSchedule = priceSchedules == null ? new ArrayList<PricePeriod.PricePeriodBuilder>() : (List)priceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public CriticalDataElementBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
            if (_strikePriceSchedule != null) {
                this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CriticalDataElementBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int idx) {
            this.getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
            return this;
        }

        @Override
        public CriticalDataElementBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            if (strikePriceSchedules != null) {
                for (PricePeriod pricePeriod : strikePriceSchedules) {
                    this.strikePriceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceSchedule")
        public CriticalDataElementBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            this.strikePriceSchedule = strikePriceSchedules == null ? new ArrayList<PricePeriod.PricePeriodBuilder>() : (List)strikePriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public CriticalDataElementBuilder setPrice(PriceFormat _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public CriticalDataElementBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
            this.priceNotation = _priceNotation == null ? null : _priceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public CriticalDataElementBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
            this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public CriticalDataElementBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
            this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public CriticalDataElementBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
            this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public CriticalDataElementBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
            this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public CriticalDataElementBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
            this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public CriticalDataElementBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
            this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public CriticalDataElementBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
            this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public CriticalDataElementBuilder setPackageIdentifier(String _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public CriticalDataElementBuilder setStrikePrice(PriceFormat _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public CriticalDataElementBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
            this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public CriticalDataElementBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
            this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public CriticalDataElementBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
            this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public CriticalDataElementBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
            this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public CriticalDataElementBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
            this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public CriticalDataElementBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
            this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public CriticalDataElementBuilder setExchangeRate(BigDecimal _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public CriticalDataElementBuilder setExchangeRateBasis(String _exchangeRateBasis) {
            this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public CriticalDataElementBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
            this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public CriticalDataElementBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
            this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public CriticalDataElementBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public CriticalDataElementBuilder setFirstExerciseDate(Date _firstExerciseDate) {
            this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public CriticalDataElementBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public CriticalDataElementBuilder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public CriticalDataElementBuilder setPriorUTI(String _priorUTI) {
            this.priorUTI = _priorUTI == null ? null : _priorUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public CriticalDataElementBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public CriticalDataElementBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public CriticalDataElementBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public CriticalDataElementBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public CriticalDataElementBuilder setCustomBasketCode(String _customBasketCode) {
            this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public CriticalDataElementBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
            if (_basketConstituents != null) {
                this.basketConstituents.add(_basketConstituents.toBuilder());
            }
            return this;
        }

        @Override
        public CriticalDataElementBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
            this.getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
            return this;
        }

        @Override
        public CriticalDataElementBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            if (basketConstituentss != null) {
                for (BasketConstituentsReport basketConstituentsReport : basketConstituentss) {
                    this.basketConstituents.add(basketConstituentsReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituents")
        public CriticalDataElementBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            this.basketConstituents = basketConstituentss == null ? new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>() : (List)basketConstituentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public CriticalDataElementBuilder addOtherPayment(OtherPayment _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public CriticalDataElementBuilder addOtherPayment(OtherPayment _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public CriticalDataElementBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
            if (otherPayments != null) {
                for (OtherPayment otherPayment : otherPayments) {
                    this.otherPayment.add(otherPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public CriticalDataElementBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList<OtherPayment.OtherPaymentBuilder>() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public CriticalDataElementBuilder setLeg1(Leg _leg1) {
            this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public CriticalDataElementBuilder setLeg1(LegV2 _leg1) {
            Leg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof Leg ? (Leg)Leg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public CriticalDataElementBuilder setLeg1(LegV1 _leg1) {
            Leg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof Leg ? (Leg)Leg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public CriticalDataElementBuilder setLeg2(Leg _leg2) {
            this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public CriticalDataElementBuilder setLeg2(LegV2 _leg2) {
            Leg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof Leg ? (Leg)Leg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public CriticalDataElementBuilder setLeg2(LegV1 _leg2) {
            Leg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof Leg ? (Leg)Leg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public CriticalDataElementBuilder setUnderlyingIdOther(String _underlyingIdOther) {
            this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public CriticalDataElementBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum _underlyingIdOtherSource) {
            this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public CriticalDataElementBuilder setUnderlyingAssetTradingPlatformIdentifier(String _underlyingAssetTradingPlatformIdentifier) {
            this.underlyingAssetTradingPlatformIdentifier = _underlyingAssetTradingPlatformIdentifier == null ? null : _underlyingAssetTradingPlatformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public CriticalDataElementBuilder setUnderlyingAssetPriceSource(String _underlyingAssetPriceSource) {
            this.underlyingAssetPriceSource = _underlyingAssetPriceSource == null ? null : _underlyingAssetPriceSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public CriticalDataElementBuilder setCryptoAssetUnderlyingIndicator(Boolean _cryptoAssetUnderlyingIndicator) {
            this.cryptoAssetUnderlyingIndicator = _cryptoAssetUnderlyingIndicator == null ? null : _cryptoAssetUnderlyingIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public CriticalDataElementBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public CriticalDataElementBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public CriticalDataElementBuilder setEventType(EventTypeEnum _eventType) {
            this.eventType = _eventType == null ? null : _eventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public CriticalDataElementBuilder setEventIdentifier(String _eventIdentifier) {
            this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public CriticalDataElementBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        public CriticalDataElement build() {
            return new CriticalDataElementImpl(this);
        }

        @Override
        public CriticalDataElementBuilder toBuilder() {
            return this;
        }

        @Override
        public CriticalDataElementBuilder prune() {
            this.priceSchedule = this.priceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.strikePriceSchedule = this.strikePriceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.price != null && !this.price.prune().hasData()) {
                this.price = null;
            }
            if (this.packageTransactionPrice != null && !this.packageTransactionPrice.prune().hasData()) {
                this.packageTransactionPrice = null;
            }
            if (this.packageTransactionSpread != null && !this.packageTransactionSpread.prune().hasData()) {
                this.packageTransactionSpread = null;
            }
            if (this.strikePrice != null && !this.strikePrice.prune().hasData()) {
                this.strikePrice = null;
            }
            this.basketConstituents = this.basketConstituents.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.otherPayment = this.otherPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.leg1 != null && !this.leg1.prune().hasData()) {
                this.leg1 = null;
            }
            if (this.leg2 != null && !this.leg2.prune().hasData()) {
                this.leg2 = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getEarlyTerminationDate() != null) {
                return true;
            }
            if (this.getReportingTimestamp() != null) {
                return true;
            }
            if (this.getExecutionTimestamp() != null) {
                return true;
            }
            if (this.getExpirationDate() != null) {
                return true;
            }
            if (this.getCounterparty1() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getBeneficiary1() != null) {
                return true;
            }
            if (this.getBeneficiary1IdentifierTypeIndicator() != null) {
                return true;
            }
            if (this.getBuyerIdentifier() != null) {
                return true;
            }
            if (this.getSellerIdentifier() != null) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getCentralCounterparty() != null) {
                return true;
            }
            if (this.getClearingMember() != null) {
                return true;
            }
            if (this.getConfirmed() != null) {
                return true;
            }
            if (this.getCallAmount() != null) {
                return true;
            }
            if (this.getPutAmount() != null) {
                return true;
            }
            if (this.getCallCurrency() != null) {
                return true;
            }
            if (this.getPutCurrency() != null) {
                return true;
            }
            if (this.getDelta() != null) {
                return true;
            }
            if (this.getPriceSchedule() != null && this.getPriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getStrikePriceSchedule() != null && this.getStrikePriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPrice() != null && this.getPrice().hasData()) {
                return true;
            }
            if (this.getPriceNotation() != null) {
                return true;
            }
            if (this.getPriceCurrency() != null) {
                return true;
            }
            if (this.getPackageTransactionPrice() != null && this.getPackageTransactionPrice().hasData()) {
                return true;
            }
            if (this.getPackageTransactionPriceNotation() != null) {
                return true;
            }
            if (this.getPackageTransactionPriceCurrency() != null) {
                return true;
            }
            if (this.getPackageTransactionSpread() != null && this.getPackageTransactionSpread().hasData()) {
                return true;
            }
            if (this.getPackageTransactionSpreadNotation() != null) {
                return true;
            }
            if (this.getPackageTransactionSpreadCurrency() != null) {
                return true;
            }
            if (this.getPackageIdentifier() != null) {
                return true;
            }
            if (this.getStrikePrice() != null && this.getStrikePrice().hasData()) {
                return true;
            }
            if (this.getStrikePriceNotation() != null) {
                return true;
            }
            if (this.getStrikePriceCurrency() != null) {
                return true;
            }
            if (this.getPriceUnitOfMeasure() != null) {
                return true;
            }
            if (this.getOptionPremiumAmount() != null) {
                return true;
            }
            if (this.getOptionPremiumCurrency() != null) {
                return true;
            }
            if (this.getOptionPremiumPaymentDate() != null) {
                return true;
            }
            if (this.getExchangeRate() != null) {
                return true;
            }
            if (this.getExchangeRateBasis() != null) {
                return true;
            }
            if (this.getCdSIndexAttachmentPoint() != null) {
                return true;
            }
            if (this.getCdSIndexDetachmentPoint() != null) {
                return true;
            }
            if (this.getCollateralPortfolioIndicator() != null) {
                return true;
            }
            if (this.getFirstExerciseDate() != null) {
                return true;
            }
            if (this.getFinalContractualSettlementDate() != null) {
                return true;
            }
            if (this.getSettlementLocation() != null) {
                return true;
            }
            if (this.getPriorUTI() != null) {
                return true;
            }
            if (this.getValuationAmount() != null) {
                return true;
            }
            if (this.getValuationCurrency() != null) {
                return true;
            }
            if (this.getValuationMethod() != null) {
                return true;
            }
            if (this.getValuationTimestamp() != null) {
                return true;
            }
            if (this.getCustomBasketCode() != null) {
                return true;
            }
            if (this.getBasketConstituents() != null && this.getBasketConstituents().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOtherPayment() != null && this.getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLeg1() != null && this.getLeg1().hasData()) {
                return true;
            }
            if (this.getLeg2() != null && this.getLeg2().hasData()) {
                return true;
            }
            if (this.getUnderlyingIdOther() != null) {
                return true;
            }
            if (this.getUnderlyingIdOtherSource() != null) {
                return true;
            }
            if (this.getUnderlyingAssetTradingPlatformIdentifier() != null) {
                return true;
            }
            if (this.getUnderlyingAssetPriceSource() != null) {
                return true;
            }
            if (this.getCryptoAssetUnderlyingIndicator() != null) {
                return true;
            }
            if (this.getLevel() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getEventType() != null) {
                return true;
            }
            if (this.getEventIdentifier() != null) {
                return true;
            }
            return this.getEventTimestamp() != null;
        }

        public CriticalDataElementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CriticalDataElementBuilder o = (CriticalDataElementBuilder)other;
            merger.mergeRosetta(this.getPriceSchedule(), o.getPriceSchedule(), this::getOrCreatePriceSchedule);
            merger.mergeRosetta(this.getStrikePriceSchedule(), o.getStrikePriceSchedule(), this::getOrCreateStrikePriceSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrice(), (RosettaModelObjectBuilder)o.getPrice(), this::setPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageTransactionPrice(), (RosettaModelObjectBuilder)o.getPackageTransactionPrice(), this::setPackageTransactionPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageTransactionSpread(), (RosettaModelObjectBuilder)o.getPackageTransactionSpread(), this::setPackageTransactionSpread);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikePrice(), (RosettaModelObjectBuilder)o.getStrikePrice(), this::setStrikePrice);
            merger.mergeRosetta(this.getBasketConstituents(), o.getBasketConstituents(), this::getOrCreateBasketConstituents);
            merger.mergeRosetta(this.getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLeg1(), (RosettaModelObjectBuilder)o.getLeg1(), this::setLeg1);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLeg2(), (RosettaModelObjectBuilder)o.getLeg2(), this::setLeg2);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEarlyTerminationDate(), (Object)o.getEarlyTerminationDate(), this::setEarlyTerminationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingTimestamp(), (Object)o.getReportingTimestamp(), this::setReportingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionTimestamp(), (Object)o.getExecutionTimestamp(), this::setExecutionTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExpirationDate(), (Object)o.getExpirationDate(), this::setExpirationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty1(), (Object)o.getCounterparty1(), this::setCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBeneficiary1(), (Object)o.getBeneficiary1(), this::setBeneficiary1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBeneficiary1IdentifierTypeIndicator(), (Object)o.getBeneficiary1IdentifierTypeIndicator(), this::setBeneficiary1IdentifierTypeIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBuyerIdentifier(), (Object)o.getBuyerIdentifier(), this::setBuyerIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSellerIdentifier(), (Object)o.getSellerIdentifier(), this::setSellerIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setCleared, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCentralCounterparty(), (Object)o.getCentralCounterparty(), this::setCentralCounterparty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingMember(), (Object)o.getClearingMember(), this::setClearingMember, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getConfirmed(), (Object)o.getConfirmed(), this::setConfirmed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallAmount(), (Object)o.getCallAmount(), this::setCallAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutAmount(), (Object)o.getPutAmount(), this::setPutAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallCurrency(), (Object)o.getCallCurrency(), this::setCallCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutCurrency(), (Object)o.getPutCurrency(), this::setPutCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDelta(), (Object)o.getDelta(), this::setDelta, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceNotation(), (Object)o.getPriceNotation(), this::setPriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceCurrency(), (Object)o.getPriceCurrency(), this::setPriceCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionPriceNotation(), (Object)o.getPackageTransactionPriceNotation(), this::setPackageTransactionPriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionPriceCurrency(), (Object)o.getPackageTransactionPriceCurrency(), this::setPackageTransactionPriceCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionSpreadNotation(), (Object)o.getPackageTransactionSpreadNotation(), this::setPackageTransactionSpreadNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionSpreadCurrency(), (Object)o.getPackageTransactionSpreadCurrency(), this::setPackageTransactionSpreadCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageIdentifier(), (Object)o.getPackageIdentifier(), this::setPackageIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStrikePriceNotation(), (Object)o.getStrikePriceNotation(), this::setStrikePriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStrikePriceCurrency(), (Object)o.getStrikePriceCurrency(), this::setStrikePriceCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceUnitOfMeasure(), (Object)o.getPriceUnitOfMeasure(), this::setPriceUnitOfMeasure, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumAmount(), (Object)o.getOptionPremiumAmount(), this::setOptionPremiumAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumCurrency(), (Object)o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumPaymentDate(), (Object)o.getOptionPremiumPaymentDate(), this::setOptionPremiumPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRate(), (Object)o.getExchangeRate(), this::setExchangeRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRateBasis(), (Object)o.getExchangeRateBasis(), this::setExchangeRateBasis, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCdSIndexAttachmentPoint(), (Object)o.getCdSIndexAttachmentPoint(), this::setCdSIndexAttachmentPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCdSIndexDetachmentPoint(), (Object)o.getCdSIndexDetachmentPoint(), this::setCdSIndexDetachmentPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralPortfolioIndicator(), (Object)o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFirstExerciseDate(), (Object)o.getFirstExerciseDate(), this::setFirstExerciseDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinalContractualSettlementDate(), (Object)o.getFinalContractualSettlementDate(), this::setFinalContractualSettlementDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementLocation(), (Object)o.getSettlementLocation(), this::setSettlementLocation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUTI(), (Object)o.getPriorUTI(), this::setPriorUTI, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationAmount(), (Object)o.getValuationAmount(), this::setValuationAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationCurrency(), (Object)o.getValuationCurrency(), this::setValuationCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethod(), (Object)o.getValuationMethod(), this::setValuationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationTimestamp(), (Object)o.getValuationTimestamp(), this::setValuationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCustomBasketCode(), (Object)o.getCustomBasketCode(), this::setCustomBasketCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdOther(), (Object)o.getUnderlyingIdOther(), this::setUnderlyingIdOther, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdOtherSource(), (Object)o.getUnderlyingIdOtherSource(), this::setUnderlyingIdOtherSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (Object)o.getUnderlyingAssetTradingPlatformIdentifier(), this::setUnderlyingAssetTradingPlatformIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingAssetPriceSource(), (Object)o.getUnderlyingAssetPriceSource(), this::setUnderlyingAssetPriceSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCryptoAssetUnderlyingIndicator(), (Object)o.getCryptoAssetUnderlyingIndicator(), this::setCryptoAssetUnderlyingIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLevel(), (Object)o.getLevel(), this::setLevel, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventType(), (Object)o.getEventType(), this::setEventType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventIdentifier(), (Object)o.getEventIdentifier(), this::setEventIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestamp, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CriticalDataElement _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.earlyTerminationDate, _that.getEarlyTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1, _that.getBeneficiary1())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1IdentifierTypeIndicator, _that.getBeneficiary1IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.buyerIdentifier, _that.getBuyerIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.sellerIdentifier, _that.getSellerIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.centralCounterparty, _that.getCentralCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.clearingMember, _that.getClearingMember())) {
                return false;
            }
            if (!Objects.equals((Object)this.confirmed, (Object)_that.getConfirmed())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!Objects.equals(this.callCurrency, _that.getCallCurrency())) {
                return false;
            }
            if (!Objects.equals(this.putCurrency, _that.getPutCurrency())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceSchedule, _that.getPriceSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceSchedule, _that.getStrikePriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceNotation, (Object)_that.getPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.priceCurrency, _that.getPriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPrice, _that.getPackageTransactionPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.packageTransactionPriceNotation, (Object)_that.getPackageTransactionPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpread, _that.getPackageTransactionSpread())) {
                return false;
            }
            if (!Objects.equals((Object)this.packageTransactionSpreadNotation, (Object)_that.getPackageTransactionSpreadNotation())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.strikePriceNotation, (Object)_that.getStrikePriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.strikePriceCurrency, _that.getStrikePriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumAmount, _that.getOptionPremiumAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumCurrency, _that.getOptionPremiumCurrency())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateBasis, _that.getExchangeRateBasis())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.firstExerciseDate, _that.getFirstExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementLocation, _that.getSettlementLocation())) {
                return false;
            }
            if (!Objects.equals(this.priorUTI, _that.getPriorUTI())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.customBasketCode, _that.getCustomBasketCode())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituents, _that.getBasketConstituents())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.leg1, _that.getLeg1())) {
                return false;
            }
            if (!Objects.equals(this.leg2, _that.getLeg2())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOther, _that.getUnderlyingIdOther())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetTradingPlatformIdentifier, _that.getUnderlyingAssetTradingPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetPriceSource, _that.getUnderlyingAssetPriceSource())) {
                return false;
            }
            if (!Objects.equals(this.cryptoAssetUnderlyingIndicator, _that.getCryptoAssetUnderlyingIndicator())) {
                return false;
            }
            if (!Objects.equals((Object)this.level, (Object)_that.getLevel())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals((Object)this.eventType, (Object)_that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            return Objects.equals(this.eventTimestamp, _that.getEventTimestamp());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationDate != null ? this.earlyTerminationDate.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1 != null ? this.beneficiary1.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1IdentifierTypeIndicator != null ? this.beneficiary1IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.buyerIdentifier != null ? this.buyerIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.sellerIdentifier != null ? this.sellerIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.centralCounterparty != null ? this.centralCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.clearingMember != null ? this.clearingMember.hashCode() : 0);
            _result = 31 * _result + (this.confirmed != null ? ((Object)((Object)this.confirmed)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.callCurrency != null ? this.callCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.putCurrency != null ? this.putCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.priceSchedule != null ? this.priceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceSchedule != null ? this.strikePriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.priceNotation != null ? ((Object)((Object)this.priceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceCurrency != null ? this.priceCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPrice != null ? this.packageTransactionPrice.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceNotation != null ? ((Object)((Object)this.packageTransactionPriceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceCurrency != null ? this.packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpread != null ? this.packageTransactionSpread.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadNotation != null ? ((Object)((Object)this.packageTransactionSpreadNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadCurrency != null ? this.packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceNotation != null ? ((Object)((Object)this.strikePriceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strikePriceCurrency != null ? this.strikePriceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.priceUnitOfMeasure != null ? this.priceUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumAmount != null ? this.optionPremiumAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumCurrency != null ? this.optionPremiumCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumPaymentDate != null ? this.optionPremiumPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateBasis != null ? this.exchangeRateBasis.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexAttachmentPoint != null ? this.cdSIndexAttachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexDetachmentPoint != null ? this.cdSIndexDetachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.firstExerciseDate != null ? this.firstExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.finalContractualSettlementDate != null ? this.finalContractualSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementLocation != null ? this.settlementLocation.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priorUTI != null ? this.priorUTI.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.customBasketCode != null ? this.customBasketCode.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituents != null ? this.basketConstituents.hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.leg1 != null ? this.leg1.hashCode() : 0);
            _result = 31 * _result + (this.leg2 != null ? this.leg2.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOther != null ? this.underlyingIdOther.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOtherSource != null ? this.underlyingIdOtherSource.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetTradingPlatformIdentifier != null ? this.underlyingAssetTradingPlatformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetPriceSource != null ? this.underlyingAssetPriceSource.hashCode() : 0);
            _result = 31 * _result + (this.cryptoAssetUnderlyingIndicator != null ? this.cryptoAssetUnderlyingIndicator.hashCode() : 0);
            _result = 31 * _result + (this.level != null ? ((Object)((Object)this.level)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? ((Object)((Object)this.eventType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CriticalDataElementBuilder {effectiveDate=" + String.valueOf(this.effectiveDate) + ", earlyTerminationDate=" + String.valueOf(this.earlyTerminationDate) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", expirationDate=" + String.valueOf(this.expirationDate) + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", beneficiary1=" + this.beneficiary1 + ", beneficiary1IdentifierTypeIndicator=" + this.beneficiary1IdentifierTypeIndicator + ", buyerIdentifier=" + this.buyerIdentifier + ", sellerIdentifier=" + this.sellerIdentifier + ", cleared=" + String.valueOf((Object)this.cleared) + ", centralCounterparty=" + this.centralCounterparty + ", clearingMember=" + this.clearingMember + ", confirmed=" + String.valueOf((Object)this.confirmed) + ", callAmount=" + String.valueOf(this.callAmount) + ", putAmount=" + String.valueOf(this.putAmount) + ", callCurrency=" + String.valueOf(this.callCurrency) + ", putCurrency=" + String.valueOf(this.putCurrency) + ", delta=" + String.valueOf(this.delta) + ", priceSchedule=" + String.valueOf(this.priceSchedule) + ", strikePriceSchedule=" + String.valueOf(this.strikePriceSchedule) + ", price=" + String.valueOf(this.price) + ", priceNotation=" + String.valueOf((Object)this.priceNotation) + ", priceCurrency=" + String.valueOf(this.priceCurrency) + ", packageTransactionPrice=" + String.valueOf(this.packageTransactionPrice) + ", packageTransactionPriceNotation=" + String.valueOf((Object)this.packageTransactionPriceNotation) + ", packageTransactionPriceCurrency=" + String.valueOf(this.packageTransactionPriceCurrency) + ", packageTransactionSpread=" + String.valueOf(this.packageTransactionSpread) + ", packageTransactionSpreadNotation=" + String.valueOf((Object)this.packageTransactionSpreadNotation) + ", packageTransactionSpreadCurrency=" + String.valueOf(this.packageTransactionSpreadCurrency) + ", packageIdentifier=" + this.packageIdentifier + ", strikePrice=" + String.valueOf(this.strikePrice) + ", strikePriceNotation=" + String.valueOf((Object)this.strikePriceNotation) + ", strikePriceCurrency=" + this.strikePriceCurrency + ", priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", optionPremiumAmount=" + String.valueOf(this.optionPremiumAmount) + ", optionPremiumCurrency=" + String.valueOf(this.optionPremiumCurrency) + ", optionPremiumPaymentDate=" + String.valueOf(this.optionPremiumPaymentDate) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", exchangeRateBasis=" + this.exchangeRateBasis + ", cdSIndexAttachmentPoint=" + String.valueOf(this.cdSIndexAttachmentPoint) + ", cdSIndexDetachmentPoint=" + String.valueOf(this.cdSIndexDetachmentPoint) + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", firstExerciseDate=" + String.valueOf(this.firstExerciseDate) + ", finalContractualSettlementDate=" + String.valueOf(this.finalContractualSettlementDate) + ", settlementLocation=" + String.valueOf(this.settlementLocation) + ", priorUTI=" + this.priorUTI + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf((Object)this.valuationMethod) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", customBasketCode=" + this.customBasketCode + ", basketConstituents=" + String.valueOf(this.basketConstituents) + ", otherPayment=" + String.valueOf(this.otherPayment) + ", leg1=" + String.valueOf(this.leg1) + ", leg2=" + String.valueOf(this.leg2) + ", underlyingIdOther=" + this.underlyingIdOther + ", underlyingIdOtherSource=" + String.valueOf(this.underlyingIdOtherSource) + ", underlyingAssetTradingPlatformIdentifier=" + this.underlyingAssetTradingPlatformIdentifier + ", underlyingAssetPriceSource=" + this.underlyingAssetPriceSource + ", cryptoAssetUnderlyingIndicator=" + this.cryptoAssetUnderlyingIndicator + ", level=" + String.valueOf((Object)this.level) + ", actionType=" + String.valueOf((Object)this.actionType) + ", eventType=" + String.valueOf((Object)this.eventType) + ", eventIdentifier=" + this.eventIdentifier + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + "}";
        }
    }

    public static interface CriticalDataElementBuilder
    extends CriticalDataElement,
    CriticalDataElementV2.CriticalDataElementV2Builder {
        @Override
        public Leg.LegBuilder getOrCreateLeg1();

        @Override
        public Leg.LegBuilder getLeg1();

        @Override
        public Leg.LegBuilder getOrCreateLeg2();

        @Override
        public Leg.LegBuilder getLeg2();

        @Override
        public CriticalDataElementBuilder setEffectiveDate(Date var1);

        @Override
        public CriticalDataElementBuilder setEarlyTerminationDate(Date var1);

        @Override
        public CriticalDataElementBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public CriticalDataElementBuilder setExecutionTimestamp(ZonedDateTime var1);

        @Override
        public CriticalDataElementBuilder setExpirationDate(Date var1);

        @Override
        public CriticalDataElementBuilder setCounterparty1(String var1);

        @Override
        public CriticalDataElementBuilder setCounterparty2(String var1);

        @Override
        public CriticalDataElementBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public CriticalDataElementBuilder setBeneficiary1(String var1);

        @Override
        public CriticalDataElementBuilder setBeneficiary1IdentifierTypeIndicator(Boolean var1);

        @Override
        public CriticalDataElementBuilder setBuyerIdentifier(String var1);

        @Override
        public CriticalDataElementBuilder setSellerIdentifier(String var1);

        @Override
        public CriticalDataElementBuilder setCleared(ClearedEnum var1);

        @Override
        public CriticalDataElementBuilder setCentralCounterparty(String var1);

        @Override
        public CriticalDataElementBuilder setClearingMember(String var1);

        @Override
        public CriticalDataElementBuilder setConfirmed(ConfirmationEnum var1);

        @Override
        public CriticalDataElementBuilder setCallAmount(BigDecimal var1);

        @Override
        public CriticalDataElementBuilder setPutAmount(BigDecimal var1);

        @Override
        public CriticalDataElementBuilder setCallCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CriticalDataElementBuilder setPutCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CriticalDataElementBuilder setDelta(BigDecimal var1);

        @Override
        public CriticalDataElementBuilder addPriceSchedule(PricePeriod var1);

        @Override
        public CriticalDataElementBuilder addPriceSchedule(PricePeriod var1, int var2);

        @Override
        public CriticalDataElementBuilder addPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public CriticalDataElementBuilder setPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public CriticalDataElementBuilder addStrikePriceSchedule(PricePeriod var1);

        @Override
        public CriticalDataElementBuilder addStrikePriceSchedule(PricePeriod var1, int var2);

        @Override
        public CriticalDataElementBuilder addStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public CriticalDataElementBuilder setStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public CriticalDataElementBuilder setPrice(PriceFormat var1);

        @Override
        public CriticalDataElementBuilder setPriceNotation(PriceNotationEnum var1);

        @Override
        public CriticalDataElementBuilder setPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CriticalDataElementBuilder setPackageTransactionPrice(PriceFormat var1);

        @Override
        public CriticalDataElementBuilder setPackageTransactionPriceNotation(PriceNotationEnum var1);

        @Override
        public CriticalDataElementBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CriticalDataElementBuilder setPackageTransactionSpread(PriceFormat var1);

        @Override
        public CriticalDataElementBuilder setPackageTransactionSpreadNotation(PriceNotationEnum var1);

        @Override
        public CriticalDataElementBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CriticalDataElementBuilder setPackageIdentifier(String var1);

        @Override
        public CriticalDataElementBuilder setStrikePrice(PriceFormat var1);

        @Override
        public CriticalDataElementBuilder setStrikePriceNotation(PriceNotationEnum var1);

        @Override
        public CriticalDataElementBuilder setStrikePriceCurrency(String var1);

        @Override
        public CriticalDataElementBuilder setPriceUnitOfMeasure(String var1);

        @Override
        public CriticalDataElementBuilder setOptionPremiumAmount(BigDecimal var1);

        @Override
        public CriticalDataElementBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CriticalDataElementBuilder setOptionPremiumPaymentDate(Date var1);

        @Override
        public CriticalDataElementBuilder setExchangeRate(BigDecimal var1);

        @Override
        public CriticalDataElementBuilder setExchangeRateBasis(String var1);

        @Override
        public CriticalDataElementBuilder setCdSIndexAttachmentPoint(BigDecimal var1);

        @Override
        public CriticalDataElementBuilder setCdSIndexDetachmentPoint(BigDecimal var1);

        @Override
        public CriticalDataElementBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public CriticalDataElementBuilder setFirstExerciseDate(Date var1);

        @Override
        public CriticalDataElementBuilder setFinalContractualSettlementDate(Date var1);

        @Override
        public CriticalDataElementBuilder setSettlementLocation(ISOCountryCodeEnum var1);

        @Override
        public CriticalDataElementBuilder setPriorUTI(String var1);

        @Override
        public CriticalDataElementBuilder setValuationAmount(BigDecimal var1);

        @Override
        public CriticalDataElementBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CriticalDataElementBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public CriticalDataElementBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public CriticalDataElementBuilder setCustomBasketCode(String var1);

        @Override
        public CriticalDataElementBuilder addBasketConstituents(BasketConstituentsReport var1);

        @Override
        public CriticalDataElementBuilder addBasketConstituents(BasketConstituentsReport var1, int var2);

        @Override
        public CriticalDataElementBuilder addBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public CriticalDataElementBuilder setBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public CriticalDataElementBuilder addOtherPayment(OtherPayment var1);

        @Override
        public CriticalDataElementBuilder addOtherPayment(OtherPayment var1, int var2);

        @Override
        public CriticalDataElementBuilder addOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public CriticalDataElementBuilder setOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public CriticalDataElementBuilder setLeg1(LegV1 var1);

        @Override
        public CriticalDataElementBuilder setLeg2(LegV1 var1);

        @Override
        public CriticalDataElementBuilder setLeg1(LegV2 var1);

        @Override
        public CriticalDataElementBuilder setLeg2(LegV2 var1);

        public CriticalDataElementBuilder setLeg1(Leg var1);

        public CriticalDataElementBuilder setLeg2(Leg var1);

        public CriticalDataElementBuilder setUnderlyingIdOther(String var1);

        public CriticalDataElementBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum var1);

        public CriticalDataElementBuilder setUnderlyingAssetTradingPlatformIdentifier(String var1);

        public CriticalDataElementBuilder setUnderlyingAssetPriceSource(String var1);

        public CriticalDataElementBuilder setCryptoAssetUnderlyingIndicator(Boolean var1);

        public CriticalDataElementBuilder setLevel(ReportLevelEnum var1);

        public CriticalDataElementBuilder setActionType(ActionTypeEnum var1);

        public CriticalDataElementBuilder setEventType(EventTypeEnum var1);

        public CriticalDataElementBuilder setEventIdentifier(String var1);

        public CriticalDataElementBuilder setEventTimestamp(ZonedDateTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getPriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getStrikePrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, this.getBasketConstituents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg1"), processor, Leg.LegBuilder.class, this.getLeg1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg2"), processor, Leg.LegBuilder.class, this.getLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CriticalDataElementBuilder prune();
    }

    public static class CriticalDataElementImpl
    extends CriticalDataElementV2.CriticalDataElementV2Impl
    implements CriticalDataElement {
        private final Leg leg1;
        private final Leg leg2;
        private final String underlyingIdOther;
        private final ProductIdTypeEnum underlyingIdOtherSource;
        private final String underlyingAssetTradingPlatformIdentifier;
        private final String underlyingAssetPriceSource;
        private final Boolean cryptoAssetUnderlyingIndicator;
        private final ReportLevelEnum level;
        private final ActionTypeEnum actionType;
        private final EventTypeEnum eventType;
        private final String eventIdentifier;
        private final ZonedDateTime eventTimestamp;

        protected CriticalDataElementImpl(CriticalDataElementBuilder builder) {
            super(builder);
            this.leg1 = Optional.ofNullable(builder.getLeg1()).map(f -> f.build()).orElse(null);
            this.leg2 = Optional.ofNullable(builder.getLeg2()).map(f -> f.build()).orElse(null);
            this.underlyingIdOther = builder.getUnderlyingIdOther();
            this.underlyingIdOtherSource = builder.getUnderlyingIdOtherSource();
            this.underlyingAssetTradingPlatformIdentifier = builder.getUnderlyingAssetTradingPlatformIdentifier();
            this.underlyingAssetPriceSource = builder.getUnderlyingAssetPriceSource();
            this.cryptoAssetUnderlyingIndicator = builder.getCryptoAssetUnderlyingIndicator();
            this.level = builder.getLevel();
            this.actionType = builder.getActionType();
            this.eventType = builder.getEventType();
            this.eventIdentifier = builder.getEventIdentifier();
            this.eventTimestamp = builder.getEventTimestamp();
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public Leg getLeg1() {
            return this.leg1;
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public Leg getLeg2() {
            return this.leg2;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public String getUnderlyingIdOther() {
            return this.underlyingIdOther;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public ProductIdTypeEnum getUnderlyingIdOtherSource() {
            return this.underlyingIdOtherSource;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public String getUnderlyingAssetTradingPlatformIdentifier() {
            return this.underlyingAssetTradingPlatformIdentifier;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public String getUnderlyingAssetPriceSource() {
            return this.underlyingAssetPriceSource;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public Boolean getCryptoAssetUnderlyingIndicator() {
            return this.cryptoAssetUnderlyingIndicator;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public ReportLevelEnum getLevel() {
            return this.level;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ActionTypeEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public EventTypeEnum getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public String getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        public CriticalDataElement build() {
            return this;
        }

        @Override
        public CriticalDataElementBuilder toBuilder() {
            CriticalDataElementBuilder builder = CriticalDataElement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CriticalDataElementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLeg1()).ifPresent(builder::setLeg1);
            Optional.ofNullable(this.getLeg2()).ifPresent(builder::setLeg2);
            Optional.ofNullable(this.getUnderlyingIdOther()).ifPresent(builder::setUnderlyingIdOther);
            Optional.ofNullable(this.getUnderlyingIdOtherSource()).ifPresent(builder::setUnderlyingIdOtherSource);
            Optional.ofNullable(this.getUnderlyingAssetTradingPlatformIdentifier()).ifPresent(builder::setUnderlyingAssetTradingPlatformIdentifier);
            Optional.ofNullable(this.getUnderlyingAssetPriceSource()).ifPresent(builder::setUnderlyingAssetPriceSource);
            Optional.ofNullable(this.getCryptoAssetUnderlyingIndicator()).ifPresent(builder::setCryptoAssetUnderlyingIndicator);
            Optional.ofNullable(this.getLevel()).ifPresent(builder::setLevel);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getEventType()).ifPresent(builder::setEventType);
            Optional.ofNullable(this.getEventIdentifier()).ifPresent(builder::setEventIdentifier);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestamp);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CriticalDataElement _that = (CriticalDataElement)this.getType().cast(o);
            if (!Objects.equals(this.leg1, _that.getLeg1())) {
                return false;
            }
            if (!Objects.equals(this.leg2, _that.getLeg2())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOther, _that.getUnderlyingIdOther())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetTradingPlatformIdentifier, _that.getUnderlyingAssetTradingPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetPriceSource, _that.getUnderlyingAssetPriceSource())) {
                return false;
            }
            if (!Objects.equals(this.cryptoAssetUnderlyingIndicator, _that.getCryptoAssetUnderlyingIndicator())) {
                return false;
            }
            if (!Objects.equals((Object)this.level, (Object)_that.getLevel())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals((Object)this.eventType, (Object)_that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            return Objects.equals(this.eventTimestamp, _that.getEventTimestamp());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.leg1 != null ? this.leg1.hashCode() : 0);
            _result = 31 * _result + (this.leg2 != null ? this.leg2.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOther != null ? this.underlyingIdOther.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOtherSource != null ? this.underlyingIdOtherSource.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetTradingPlatformIdentifier != null ? this.underlyingAssetTradingPlatformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetPriceSource != null ? this.underlyingAssetPriceSource.hashCode() : 0);
            _result = 31 * _result + (this.cryptoAssetUnderlyingIndicator != null ? this.cryptoAssetUnderlyingIndicator.hashCode() : 0);
            _result = 31 * _result + (this.level != null ? ((Object)((Object)this.level)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? ((Object)((Object)this.eventType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CriticalDataElement {leg1=" + String.valueOf(this.leg1) + ", leg2=" + String.valueOf(this.leg2) + ", underlyingIdOther=" + this.underlyingIdOther + ", underlyingIdOtherSource=" + String.valueOf(this.underlyingIdOtherSource) + ", underlyingAssetTradingPlatformIdentifier=" + this.underlyingAssetTradingPlatformIdentifier + ", underlyingAssetPriceSource=" + this.underlyingAssetPriceSource + ", cryptoAssetUnderlyingIndicator=" + this.cryptoAssetUnderlyingIndicator + ", level=" + String.valueOf((Object)this.level) + ", actionType=" + String.valueOf((Object)this.actionType) + ", eventType=" + String.valueOf((Object)this.eventType) + ", eventIdentifier=" + this.eventIdentifier + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + "} " + super.toString();
        }
    }
}

