/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version3.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.common.functions.SettlementTermsLeg2;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.base.quantity.NotionalPeriod;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iosco.cde.version3.execution.reports.SettlementCurrencyRule;
import drr.standards.iosco.cde.version3.party.reports.Direction2Leg2Rule;
import drr.standards.iosco.cde.version3.payment.reports.PeriodicPaymentRule;
import drr.standards.iosco.cde.version3.price.reports.InterestRateFixedRateRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg2CurrencyRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg2Rule;
import drr.standards.iosco.cde.version3.quantity.functions.NotionalAmountLeg2;
import drr.standards.iosco.cde.version3.quantity.functions.TotalNotionalQuantityLeg2;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleLeg2Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalCurrencyLeg2Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleLeg2Rule;
import drr.standards.iosco.cde.version3.quantity.reports.QuantityUnitOfMeasureLeg2Rule;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Leg2Default.class)
public abstract class Leg2
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Direction2Leg2Rule direction2Leg2Rule;
    @Inject
    protected InterestRateFixedRateRule interestRateFixedRateRule;
    @Inject
    protected InterestRateLeg2 interestRateLeg2;
    @Inject
    protected NotionalAmountLeg2 notionalAmountLeg2;
    @Inject
    protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
    @Inject
    protected NotionalCurrencyLeg2Rule notionalCurrencyLeg2Rule;
    @Inject
    protected NotionalQuantityScheduleLeg2Rule notionalQuantityScheduleLeg2Rule;
    @Inject
    protected PeriodicPaymentRule periodicPaymentRule;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected ProductOrUnderlierProduct productOrUnderlierProduct;
    @Inject
    protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
    @Inject
    protected SettlementCurrencyRule settlementCurrencyRule;
    @Inject
    protected SettlementTermsLeg2 settlementTermsLeg2;
    @Inject
    protected SpreadLeg2CurrencyRule spreadLeg2CurrencyRule;
    @Inject
    protected SpreadLeg2Rule spreadLeg2Rule;
    @Inject
    protected TotalNotionalQuantityLeg2 totalNotionalQuantityLeg2;

    public Leg evaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
        Leg leg;
        Leg.LegBuilder legBuilder = this.doEvaluate(transaction, spreadNotation, defaultValue);
        if (legBuilder == null) {
            leg = null;
        } else {
            leg = legBuilder.build();
            this.objectValidator.validate(Leg.class, (RosettaModelObject)leg);
        }
        return leg;
    }

    protected abstract Leg.LegBuilder doEvaluate(TransactionReportInstruction var1, PriceNotationEnum var2, BigDecimal var3);

    public static class Leg2Default
    extends Leg2 {
        @Override
        protected Leg.LegBuilder doEvaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
            Leg.LegBuilder leg = Leg.builder();
            return this.assignOutput(leg, transaction, spreadNotation, defaultValue);
        }

        protected Leg.LegBuilder assignOutput(Leg.LegBuilder leg, TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
            leg = (Leg.LegBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)transaction).mapSingleToItem(item -> {
                MapperS thenArg0 = item.mapSingleToItem(_item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEvent)_item.get())));
                MapperS thenArg1 = thenArg0.mapSingleToItem(_item -> MapperS.of((Object)this.productOrUnderlierProduct.evaluate((Product)_item.get())));
                MapperS thenArg2 = item.mapSingleToItem(_item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEvent)_item.get())));
                MapperS thenArg3 = thenArg2.mapSingleToItem(_item -> MapperS.of((Object)this.settlementTermsLeg2.evaluate((Product)_item.get())));
                return MapperS.of((Object)Leg.builder().setPeriodicPayment(this.periodicPaymentRule.evaluate(this.interestRateLeg2.evaluate(this.productOrUnderlierProduct.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()))))).setFixedRate((BigDecimal)MapperS.of((Object)this.interestRateFixedRateRule.evaluate(this.interestRateLeg2.evaluate((Product)thenArg1.get()))).get()).setNotionalAmount(this.notionalAmountLeg2.evaluate(transaction, defaultValue)).setNotionalCurrency(this.notionalCurrencyLeg2Rule.evaluate((TransactionReportInstruction)item.get())).setTotalNotionalQuantity(this.totalNotionalQuantityLeg2.evaluate(transaction, defaultValue)).setNotionalAmountSchedule(new ArrayList<NotionalPeriod>(this.notionalAmountScheduleLeg2Rule.evaluate((TransactionReportInstruction)item.get()))).setNotionalQuantitySchedule(new ArrayList<NotionalPeriod>(this.notionalQuantityScheduleLeg2Rule.evaluate((TransactionReportInstruction)item.get()))).setSettlementCurrency((ISOCurrencyCodeEnum)thenArg3.mapSingleToItem(_item -> MapperS.of((Object)this.settlementCurrencyRule.evaluate((SettlementTerms)_item.get()))).get()).setSpread((PriceFormat)item.mapSingleToItem(_item -> MapperS.of((Object)this.priceFormatFromNotation.evaluate((BigDecimal)MapperS.of((Object)this.spreadLeg2Rule.evaluate((TransactionReportInstruction)_item.get())).map("getValue", priceSchedule -> priceSchedule.getValue()).get(), spreadNotation))).get()).setSpreadNotation(spreadNotation).setSpreadCurrency((ISOCurrencyCodeEnum)item.mapSingleToItem(_item -> MapperS.of((Object)this.spreadLeg2CurrencyRule.evaluate((TransactionReportInstruction)_item.get()))).get()).setQuantityUnitOfMeasure(this.quantityUnitOfMeasureLeg2Rule.evaluate((TransactionReportInstruction)item.get())).setDirection2(this.direction2Leg2Rule.evaluate((TransactionReportInstruction)item.get())).build());
            }).get());
            return Optional.ofNullable(leg).map(o -> o.prune()).orElse(null);
        }
    }
}

