/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version3.quantity.reports;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.GetLeg1ResolvablePriceQuantity;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.base.quantity.NotionalPeriod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=NotionalAmountScheduleLeg1RuleDefault.class)
public abstract class NotionalAmountScheduleLeg1Rule
implements ReportFunction<TransactionReportInstruction, List<? extends NotionalPeriod>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
    @Inject
    protected GetLeg1ResolvablePriceQuantity getLeg1ResolvablePriceQuantity;
    @Inject
    protected TradeForEvent tradeForEvent;

    public List<? extends NotionalPeriod> evaluate(TransactionReportInstruction input) {
        List output;
        List<NotionalPeriod.NotionalPeriodBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(NotionalPeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(NotionalPeriod.class, output);
        }
        return output;
    }

    protected abstract List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class NotionalAmountScheduleLeg1RuleDefault
    extends NotionalAmountScheduleLeg1Rule {
        @Override
        protected List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<NotionalPeriod.NotionalPeriodBuilder> output = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<NotionalPeriod.NotionalPeriodBuilder> assignOutput(List<NotionalPeriod.NotionalPeriodBuilder> output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.getLeg1ResolvablePriceQuantity.evaluate((Trade)item.get())).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()));
            MapperS thenArg2 = thenArg1.filterSingleNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).get());
            MapperC thenArg3 = thenArg2.mapSingleToList(item -> item.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()));
            output = this.toBuilder(thenArg3.mapItem(notionalAmountPeriod -> {
                MapperS thenArg = notionalAmountPeriod.map("getValue", datedValue -> datedValue.getValue());
                return MapperS.of((Object)NotionalPeriod.builder().setValue((BigDecimal)MapperS.of((Object)this.formatToShortFraction5DecimalNumber.evaluate((BigDecimal)thenArg.get())).get()).setEffectiveDate((Date)notionalAmountPeriod.map("getDate", datedValue -> datedValue.getDate()).get()).setEndDate(null).build());
            }).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

