/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util.types;

import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeVisitor;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class JavaTypeVariable
implements JavaReferenceType {
    private final JavaGenericTypeDeclaration<?> declaration;
    private final String name;
    private final List<JavaReferenceType> bounds;

    public JavaTypeVariable(JavaGenericTypeDeclaration<?> declaration, String name, JavaReferenceType ... bounds) {
        Objects.requireNonNull(declaration);
        Objects.requireNonNull(name);
        Validate.noNullElements((Object[])bounds);
        this.declaration = declaration;
        this.name = name;
        this.bounds = Arrays.asList(bounds);
    }

    public static JavaTypeVariable from(JavaGenericTypeDeclaration<?> declaration, TypeVariable<?> var, Map<TypeVariable<?>, JavaTypeVariable> context) {
        JavaReferenceType[] bounds = new JavaReferenceType[var.getBounds().length];
        for (int i = 0; i < var.getBounds().length; ++i) {
            JavaType bound = JavaType.from(var.getBounds()[i], context);
            if (!(bound instanceof JavaReferenceType)) {
                return null;
            }
            bounds[i] = (JavaReferenceType)bound;
        }
        return new JavaTypeVariable(declaration, var.getName(), bounds);
    }

    public static JavaTypeVariable from(TypeVariable<?> var, Map<TypeVariable<?>, JavaTypeVariable> context) {
        if (context.containsKey(var)) {
            return context.get(var);
        }
        if (var.getGenericDeclaration() instanceof Class) {
            JavaGenericTypeDeclaration declaration = JavaGenericTypeDeclaration.from((Class)var.getGenericDeclaration());
            return declaration.getParameters().stream().filter(p -> p.getName().equals(var.getName())).findAny().orElse(null);
        }
        return null;
    }

    public JavaGenericTypeDeclaration<?> getDeclaration() {
        return this.declaration;
    }

    public String getName() {
        return this.name;
    }

    public List<JavaReferenceType> getBounds() {
        return this.bounds;
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    @Override
    public boolean isSubtypeOf(JavaType other) {
        return this.bounds.stream().anyMatch(b -> b.isSubtypeOf(other));
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.declaration.getBaseType(), this.name, this.bounds);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JavaTypeVariable other = (JavaTypeVariable)object;
        return Objects.equals(this.declaration.getBaseType(), other.declaration.getBaseType()) && Objects.equals(this.name, other.name) && Objects.equals(this.bounds, other.bounds);
    }

    @Override
    public void accept(JavaTypeVisitor visitor) {
        visitor.visitType(this);
    }
}

