/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java;

import com.regnosys.rosetta.generator.GenerationException;
import com.regnosys.rosetta.generator.java.scoping.JavaClassScope;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.rosetta.util.types.JavaTypeDeclaration;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.util.CancelIndicator;

public abstract class JavaClassGenerator<T, C extends JavaTypeDeclaration<?>> {
    @Inject
    private ImportManagerExtension importManager;

    protected abstract Stream<? extends T> streamObjects(RosettaModel var1);

    protected abstract EObject getSource(T var1);

    protected abstract C createTypeRepresentation(T var1);

    protected abstract StringConcatenationClient generate(T var1, C var2, String var3, JavaClassScope var4);

    public List<GenerationException> generateClasses(RosettaModel model, String version, IFileSystemAccess2 fsa, CancelIndicator cancelIndicator) {
        ArrayList<GenerationException> generationExceptions = new ArrayList<GenerationException>();
        this.streamObjects(model).forEach(object -> {
            if (cancelIndicator.isCanceled()) {
                throw new CancellationException();
            }
            try {
                C typeRepresentation = this.createTypeRepresentation(object);
                JavaClassScope classScope = JavaClassScope.createAndRegisterIdentifier(typeRepresentation);
                StringConcatenationClient classCode = this.generate(object, typeRepresentation, version, classScope);
                String javaFileCode = this.importManager.buildClass(typeRepresentation.getPackageName(), classCode, classScope.getFileScope());
                fsa.generateFile(typeRepresentation.getCanonicalName().withForwardSlashes() + ".java", (CharSequence)javaFileCode);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (GenerationException e) {
                generationExceptions.add(e);
            }
            catch (Exception e) {
                EObject source = this.getSource(object);
                URI sourceURI = source == null ? model.eResource().getURI() : source.eResource().getURI();
                generationExceptions.add(new GenerationException(e.getMessage(), sourceURI, source, e));
            }
        });
        return generationExceptions;
    }
}

