/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.value;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.value.ValueAdjustment;
import com.opengamma.strata.basics.value.ValueAdjustmentType;
import com.opengamma.strata.basics.value.ValueStep;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ValueStepSequence
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LocalDate firstStepDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate lastStepDate;
    @PropertyDefinition(validate="notNull")
    private final Frequency frequency;
    @PropertyDefinition(validate="notNull")
    private final ValueAdjustment adjustment;
    private static final long serialVersionUID = 1L;

    public static ValueStepSequence of(LocalDate firstStepDate, LocalDate lastStepDate, Frequency frequency, ValueAdjustment adjustment) {
        return new ValueStepSequence(firstStepDate, lastStepDate, frequency, adjustment);
    }

    private void validate() {
        ArgChecker.inOrderOrEqual((Comparable)this.firstStepDate, (Object)this.lastStepDate, (String)"firstStepDate", (String)"lastStepDate");
        ArgChecker.isTrue((this.adjustment.getType() != ValueAdjustmentType.REPLACE ? 1 : 0) != 0, (String)"ValueAdjustmentType must not be 'Replace'");
    }

    List<ValueStep> resolve(List<ValueStep> existingSteps, RollConvention rollConv) {
        ImmutableList.Builder steps = ImmutableList.builder();
        steps.addAll(existingSteps);
        LocalDate prev = this.firstStepDate;
        LocalDate date = this.firstStepDate;
        while (!date.isAfter(this.lastStepDate)) {
            steps.add((Object)ValueStep.of(date, this.adjustment));
            prev = date;
            date = rollConv.next(date, this.frequency);
        }
        if (!prev.equals(this.lastStepDate)) {
            throw new IllegalArgumentException(Messages.format((String)"ValueStepSequence lastStepDate did not match frequency '{}' using roll convention '{}', {} != {}", (Object[])new Object[]{this.frequency, rollConv, this.lastStepDate, prev}));
        }
        return steps.build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ValueStepSequence(LocalDate firstStepDate, LocalDate lastStepDate, Frequency frequency, ValueAdjustment adjustment) {
        JodaBeanUtils.notNull((Object)firstStepDate, (String)"firstStepDate");
        JodaBeanUtils.notNull((Object)lastStepDate, (String)"lastStepDate");
        JodaBeanUtils.notNull((Object)frequency, (String)"frequency");
        JodaBeanUtils.notNull((Object)adjustment, (String)"adjustment");
        this.firstStepDate = firstStepDate;
        this.lastStepDate = lastStepDate;
        this.frequency = frequency;
        this.adjustment = adjustment;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LocalDate getFirstStepDate() {
        return this.firstStepDate;
    }

    public LocalDate getLastStepDate() {
        return this.lastStepDate;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public ValueAdjustment getAdjustment() {
        return this.adjustment;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ValueStepSequence other = (ValueStepSequence)obj;
            return JodaBeanUtils.equal((Object)this.firstStepDate, (Object)other.firstStepDate) && JodaBeanUtils.equal((Object)this.lastStepDate, (Object)other.lastStepDate) && JodaBeanUtils.equal((Object)this.frequency, (Object)other.frequency) && JodaBeanUtils.equal((Object)this.adjustment, (Object)other.adjustment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.firstStepDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastStepDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.frequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.adjustment);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("ValueStepSequence{");
        buf.append("firstStepDate").append('=').append(this.firstStepDate).append(',').append(' ');
        buf.append("lastStepDate").append('=').append(this.lastStepDate).append(',').append(' ');
        buf.append("frequency").append('=').append(this.frequency).append(',').append(' ');
        buf.append("adjustment").append('=').append(JodaBeanUtils.toString((Object)this.adjustment));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ValueStepSequence> {
        private LocalDate firstStepDate;
        private LocalDate lastStepDate;
        private Frequency frequency;
        private ValueAdjustment adjustment;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1025397910: {
                    return this.firstStepDate;
                }
                case -292412080: {
                    return this.lastStepDate;
                }
                case -70023844: {
                    return this.frequency;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1025397910: {
                    this.firstStepDate = (LocalDate)newValue;
                    break;
                }
                case -292412080: {
                    this.lastStepDate = (LocalDate)newValue;
                    break;
                }
                case -70023844: {
                    this.frequency = (Frequency)newValue;
                    break;
                }
                case 1977085293: {
                    this.adjustment = (ValueAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ValueStepSequence build() {
            return new ValueStepSequence(this.firstStepDate, this.lastStepDate, this.frequency, this.adjustment);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ValueStepSequence.Builder{");
            buf.append("firstStepDate").append('=').append(JodaBeanUtils.toString((Object)this.firstStepDate)).append(',').append(' ');
            buf.append("lastStepDate").append('=').append(JodaBeanUtils.toString((Object)this.lastStepDate)).append(',').append(' ');
            buf.append("frequency").append('=').append(JodaBeanUtils.toString((Object)this.frequency)).append(',').append(' ');
            buf.append("adjustment").append('=').append(JodaBeanUtils.toString((Object)this.adjustment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> firstStepDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"firstStepDate", ValueStepSequence.class, LocalDate.class);
        private final MetaProperty<LocalDate> lastStepDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastStepDate", ValueStepSequence.class, LocalDate.class);
        private final MetaProperty<Frequency> frequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"frequency", ValueStepSequence.class, Frequency.class);
        private final MetaProperty<ValueAdjustment> adjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"adjustment", ValueStepSequence.class, ValueAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"firstStepDate", "lastStepDate", "frequency", "adjustment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1025397910: {
                    return this.firstStepDate;
                }
                case -292412080: {
                    return this.lastStepDate;
                }
                case -70023844: {
                    return this.frequency;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ValueStepSequence> builder() {
            return new Builder();
        }

        public Class<? extends ValueStepSequence> beanType() {
            return ValueStepSequence.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> firstStepDate() {
            return this.firstStepDate;
        }

        public MetaProperty<LocalDate> lastStepDate() {
            return this.lastStepDate;
        }

        public MetaProperty<Frequency> frequency() {
            return this.frequency;
        }

        public MetaProperty<ValueAdjustment> adjustment() {
            return this.adjustment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1025397910: {
                    return ((ValueStepSequence)bean).getFirstStepDate();
                }
                case -292412080: {
                    return ((ValueStepSequence)bean).getLastStepDate();
                }
                case -70023844: {
                    return ((ValueStepSequence)bean).getFrequency();
                }
                case 1977085293: {
                    return ((ValueStepSequence)bean).getAdjustment();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

