package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.ASICLegEnrichment;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg1Rule;
import drr.standards.iosco.cde.base.quantity.NotionalPeriod;
import drr.standards.iosco.cde.version3.functions.Leg1;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleLeg1Rule;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Leg1ReportRule.Leg1ReportRuleDefault.class)
public abstract class Leg1ReportRule implements ReportFunction<TransactionReportInstruction, CommonLeg> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ASICLegEnrichment aSICLegEnrichment;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected Leg1 leg1;
	@Inject protected LegEnrichment legEnrichment;
	@Inject protected NextFloatingReferenceResetDateLeg1Rule nextFloatingReferenceResetDateLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
	@Inject protected SpreadLeg1NotationRule spreadLeg1NotationRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CommonLeg evaluate(TransactionReportInstruction input) {
		CommonLeg.CommonLegBuilder outputBuilder = doEvaluate(input);
		
		final CommonLeg output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CommonLeg.class, output);
		}
		
		return output;
	}

	protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input);

	public static class Leg1ReportRuleDefault extends Leg1ReportRule {
		@Override
		protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
			CommonLeg.CommonLegBuilder output = CommonLeg.builder();
			return assignOutput(output, input);
		}
		
		protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<CommonLeg> ifThenElseResult;
			if (exists(thenArg).getOrDefault(false)) {
				final BigInteger bigInteger = new BigInteger("9999999999999999999999999");
				ifThenElseResult = MapperS.of(aSICLegEnrichment.evaluate(legEnrichment.evaluate(leg1.evaluate(thenArg.get(), spreadLeg1NotationRule.evaluate(thenArg.get()), (bigInteger == null ? null : new BigDecimal(bigInteger))), notionalAmountScheduleLeg1Rule.evaluate(thenArg.get()), Collections.<NotionalPeriod>emptyList(), notionalQuantityLeg1Rule.evaluate(thenArg.get()), null, null, null, null, null, null, null, null, null, null), nextFloatingReferenceResetDateLeg1Rule.evaluate(thenArg.get())));
			} else {
				ifThenElseResult = MapperS.<CommonLeg>ofNull();
			}
			output = toBuilder(ifThenElseResult.get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
