package drr.regulation.asic.rewrite.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.asic.rewrite.valuation.meta.ASICValuationReportMeta;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.17.1
 */
@RosettaDataType(value="ASICValuationReport", builder=ASICValuationReport.ASICValuationReportBuilderImpl.class, version="6.17.1")
@RuneDataType(value="ASICValuationReport", model="drr", builder=ASICValuationReport.ASICValuationReportBuilderImpl.class, version="6.17.1")
public interface ASICValuationReport extends RosettaModelObject {

	ASICValuationReportMeta metaData = new ASICValuationReportMeta();

	/*********************** Getter Methods  ***********************/
	String getUniqueTransactionIdentifier();
	String getUtiProprietaryID();
	String getReportingEntity();
	String getCounterparty1();
	String getCounterparty2();
	Boolean getCounterparty2IdentifierTypeIndicator();
	String getExecutionAgentOfTheCounterparty1();
	String getActionType();
	ZonedDateTime getReportingTimestamp();
	String getReportSubmittingEntityID();
	String getSmallScaleBuySideEntityIndicator();
	ZonedDateTime getValuationTimestamp();
	BigDecimal getValuationAmount();
	ISOCurrencyCodeEnum getValuationCurrency();
	ValuationType1Code getValuationMethod();
	BigDecimal getDelta();
	Date getNextFloatingReferenceResetDateLeg1();
	Date getNextFloatingReferenceResetDateLeg2();
	String getTechnicalRecordId();
	String getExecutionAgentOfTheCounterparty2();

	/*********************** Build Methods  ***********************/
	ASICValuationReport build();
	
	ASICValuationReport.ASICValuationReportBuilder toBuilder();
	
	static ASICValuationReport.ASICValuationReportBuilder builder() {
		return new ASICValuationReport.ASICValuationReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ASICValuationReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ASICValuationReport> getType() {
		return ASICValuationReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("utiProprietaryID"), String.class, getUtiProprietaryID(), this);
		processor.processBasic(path.newSubPath("reportingEntity"), String.class, getReportingEntity(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, getCounterparty2IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, getExecutionAgentOfTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, getSmallScaleBuySideEntityIndicator(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
		processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, getNextFloatingReferenceResetDateLeg1(), this);
		processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, getNextFloatingReferenceResetDateLeg2(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty2"), String.class, getExecutionAgentOfTheCounterparty2(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ASICValuationReportBuilder extends ASICValuationReport, RosettaModelObjectBuilder {
		ASICValuationReport.ASICValuationReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		ASICValuationReport.ASICValuationReportBuilder setUtiProprietaryID(String utiProprietaryID);
		ASICValuationReport.ASICValuationReportBuilder setReportingEntity(String reportingEntity);
		ASICValuationReport.ASICValuationReportBuilder setCounterparty1(String counterparty1);
		ASICValuationReport.ASICValuationReportBuilder setCounterparty2(String counterparty2);
		ASICValuationReport.ASICValuationReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean counterparty2IdentifierTypeIndicator);
		ASICValuationReport.ASICValuationReportBuilder setExecutionAgentOfTheCounterparty1(String executionAgentOfTheCounterparty1);
		ASICValuationReport.ASICValuationReportBuilder setActionType(String actionType);
		ASICValuationReport.ASICValuationReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		ASICValuationReport.ASICValuationReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		ASICValuationReport.ASICValuationReportBuilder setSmallScaleBuySideEntityIndicator(String smallScaleBuySideEntityIndicator);
		ASICValuationReport.ASICValuationReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		ASICValuationReport.ASICValuationReportBuilder setValuationAmount(BigDecimal valuationAmount);
		ASICValuationReport.ASICValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		ASICValuationReport.ASICValuationReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		ASICValuationReport.ASICValuationReportBuilder setDelta(BigDecimal delta);
		ASICValuationReport.ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date nextFloatingReferenceResetDateLeg1);
		ASICValuationReport.ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date nextFloatingReferenceResetDateLeg2);
		ASICValuationReport.ASICValuationReportBuilder setTechnicalRecordId(String technicalRecordId);
		ASICValuationReport.ASICValuationReportBuilder setExecutionAgentOfTheCounterparty2(String executionAgentOfTheCounterparty2);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("utiProprietaryID"), String.class, getUtiProprietaryID(), this);
			processor.processBasic(path.newSubPath("reportingEntity"), String.class, getReportingEntity(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, getCounterparty2IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, getExecutionAgentOfTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, getSmallScaleBuySideEntityIndicator(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
			processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, getNextFloatingReferenceResetDateLeg1(), this);
			processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, getNextFloatingReferenceResetDateLeg2(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty2"), String.class, getExecutionAgentOfTheCounterparty2(), this);
		}
		

		ASICValuationReport.ASICValuationReportBuilder prune();
	}

	/*********************** Immutable Implementation of ASICValuationReport  ***********************/
	class ASICValuationReportImpl implements ASICValuationReport {
		private final String uniqueTransactionIdentifier;
		private final String utiProprietaryID;
		private final String reportingEntity;
		private final String counterparty1;
		private final String counterparty2;
		private final Boolean counterparty2IdentifierTypeIndicator;
		private final String executionAgentOfTheCounterparty1;
		private final String actionType;
		private final ZonedDateTime reportingTimestamp;
		private final String reportSubmittingEntityID;
		private final String smallScaleBuySideEntityIndicator;
		private final ZonedDateTime valuationTimestamp;
		private final BigDecimal valuationAmount;
		private final ISOCurrencyCodeEnum valuationCurrency;
		private final ValuationType1Code valuationMethod;
		private final BigDecimal delta;
		private final Date nextFloatingReferenceResetDateLeg1;
		private final Date nextFloatingReferenceResetDateLeg2;
		private final String technicalRecordId;
		private final String executionAgentOfTheCounterparty2;
		
		protected ASICValuationReportImpl(ASICValuationReport.ASICValuationReportBuilder builder) {
			this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
			this.utiProprietaryID = builder.getUtiProprietaryID();
			this.reportingEntity = builder.getReportingEntity();
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.counterparty2IdentifierTypeIndicator = builder.getCounterparty2IdentifierTypeIndicator();
			this.executionAgentOfTheCounterparty1 = builder.getExecutionAgentOfTheCounterparty1();
			this.actionType = builder.getActionType();
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
			this.smallScaleBuySideEntityIndicator = builder.getSmallScaleBuySideEntityIndicator();
			this.valuationTimestamp = builder.getValuationTimestamp();
			this.valuationAmount = builder.getValuationAmount();
			this.valuationCurrency = builder.getValuationCurrency();
			this.valuationMethod = builder.getValuationMethod();
			this.delta = builder.getDelta();
			this.nextFloatingReferenceResetDateLeg1 = builder.getNextFloatingReferenceResetDateLeg1();
			this.nextFloatingReferenceResetDateLeg2 = builder.getNextFloatingReferenceResetDateLeg2();
			this.technicalRecordId = builder.getTechnicalRecordId();
			this.executionAgentOfTheCounterparty2 = builder.getExecutionAgentOfTheCounterparty2();
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("utiProprietaryID")
		@RuneAttribute("utiProprietaryID")
		public String getUtiProprietaryID() {
			return utiProprietaryID;
		}
		
		@Override
		@RosettaAttribute(value="reportingEntity", isRequired=true)
		@RuneAttribute(value="reportingEntity", isRequired=true)
		public String getReportingEntity() {
			return reportingEntity;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		public Boolean getCounterparty2IdentifierTypeIndicator() {
			return counterparty2IdentifierTypeIndicator;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfTheCounterparty1")
		@RuneAttribute("executionAgentOfTheCounterparty1")
		public String getExecutionAgentOfTheCounterparty1() {
			return executionAgentOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("smallScaleBuySideEntityIndicator")
		@RuneAttribute("smallScaleBuySideEntityIndicator")
		public String getSmallScaleBuySideEntityIndicator() {
			return smallScaleBuySideEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="valuationTimestamp", isRequired=true)
		@RuneAttribute(value="valuationTimestamp", isRequired=true)
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="valuationAmount", isRequired=true)
		@RuneAttribute(value="valuationAmount", isRequired=true)
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute(value="valuationCurrency", isRequired=true)
		@RuneAttribute(value="valuationCurrency", isRequired=true)
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute(value="valuationMethod", isRequired=true)
		@RuneAttribute(value="valuationMethod", isRequired=true)
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		public Date getNextFloatingReferenceResetDateLeg1() {
			return nextFloatingReferenceResetDateLeg1;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		public Date getNextFloatingReferenceResetDateLeg2() {
			return nextFloatingReferenceResetDateLeg2;
		}
		
		@Override
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfTheCounterparty2")
		@RuneAttribute("executionAgentOfTheCounterparty2")
		public String getExecutionAgentOfTheCounterparty2() {
			return executionAgentOfTheCounterparty2;
		}
		
		@Override
		public ASICValuationReport build() {
			return this;
		}
		
		@Override
		public ASICValuationReport.ASICValuationReportBuilder toBuilder() {
			ASICValuationReport.ASICValuationReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ASICValuationReport.ASICValuationReportBuilder builder) {
			ofNullable(getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
			ofNullable(getUtiProprietaryID()).ifPresent(builder::setUtiProprietaryID);
			ofNullable(getReportingEntity()).ifPresent(builder::setReportingEntity);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCounterparty2IdentifierTypeIndicator()).ifPresent(builder::setCounterparty2IdentifierTypeIndicator);
			ofNullable(getExecutionAgentOfTheCounterparty1()).ifPresent(builder::setExecutionAgentOfTheCounterparty1);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
			ofNullable(getSmallScaleBuySideEntityIndicator()).ifPresent(builder::setSmallScaleBuySideEntityIndicator);
			ofNullable(getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
			ofNullable(getValuationAmount()).ifPresent(builder::setValuationAmount);
			ofNullable(getValuationCurrency()).ifPresent(builder::setValuationCurrency);
			ofNullable(getValuationMethod()).ifPresent(builder::setValuationMethod);
			ofNullable(getDelta()).ifPresent(builder::setDelta);
			ofNullable(getNextFloatingReferenceResetDateLeg1()).ifPresent(builder::setNextFloatingReferenceResetDateLeg1);
			ofNullable(getNextFloatingReferenceResetDateLeg2()).ifPresent(builder::setNextFloatingReferenceResetDateLeg2);
			ofNullable(getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
			ofNullable(getExecutionAgentOfTheCounterparty2()).ifPresent(builder::setExecutionAgentOfTheCounterparty2);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ASICValuationReport _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(utiProprietaryID, _that.getUtiProprietaryID())) return false;
			if (!Objects.equals(reportingEntity, _that.getReportingEntity())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) return false;
			if (!Objects.equals(executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(executionAgentOfTheCounterparty2, _that.getExecutionAgentOfTheCounterparty2())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (utiProprietaryID != null ? utiProprietaryID.hashCode() : 0);
			_result = 31 * _result + (reportingEntity != null ? reportingEntity.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierTypeIndicator != null ? counterparty2IdentifierTypeIndicator.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfTheCounterparty1 != null ? executionAgentOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (smallScaleBuySideEntityIndicator != null ? smallScaleBuySideEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg1 != null ? nextFloatingReferenceResetDateLeg1.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg2 != null ? nextFloatingReferenceResetDateLeg2.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfTheCounterparty2 != null ? executionAgentOfTheCounterparty2.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ASICValuationReport {" +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"utiProprietaryID=" + this.utiProprietaryID + ", " +
				"reportingEntity=" + this.reportingEntity + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", " +
				"executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", " +
				"actionType=" + this.actionType + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"nextFloatingReferenceResetDateLeg1=" + this.nextFloatingReferenceResetDateLeg1 + ", " +
				"nextFloatingReferenceResetDateLeg2=" + this.nextFloatingReferenceResetDateLeg2 + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"executionAgentOfTheCounterparty2=" + this.executionAgentOfTheCounterparty2 +
			'}';
		}
	}

	/*********************** Builder Implementation of ASICValuationReport  ***********************/
	class ASICValuationReportBuilderImpl implements ASICValuationReport.ASICValuationReportBuilder {
	
		protected String uniqueTransactionIdentifier;
		protected String utiProprietaryID;
		protected String reportingEntity;
		protected String counterparty1;
		protected String counterparty2;
		protected Boolean counterparty2IdentifierTypeIndicator;
		protected String executionAgentOfTheCounterparty1;
		protected String actionType;
		protected ZonedDateTime reportingTimestamp;
		protected String reportSubmittingEntityID;
		protected String smallScaleBuySideEntityIndicator;
		protected ZonedDateTime valuationTimestamp;
		protected BigDecimal valuationAmount;
		protected ISOCurrencyCodeEnum valuationCurrency;
		protected ValuationType1Code valuationMethod;
		protected BigDecimal delta;
		protected Date nextFloatingReferenceResetDateLeg1;
		protected Date nextFloatingReferenceResetDateLeg2;
		protected String technicalRecordId;
		protected String executionAgentOfTheCounterparty2;
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("utiProprietaryID")
		@RuneAttribute("utiProprietaryID")
		public String getUtiProprietaryID() {
			return utiProprietaryID;
		}
		
		@Override
		@RosettaAttribute(value="reportingEntity", isRequired=true)
		@RuneAttribute(value="reportingEntity", isRequired=true)
		public String getReportingEntity() {
			return reportingEntity;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		public Boolean getCounterparty2IdentifierTypeIndicator() {
			return counterparty2IdentifierTypeIndicator;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfTheCounterparty1")
		@RuneAttribute("executionAgentOfTheCounterparty1")
		public String getExecutionAgentOfTheCounterparty1() {
			return executionAgentOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("smallScaleBuySideEntityIndicator")
		@RuneAttribute("smallScaleBuySideEntityIndicator")
		public String getSmallScaleBuySideEntityIndicator() {
			return smallScaleBuySideEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="valuationTimestamp", isRequired=true)
		@RuneAttribute(value="valuationTimestamp", isRequired=true)
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="valuationAmount", isRequired=true)
		@RuneAttribute(value="valuationAmount", isRequired=true)
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute(value="valuationCurrency", isRequired=true)
		@RuneAttribute(value="valuationCurrency", isRequired=true)
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute(value="valuationMethod", isRequired=true)
		@RuneAttribute(value="valuationMethod", isRequired=true)
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		public Date getNextFloatingReferenceResetDateLeg1() {
			return nextFloatingReferenceResetDateLeg1;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		public Date getNextFloatingReferenceResetDateLeg2() {
			return nextFloatingReferenceResetDateLeg2;
		}
		
		@Override
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfTheCounterparty2")
		@RuneAttribute("executionAgentOfTheCounterparty2")
		public String getExecutionAgentOfTheCounterparty2() {
			return executionAgentOfTheCounterparty2;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@RosettaAttribute("utiProprietaryID")
		@RuneAttribute("utiProprietaryID")
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setUtiProprietaryID(String _utiProprietaryID) {
			this.utiProprietaryID = _utiProprietaryID == null ? null : _utiProprietaryID;
			return this;
		}
		
		@RosettaAttribute(value="reportingEntity", isRequired=true)
		@RuneAttribute(value="reportingEntity", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setReportingEntity(String _reportingEntity) {
			this.reportingEntity = _reportingEntity == null ? null : _reportingEntity;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean _counterparty2IdentifierTypeIndicator) {
			this.counterparty2IdentifierTypeIndicator = _counterparty2IdentifierTypeIndicator == null ? null : _counterparty2IdentifierTypeIndicator;
			return this;
		}
		
		@RosettaAttribute("executionAgentOfTheCounterparty1")
		@RuneAttribute("executionAgentOfTheCounterparty1")
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setExecutionAgentOfTheCounterparty1(String _executionAgentOfTheCounterparty1) {
			this.executionAgentOfTheCounterparty1 = _executionAgentOfTheCounterparty1 == null ? null : _executionAgentOfTheCounterparty1;
			return this;
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setActionType(String _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@RosettaAttribute("smallScaleBuySideEntityIndicator")
		@RuneAttribute("smallScaleBuySideEntityIndicator")
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setSmallScaleBuySideEntityIndicator(String _smallScaleBuySideEntityIndicator) {
			this.smallScaleBuySideEntityIndicator = _smallScaleBuySideEntityIndicator == null ? null : _smallScaleBuySideEntityIndicator;
			return this;
		}
		
		@RosettaAttribute(value="valuationTimestamp", isRequired=true)
		@RuneAttribute(value="valuationTimestamp", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="valuationAmount", isRequired=true)
		@RuneAttribute(value="valuationAmount", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@RosettaAttribute(value="valuationCurrency", isRequired=true)
		@RuneAttribute(value="valuationCurrency", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@RosettaAttribute(value="valuationMethod", isRequired=true)
		@RuneAttribute(value="valuationMethod", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setDelta(BigDecimal _delta) {
			this.delta = _delta == null ? null : _delta;
			return this;
		}
		
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
			this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
			return this;
		}
		
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
			this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
			return this;
		}
		
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@RosettaAttribute("executionAgentOfTheCounterparty2")
		@RuneAttribute("executionAgentOfTheCounterparty2")
		@Override
		public ASICValuationReport.ASICValuationReportBuilder setExecutionAgentOfTheCounterparty2(String _executionAgentOfTheCounterparty2) {
			this.executionAgentOfTheCounterparty2 = _executionAgentOfTheCounterparty2 == null ? null : _executionAgentOfTheCounterparty2;
			return this;
		}
		
		@Override
		public ASICValuationReport build() {
			return new ASICValuationReport.ASICValuationReportImpl(this);
		}
		
		@Override
		public ASICValuationReport.ASICValuationReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ASICValuationReport.ASICValuationReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUniqueTransactionIdentifier()!=null) return true;
			if (getUtiProprietaryID()!=null) return true;
			if (getReportingEntity()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCounterparty2IdentifierTypeIndicator()!=null) return true;
			if (getExecutionAgentOfTheCounterparty1()!=null) return true;
			if (getActionType()!=null) return true;
			if (getReportingTimestamp()!=null) return true;
			if (getReportSubmittingEntityID()!=null) return true;
			if (getSmallScaleBuySideEntityIndicator()!=null) return true;
			if (getValuationTimestamp()!=null) return true;
			if (getValuationAmount()!=null) return true;
			if (getValuationCurrency()!=null) return true;
			if (getValuationMethod()!=null) return true;
			if (getDelta()!=null) return true;
			if (getNextFloatingReferenceResetDateLeg1()!=null) return true;
			if (getNextFloatingReferenceResetDateLeg2()!=null) return true;
			if (getTechnicalRecordId()!=null) return true;
			if (getExecutionAgentOfTheCounterparty2()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ASICValuationReport.ASICValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ASICValuationReport.ASICValuationReportBuilder o = (ASICValuationReport.ASICValuationReportBuilder) other;
			
			
			merger.mergeBasic(getUniqueTransactionIdentifier(), o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier);
			merger.mergeBasic(getUtiProprietaryID(), o.getUtiProprietaryID(), this::setUtiProprietaryID);
			merger.mergeBasic(getReportingEntity(), o.getReportingEntity(), this::setReportingEntity);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCounterparty2IdentifierTypeIndicator(), o.getCounterparty2IdentifierTypeIndicator(), this::setCounterparty2IdentifierTypeIndicator);
			merger.mergeBasic(getExecutionAgentOfTheCounterparty1(), o.getExecutionAgentOfTheCounterparty1(), this::setExecutionAgentOfTheCounterparty1);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getReportSubmittingEntityID(), o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID);
			merger.mergeBasic(getSmallScaleBuySideEntityIndicator(), o.getSmallScaleBuySideEntityIndicator(), this::setSmallScaleBuySideEntityIndicator);
			merger.mergeBasic(getValuationTimestamp(), o.getValuationTimestamp(), this::setValuationTimestamp);
			merger.mergeBasic(getValuationAmount(), o.getValuationAmount(), this::setValuationAmount);
			merger.mergeBasic(getValuationCurrency(), o.getValuationCurrency(), this::setValuationCurrency);
			merger.mergeBasic(getValuationMethod(), o.getValuationMethod(), this::setValuationMethod);
			merger.mergeBasic(getDelta(), o.getDelta(), this::setDelta);
			merger.mergeBasic(getNextFloatingReferenceResetDateLeg1(), o.getNextFloatingReferenceResetDateLeg1(), this::setNextFloatingReferenceResetDateLeg1);
			merger.mergeBasic(getNextFloatingReferenceResetDateLeg2(), o.getNextFloatingReferenceResetDateLeg2(), this::setNextFloatingReferenceResetDateLeg2);
			merger.mergeBasic(getTechnicalRecordId(), o.getTechnicalRecordId(), this::setTechnicalRecordId);
			merger.mergeBasic(getExecutionAgentOfTheCounterparty2(), o.getExecutionAgentOfTheCounterparty2(), this::setExecutionAgentOfTheCounterparty2);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ASICValuationReport _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(utiProprietaryID, _that.getUtiProprietaryID())) return false;
			if (!Objects.equals(reportingEntity, _that.getReportingEntity())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) return false;
			if (!Objects.equals(executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(executionAgentOfTheCounterparty2, _that.getExecutionAgentOfTheCounterparty2())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (utiProprietaryID != null ? utiProprietaryID.hashCode() : 0);
			_result = 31 * _result + (reportingEntity != null ? reportingEntity.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierTypeIndicator != null ? counterparty2IdentifierTypeIndicator.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfTheCounterparty1 != null ? executionAgentOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (smallScaleBuySideEntityIndicator != null ? smallScaleBuySideEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg1 != null ? nextFloatingReferenceResetDateLeg1.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg2 != null ? nextFloatingReferenceResetDateLeg2.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfTheCounterparty2 != null ? executionAgentOfTheCounterparty2.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ASICValuationReportBuilder {" +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"utiProprietaryID=" + this.utiProprietaryID + ", " +
				"reportingEntity=" + this.reportingEntity + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", " +
				"executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", " +
				"actionType=" + this.actionType + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"nextFloatingReferenceResetDateLeg1=" + this.nextFloatingReferenceResetDateLeg1 + ", " +
				"nextFloatingReferenceResetDateLeg2=" + this.nextFloatingReferenceResetDateLeg2 + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"executionAgentOfTheCounterparty2=" + this.executionAgentOfTheCounterparty2 +
			'}';
		}
	}
}
