package drr.regulation.cftc.rewrite.dtcc.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.ExecutionVenueTypeEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(DTCC_LargeNotionalOffFacilitySwapElectionIndicatorRule.DTCC_LargeNotionalOffFacilitySwapElectionIndicatorRuleDefault.class)
public abstract class DTCC_LargeNotionalOffFacilitySwapElectionIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCFTC isAllowableActionForCFTC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class DTCC_LargeNotionalOffFacilitySwapElectionIndicatorRuleDefault extends DTCC_LargeNotionalOffFacilitySwapElectionIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCFTC.evaluate(item.get()));
			final MapperS<ReportableInformation> thenArg1 = thenArg0
				.mapSingleToItem(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()));
			final MapperS<ReportableInformation> thenArg2 = thenArg1
				.filterSingleNullSafe(item -> areEqual(item.<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.Any).get());
			output = thenArg2
				.mapSingleToItem(item -> {
					if (areEqual(item.<Boolean>map("getLargeSizeTrade", reportableInformation -> reportableInformation.getLargeSizeTrade()), MapperS.of(true), CardinalityOperator.All).and(notEqual(item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType()), MapperS.of(ExecutionVenueTypeEnum.SEF), CardinalityOperator.Any).and(notEqual(item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType()), MapperS.of(ExecutionVenueTypeEnum.DCM), CardinalityOperator.Any))).getOrDefault(false)) {
						return MapperS.of(true);
					}
					return MapperS.of(false);
				}).get();
			
			return output;
		}
	}
}
