package drr.regulation.cftc.rewrite.dtcc.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.CFTCPartyInformation;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(DTCC_PhysicalCommodityContractIndicatorRule.DTCC_PhysicalCommodityContractIndicatorRuleDefault.class)
public abstract class DTCC_PhysicalCommodityContractIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCFTC isAllowableActionForCFTC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class DTCC_PhysicalCommodityContractIndicatorRuleDefault extends DTCC_PhysicalCommodityContractIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCFTC.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(reportInstruction -> {
					final MapperC<PartyInformation> thenArg0 = reportInstruction.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation())
						.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), reportInstruction.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()), CardinalityOperator.All).get());
					final MapperS<PartyInformation> thenArg1 = MapperS.of(thenArg0.get());
					return thenArg1
						.mapSingleToItem(item -> {
							if (exists(item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<CFTCPartyInformation>map("getCftcPartyInformation", reportingRegime -> reportingRegime.getCftcPartyInformation()).<Boolean>map("getPhysicalCommodityContractIndicator", cFTCPartyInformation -> cFTCPartyInformation.getPhysicalCommodityContractIndicator())).getOrDefault(false)) {
								return MapperS.of(item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<CFTCPartyInformation>map("getCftcPartyInformation", reportingRegime -> reportingRegime.getCftcPartyInformation()).<Boolean>map("getPhysicalCommodityContractIndicator", cFTCPartyInformation -> cFTCPartyInformation.getPhysicalCommodityContractIndicator()).get());
							}
							return MapperS.of(false);
						});
				}).get();
			
			return output;
		}
	}
}
