package drr.regulation.cftc.rewrite.valuation.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ValuationReportInstruction;
import drr.regulation.common.trade.link.functions.TechnicalRecordId;
import javax.inject.Inject;


@ImplementedBy(DTCC_MessageIDRule.DTCC_MessageIDRuleDefault.class)
public abstract class DTCC_MessageIDRule implements ReportFunction<ValuationReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected TechnicalRecordId technicalRecordId;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ValuationReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ValuationReportInstruction input);

	public static class DTCC_MessageIDRuleDefault extends DTCC_MessageIDRule {
		@Override
		protected String doEvaluate(ValuationReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ValuationReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperMaths.<String, String, String>add(MapperS.of(technicalRecordId.evaluate(item.<ReportableInformation>map("getReportableInformation", valuationReportInstruction -> valuationReportInstruction.getReportableInformation()).get(), RegimeNameEnum.DODD_FRANK_ACT)), MapperS.of(reportingTimestampRule.evaluate(item.get())).map("to-string", Object::toString))).get();
			
			return output;
		}
	}
}
