package drr.regulation.common.functions;

import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_BaseProduct_CrossCurrency;
import cdm.product.qualification.functions.Qualify_BaseProduct_EquitySwap;
import cdm.product.qualification.functions.Qualify_BaseProduct_IRSwap;
import cdm.product.qualification.functions.Qualify_BaseProduct_Inflation;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_EquityForward_PriceReturnBasicPerformance_Basket;
import cdm.product.qualification.functions.Qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex;
import cdm.product.qualification.functions.Qualify_EquityForward_PriceReturnBasicPerformance_SingleName;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDF;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Spot_Forward;
import cdm.product.qualification.functions.Qualify_InterestRate_CapFloor;
import cdm.product.qualification.functions.Qualify_InterestRate_Forward_Debt;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_Basis_YearOn_Year;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_Basis_ZeroCoupon;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.ReportableEvent;
import java.util.Arrays;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetContractType.GetContractTypeDefault.class)
public abstract class GetContractType implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCommodityForward isCommodityForward;
	@Inject protected IsCommoditySwaption isCommoditySwaption;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsEquityOther isEquityOther;
	@Inject protected IsFRA isFRA;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected IsProductETD isProductETD;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
	@Inject protected Qualify_BaseProduct_CrossCurrency qualify_BaseProduct_CrossCurrency;
	@Inject protected Qualify_BaseProduct_EquitySwap qualify_BaseProduct_EquitySwap;
	@Inject protected Qualify_BaseProduct_IRSwap qualify_BaseProduct_IRSwap;
	@Inject protected Qualify_BaseProduct_Inflation qualify_BaseProduct_Inflation;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_EquityForward_PriceReturnBasicPerformance_Basket qualify_EquityForward_PriceReturnBasicPerformance_Basket;
	@Inject protected Qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex;
	@Inject protected Qualify_EquityForward_PriceReturnBasicPerformance_SingleName qualify_EquityForward_PriceReturnBasicPerformance_SingleName;
	@Inject protected Qualify_ForeignExchange_NDF qualify_ForeignExchange_NDF;
	@Inject protected Qualify_ForeignExchange_Spot_Forward qualify_ForeignExchange_Spot_Forward;
	@Inject protected Qualify_InterestRate_CapFloor qualify_InterestRate_CapFloor;
	@Inject protected Qualify_InterestRate_Forward_Debt qualify_InterestRate_Forward_Debt;
	@Inject protected Qualify_InterestRate_InflationSwap_Basis_YearOn_Year qualify_InterestRate_InflationSwap_Basis_YearOn_Year;
	@Inject protected Qualify_InterestRate_InflationSwap_Basis_ZeroCoupon qualify_InterestRate_InflationSwap_Basis_ZeroCoupon;
	@Inject protected Qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year;
	@Inject protected Qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon;

	/**
	* @param reportableEvent 
	* @return contractType 
	*/
	public CommonContractType evaluate(ReportableEvent reportableEvent) {
		CommonContractType contractType = doEvaluate(reportableEvent);
		
		return contractType;
	}

	protected abstract CommonContractType doEvaluate(ReportableEvent reportableEvent);

	public static class GetContractTypeDefault extends GetContractType {
		@Override
		protected CommonContractType doEvaluate(ReportableEvent reportableEvent) {
			CommonContractType contractType = null;
			return assignOutput(contractType, reportableEvent);
		}
		
		protected CommonContractType assignOutput(CommonContractType contractType, ReportableEvent reportableEvent) {
			final MapperS<Product> thenArg = MapperS.of(productForEvent.evaluate(reportableEvent));
			contractType = thenArg
				.mapSingleToItem(item -> {
					final Boolean boolean0 = isProductETD.evaluate(item.get());
					if ((boolean0 == null ? false : boolean0)) {
						if (onlyExists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("forwardPayout")).getOrDefault(false)) {
							return MapperS.of(CommonContractType.FUTR);
						}
						if (onlyExists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("optionPayout")).getOrDefault(false)) {
							return MapperS.of(CommonContractType.OPTN);
						}
						return MapperS.of(CommonContractType.OTHR);
					}
					final Boolean boolean1 = isFRA.evaluate(item.get());
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(CommonContractType.FRAS);
					}
					if (ComparisonResult.of(MapperS.of(qualify_ForeignExchange_Spot_Forward.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_NDF.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).or(ComparisonResult.of(MapperS.of(isSingleCommodityPayoutProduct.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isCommodityForward.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_Forward_Debt.evaluate(economicTermsForProduct.evaluate(item.get()))))).or(ComparisonResult.of(MapperS.of(qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).or(ComparisonResult.of(MapperS.of(qualify_EquityForward_PriceReturnBasicPerformance_SingleName.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).or(ComparisonResult.of(MapperS.of(qualify_EquityForward_PriceReturnBasicPerformance_Basket.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))))).getOrDefault(false)) {
						return MapperS.of(CommonContractType.FORW);
					}
					if (ComparisonResult.of(MapperS.of(isIRSwaption.evaluate(item.get()))).or(ComparisonResult.of(MapperS.of(isCreditSwaption.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isCommoditySwaption.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of(CommonContractType.SWPT);
					}
					if (ComparisonResult.of(MapperS.of(qualify_InterestRate_CapFloor.evaluate(economicTermsForProduct.evaluate(item.get())))).or(onlyExists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("optionPayout")).and(notExists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Boolean>map("getNonStandardisedTerms", economicTerms -> economicTerms.getNonStandardisedTerms())).or(areEqual(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Boolean>map("getNonStandardisedTerms", economicTerms -> economicTerms.getNonStandardisedTerms()), MapperS.of(false), CardinalityOperator.All)))).getOrDefault(false)) {
						return MapperS.of(CommonContractType.OPTN);
					}
					if (ComparisonResult.of(MapperS.of(qualify_BaseProduct_IRSwap.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_Inflation.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_CrossCurrency.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_InflationSwap_Basis_YearOn_Year.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_InflationSwap_Basis_ZeroCoupon.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).or(ComparisonResult.of(MapperS.of(qualify_AssetClass_Credit.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).and(notExists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Boolean>map("getNonStandardisedTerms", economicTerms -> economicTerms.getNonStandardisedTerms())).or(areEqual(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Boolean>map("getNonStandardisedTerms", economicTerms -> economicTerms.getNonStandardisedTerms()), MapperS.of(false), CardinalityOperator.All)))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_EquitySwap.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).and(areEqual(MapperS.of(isEquityOther.evaluate(item.get())), MapperS.of(false), CardinalityOperator.All))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).or(ComparisonResult.of(MapperS.of(isFXSwap.evaluate(item.get())))).or(onlyExists(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("performancePayout"))).getOrDefault(false)) {
						return MapperS.of(CommonContractType.SWAP);
					}
					if (ComparisonResult.of(MapperS.of(isProductETD.evaluate(item.get()))).and(onlyExists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("forwardPayout"))).getOrDefault(false)) {
						return MapperS.of(CommonContractType.FUTR);
					}
					return MapperS.of(CommonContractType.OTHR);
				}).get();
			
			return contractType;
		}
	}
}
