package drr.regulation.common.functions;

import cdm.event.workflow.EventTimestamp;
import cdm.event.workflow.EventTimestampQualificationEnum;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import java.time.ZonedDateTime;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetExecutionTimestamp.GetExecutionTimestampDefault.class)
public abstract class GetExecutionTimestamp implements RosettaFunction {

	/**
	* @param reportableEvent 
	* @return executionTime 
	*/
	public ZonedDateTime evaluate(ReportableEvent reportableEvent) {
		ZonedDateTime executionTime = doEvaluate(reportableEvent);
		
		return executionTime;
	}

	protected abstract ZonedDateTime doEvaluate(ReportableEvent reportableEvent);

	public static class GetExecutionTimestampDefault extends GetExecutionTimestamp {
		@Override
		protected ZonedDateTime doEvaluate(ReportableEvent reportableEvent) {
			ZonedDateTime executionTime = null;
			return assignOutput(executionTime, reportableEvent);
		}
		
		protected ZonedDateTime assignOutput(ZonedDateTime executionTime, ReportableEvent reportableEvent) {
			if (exists(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<ZonedDateTime>map("getOriginalExecutionTimestamp", reportableInformation -> reportableInformation.getOriginalExecutionTimestamp())).getOrDefault(false)) {
				executionTime = MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<ZonedDateTime>map("getOriginalExecutionTimestamp", reportableInformation -> reportableInformation.getOriginalExecutionTimestamp()).get();
			} else {
				final MapperC<EventTimestamp> thenArg0 = MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<EventTimestamp>mapC("getTimestamp", workflowStep -> workflowStep.getTimestamp())
					.filterItemNullSafe(item -> areEqual(item.<EventTimestampQualificationEnum>map("getQualification", eventTimestamp -> eventTimestamp.getQualification()), MapperS.of(EventTimestampQualificationEnum.EXECUTION_DATE_TIME), CardinalityOperator.All).get());
				final MapperC<ZonedDateTime> thenArg1 = thenArg0
					.mapItem(item -> item.<ZonedDateTime>map("getDateTime", eventTimestamp -> eventTimestamp.getDateTime()));
				executionTime = MapperS.of(thenArg1.get()).get();
			}
			
			return executionTime;
		}
	}
}
