package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.util.functions.StringContains;
import javax.inject.Inject;


@ImplementedBy(IsCRPMetal.IsCRPMetalDefault.class)
public abstract class IsCRPMetal implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected StringContains stringContains;

	/**
	* @param identifier 
	* @return result 
	*/
	public Boolean evaluate(String identifier) {
		Boolean result = doEvaluate(identifier);
		
		return result;
	}

	protected abstract Boolean doEvaluate(String identifier);

	public static class IsCRPMetalDefault extends IsCRPMetal {
		@Override
		protected Boolean doEvaluate(String identifier) {
			Boolean result = null;
			return assignOutput(result, identifier);
		}
		
		protected Boolean assignOutput(Boolean result, String identifier) {
			result = ComparisonResult.of(MapperS.of(stringContains.evaluate(identifier, "ALUMINIUM-"))).or(ComparisonResult.of(MapperS.of(stringContains.evaluate(identifier, "COPPER-")))).or(ComparisonResult.of(MapperS.of(stringContains.evaluate(identifier, "IRON ORE-")))).or(ComparisonResult.of(MapperS.of(stringContains.evaluate(identifier, "LEAD-")))).or(ComparisonResult.of(MapperS.of(stringContains.evaluate(identifier, "NASAAC-")))).or(ComparisonResult.of(MapperS.of(stringContains.evaluate(identifier, "NICKEL-")))).or(ComparisonResult.of(MapperS.of(stringContains.evaluate(identifier, "STEEL-")))).or(ComparisonResult.of(MapperS.of(stringContains.evaluate(identifier, "TIN-")))).or(ComparisonResult.of(MapperS.of(stringContains.evaluate(identifier, "ZINC-")))).get();
			
			return result;
		}
	}
}
