package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableActionEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsEventTypeUPDT.IsEventTypeUPDTDefault.class)
public abstract class IsEventTypeUPDT implements RosettaFunction {

	/**
	* @param reportableEvent 
	* @return isEventTypeUpdt 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isEventTypeUpdt = doEvaluate(reportableEvent);
		
		return isEventTypeUpdt;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<ReportableActionEnum> event(ReportableEvent reportableEvent);

	public static class IsEventTypeUPDTDefault extends IsEventTypeUPDT {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isEventTypeUpdt = null;
			return assignOutput(isEventTypeUpdt, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isEventTypeUpdt, ReportableEvent reportableEvent) {
			isEventTypeUpdt = exists(event(reportableEvent)).and(areEqual(event(reportableEvent), MapperS.of(ReportableActionEnum.UPDATE), CardinalityOperator.All)).get();
			
			return isEventTypeUpdt;
		}
		
		@Override
		protected MapperS<ReportableActionEnum> event(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<ReportableActionEnum>map("getReportableAction", reportableInformation -> reportableInformation.getReportableAction());
		}
	}
}
