package drr.regulation.common.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SettlementTermsLeg2.SettlementTermsLeg2Default.class)
public abstract class SettlementTermsLeg2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FXNearLeg fXNearLeg;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsCommodityForward isCommodityForward;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsEquitySwapProduct isEquitySwapProduct;
	@Inject protected IsFXSwap isFXSwap;

	/**
	* @param product 
	* @return settlementTerms 
	*/
	public SettlementTerms evaluate(Product product) {
		SettlementTerms.SettlementTermsBuilder settlementTermsBuilder = doEvaluate(product);
		
		final SettlementTerms settlementTerms;
		if (settlementTermsBuilder == null) {
			settlementTerms = null;
		} else {
			settlementTerms = settlementTermsBuilder.build();
			objectValidator.validate(SettlementTerms.class, settlementTerms);
		}
		
		return settlementTerms;
	}

	protected abstract SettlementTerms.SettlementTermsBuilder doEvaluate(Product product);

	public static class SettlementTermsLeg2Default extends SettlementTermsLeg2 {
		@Override
		protected SettlementTerms.SettlementTermsBuilder doEvaluate(Product product) {
			SettlementTerms.SettlementTermsBuilder settlementTerms = SettlementTerms.builder();
			return assignOutput(settlementTerms, product);
		}
		
		protected SettlementTerms.SettlementTermsBuilder assignOutput(SettlementTerms.SettlementTermsBuilder settlementTerms, Product product) {
			if (exists(MapperS.of(interestRateLeg2.evaluate(product)).<SettlementTerms>map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms())).getOrDefault(false)) {
				settlementTerms = toBuilder(MapperS.of(interestRateLeg2.evaluate(product)).<SettlementTerms>map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms()).get());
			} else {
				final Boolean boolean0 = isFXSwap.evaluate(product);
				if ((boolean0 == null ? false : boolean0)) {
					settlementTerms = toBuilder(MapperS.of(fXNearLeg.evaluate(product)).<SettlementTerms>map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).get());
				} else {
					final Boolean boolean1 = isCommoditySwap.evaluate(product);
					if ((boolean1 == null ? false : boolean1)) {
						settlementTerms = toBuilder(MapperS.of(commodityLeg2.evaluate(product)).<SettlementTerms>map("getSettlementTerms", commodityPayout -> commodityPayout.getSettlementTerms()).get());
					} else if (ComparisonResult.of(MapperS.of(isCommodityForward.evaluate(product))).and(areEqual(exists(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
						settlementTerms = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<SettlementTerms>map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).get());
					} else if (ComparisonResult.of(MapperS.of(isEquitySwapProduct.evaluate(product))).and(exists(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()).<SettlementTerms>map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms()))).getOrDefault(false)) {
						settlementTerms = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()).<SettlementTerms>map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms()).get());
					} else if (exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<SettlementTerms>map("getSettlementTerms", performancePayout -> performancePayout.getSettlementTerms())).getOrDefault(false)) {
						settlementTerms = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<SettlementTerms>map("getSettlementTerms", performancePayout -> performancePayout.getSettlementTerms()).get());
					} else {
						settlementTerms = null;
					}
				}
			}
			
			return Optional.ofNullable(settlementTerms)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
