package drr.regulation.common.trade.basket.reports;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.template.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.functions.GetProductIdentifierFilteringISIN;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(BasketConstituentIdentifierRule.BasketConstituentIdentifierRuleDefault.class)
public abstract class BasketConstituentIdentifierRule implements ReportFunction<BasketConstituent, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetProductIdentifierFilteringISIN getProductIdentifierFilteringISIN;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(BasketConstituent input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(BasketConstituent input);

	public static class BasketConstituentIdentifierRuleDefault extends BasketConstituentIdentifierRule {
		@Override
		protected String doEvaluate(BasketConstituent input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, BasketConstituent input) {
			final MapperC<ReferenceWithMetaProductIdentifier> thenArg;
			if (exists(MapperS.of(input).<Security>map("getSecurity", basketConstituent -> basketConstituent.getSecurity())).getOrDefault(false)) {
				thenArg = MapperS.of(input).<Security>map("getSecurity", basketConstituent -> basketConstituent.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier());
			} else if (exists(MapperS.of(input).<Loan>map("getLoan", basketConstituent -> basketConstituent.getLoan())).getOrDefault(false)) {
				thenArg = MapperS.of(input).<Loan>map("getLoan", basketConstituent -> basketConstituent.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
			} else if (exists(MapperS.of(input).<ReferenceWithMetaCommodity>map("getCommodity", basketConstituent -> basketConstituent.getCommodity())).getOrDefault(false)) {
				thenArg = MapperS.of(input).<ReferenceWithMetaCommodity>map("getCommodity", basketConstituent -> basketConstituent.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
			} else if (exists(MapperS.of(input).<Index>map("getIndex", basketConstituent -> basketConstituent.getIndex())).getOrDefault(false)) {
				thenArg = MapperS.of(input).<Index>map("getIndex", basketConstituent -> basketConstituent.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
			} else {
				thenArg = MapperC.<ReferenceWithMetaProductIdentifier>ofNull();
			}
			final FieldWithMetaString fieldWithMetaString = MapperS.of(getProductIdentifierFilteringISIN.evaluate(thenArg.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti())).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
