package drr.regulation.common.trade.execution.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.common.CommonTransactionInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TradableOnTradingVenueEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iso.MicData;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PlatformIdentifierRule.PlatformIdentifierRuleDefault.class)
public abstract class PlatformIdentifierRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version3.execution.reports.PlatformIdentifierRule platformIdentifierRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class PlatformIdentifierRuleDefault extends PlatformIdentifierRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					if (notExists(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<EnrichmentData>map("getEnrichment", reportableInformation -> reportableInformation.getEnrichment()).<MicData>mapC("getMicData", enrichmentData -> enrichmentData.getMicData())).and(exists(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<TransactionInformation>mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation()).<CommonTransactionInformation>map("getMasTransactionInformation", transactionInformation -> transactionInformation.getMasTransactionInformation()))).getOrDefault(false)) {
						if (areEqual(MapperS.of(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<TransactionInformation>mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation()).<CommonTransactionInformation>map("getMasTransactionInformation", transactionInformation -> transactionInformation.getMasTransactionInformation()).get()).<TradableOnTradingVenueEnum>map("getTradableOnTradingVenue", commonTransactionInformation -> commonTransactionInformation.getTradableOnTradingVenue()), MapperS.of(TradableOnTradingVenueEnum.ADMITTED), CardinalityOperator.All).getOrDefault(false)) {
							return MapperS.of("XOFF");
						}
						if (areEqual(MapperS.of(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<TransactionInformation>mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation()).<CommonTransactionInformation>map("getMasTransactionInformation", transactionInformation -> transactionInformation.getMasTransactionInformation()).get()).<TradableOnTradingVenueEnum>map("getTradableOnTradingVenue", commonTransactionInformation -> commonTransactionInformation.getTradableOnTradingVenue()), MapperS.of(TradableOnTradingVenueEnum.NOT_ADMITTED), CardinalityOperator.All).getOrDefault(false)) {
							return MapperS.of("XXXX");
						}
						if (areEqual(MapperS.of(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<TransactionInformation>mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation()).<CommonTransactionInformation>map("getMasTransactionInformation", transactionInformation -> transactionInformation.getMasTransactionInformation()).get()).<TradableOnTradingVenueEnum>map("getTradableOnTradingVenue", commonTransactionInformation -> commonTransactionInformation.getTradableOnTradingVenue()), MapperS.of(TradableOnTradingVenueEnum.UNKNOWN), CardinalityOperator.All).getOrDefault(false)) {
							return MapperS.of("BILT");
						}
						return MapperS.<String>ofNull();
					}
					if (exists(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<EnrichmentData>map("getEnrichment", reportableInformation -> reportableInformation.getEnrichment()).<MicData>mapC("getMicData", enrichmentData -> enrichmentData.getMicData())).and(areEqual(MapperC.<String>of(MapperS.of("XOFF"), MapperS.of("XXXX"), MapperS.of("BILT")), MapperS.of(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<EnrichmentData>map("getEnrichment", reportableInformation -> reportableInformation.getEnrichment()).<MicData>mapC("getMicData", enrichmentData -> enrichmentData.getMicData()).get()).<String>map("getMic", micData -> micData.getMic()), CardinalityOperator.Any)).getOrDefault(false)) {
						return MapperS.of(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<EnrichmentData>map("getEnrichment", reportableInformation -> reportableInformation.getEnrichment()).<MicData>mapC("getMicData", enrichmentData -> enrichmentData.getMicData()).get()).<String>map("getMic", micData -> micData.getMic());
					}
					return MapperS.of(platformIdentifierRule.evaluate(item.get()));
				}).get();
			
			return output;
		}
	}
}
