package drr.regulation.common.validation.exists;

import cdm.event.common.TradeIdentifier;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.CommonTransactionInformation;
import drr.regulation.common.ESMATransactionInformation;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class TransactionInformationOnlyExistsValidator implements ValidatorWithArg<TransactionInformation, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends TransactionInformation> ValidationResult<TransactionInformation> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("regimeName", ExistenceChecker.isSet((FieldWithMetaRegimeNameEnum) o.getRegimeName()))
				.put("supervisoryBody", ExistenceChecker.isSet((FieldWithMetaSupervisoryBodyEnum) o.getSupervisoryBody()))
				.put("transactionIdentifier", ExistenceChecker.isSet((TradeIdentifier) o.getTransactionIdentifier()))
				.put("priorTransactionIdentifier", ExistenceChecker.isSet((TradeIdentifier) o.getPriorTransactionIdentifier()))
				.put("esmaTransactionInformation", ExistenceChecker.isSet((ESMATransactionInformation) o.getEsmaTransactionInformation()))
				.put("fcaTransactionInformation", ExistenceChecker.isSet((CommonTransactionInformation) o.getFcaTransactionInformation()))
				.put("masTransactionInformation", ExistenceChecker.isSet((CommonTransactionInformation) o.getMasTransactionInformation()))
				.put("csaTransactionInformation", ExistenceChecker.isSet((CommonTransactionInformation) o.getCsaTransactionInformation()))
				.put("hkmaTransactionInformation", ExistenceChecker.isSet((CommonTransactionInformation) o.getHkmaTransactionInformation()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("TransactionInformation", ValidationResult.ValidationType.ONLY_EXISTS, "TransactionInformation", path, "");
		}
		return failure("TransactionInformation", ValidationResult.ValidationType.ONLY_EXISTS, "TransactionInformation", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
