package drr.regulation.csa.rewrite.dtcc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.csa.rewrite.dtcc.meta.UnderlyingAssetNameReportMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 6.17.1
 */
@RosettaDataType(value="UnderlyingAssetNameReport", builder=UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilderImpl.class, version="6.17.1")
@RuneDataType(value="UnderlyingAssetNameReport", model="drr", builder=UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilderImpl.class, version="6.17.1")
public interface UnderlyingAssetNameReport extends RosettaModelObject {

	UnderlyingAssetNameReportMeta metaData = new UnderlyingAssetNameReportMeta();

	/*********************** Getter Methods  ***********************/
	List<String> getUnderlyingAssetName();

	/*********************** Build Methods  ***********************/
	UnderlyingAssetNameReport build();
	
	UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder toBuilder();
	
	static UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder builder() {
		return new UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends UnderlyingAssetNameReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends UnderlyingAssetNameReport> getType() {
		return UnderlyingAssetNameReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("underlyingAssetName"), String.class, getUnderlyingAssetName(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface UnderlyingAssetNameReportBuilder extends UnderlyingAssetNameReport, RosettaModelObjectBuilder {
		UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder addUnderlyingAssetName(String underlyingAssetName);
		UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder addUnderlyingAssetName(String underlyingAssetName, int idx);
		UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder addUnderlyingAssetName(List<String> underlyingAssetName);
		UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder setUnderlyingAssetName(List<String> underlyingAssetName);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("underlyingAssetName"), String.class, getUnderlyingAssetName(), this);
		}
		

		UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder prune();
	}

	/*********************** Immutable Implementation of UnderlyingAssetNameReport  ***********************/
	class UnderlyingAssetNameReportImpl implements UnderlyingAssetNameReport {
		private final List<String> underlyingAssetName;
		
		protected UnderlyingAssetNameReportImpl(UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder builder) {
			this.underlyingAssetName = ofNullable(builder.getUnderlyingAssetName()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
		}
		
		@Override
		@RosettaAttribute("underlyingAssetName")
		@RuneAttribute("underlyingAssetName")
		public List<String> getUnderlyingAssetName() {
			return underlyingAssetName;
		}
		
		@Override
		public UnderlyingAssetNameReport build() {
			return this;
		}
		
		@Override
		public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder toBuilder() {
			UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder builder) {
			ofNullable(getUnderlyingAssetName()).ifPresent(builder::setUnderlyingAssetName);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			UnderlyingAssetNameReport _that = getType().cast(o);
		
			if (!ListEquals.listEquals(underlyingAssetName, _that.getUnderlyingAssetName())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (underlyingAssetName != null ? underlyingAssetName.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "UnderlyingAssetNameReport {" +
				"underlyingAssetName=" + this.underlyingAssetName +
			'}';
		}
	}

	/*********************** Builder Implementation of UnderlyingAssetNameReport  ***********************/
	class UnderlyingAssetNameReportBuilderImpl implements UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder {
	
		protected List<String> underlyingAssetName = new ArrayList<>();
		
		@Override
		@RosettaAttribute("underlyingAssetName")
		@RuneAttribute("underlyingAssetName")
		public List<String> getUnderlyingAssetName() {
			return underlyingAssetName;
		}
		
		@RosettaAttribute("underlyingAssetName")
		@RuneAttribute("underlyingAssetName")
		@Override
		public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder addUnderlyingAssetName(String _underlyingAssetName) {
			if (_underlyingAssetName != null) {
				this.underlyingAssetName.add(_underlyingAssetName);
			}
			return this;
		}
		
		@Override
		public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder addUnderlyingAssetName(String _underlyingAssetName, int idx) {
			getIndex(this.underlyingAssetName, idx, () -> _underlyingAssetName);
			return this;
		}
		
		@Override
		public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder addUnderlyingAssetName(List<String> underlyingAssetNames) {
			if (underlyingAssetNames != null) {
				for (final String toAdd : underlyingAssetNames) {
					this.underlyingAssetName.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("underlyingAssetName")
		@Override
		public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder setUnderlyingAssetName(List<String> underlyingAssetNames) {
			if (underlyingAssetNames == null) {
				this.underlyingAssetName = new ArrayList<>();
			} else {
				this.underlyingAssetName = underlyingAssetNames.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		public UnderlyingAssetNameReport build() {
			return new UnderlyingAssetNameReport.UnderlyingAssetNameReportImpl(this);
		}
		
		@Override
		public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUnderlyingAssetName()!=null && !getUnderlyingAssetName().isEmpty()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder o = (UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder) other;
			
			
			merger.mergeBasic(getUnderlyingAssetName(), o.getUnderlyingAssetName(), (Consumer<String>) this::addUnderlyingAssetName);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			UnderlyingAssetNameReport _that = getType().cast(o);
		
			if (!ListEquals.listEquals(underlyingAssetName, _that.getUnderlyingAssetName())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (underlyingAssetName != null ? underlyingAssetName.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "UnderlyingAssetNameReportBuilder {" +
				"underlyingAssetName=" + this.underlyingAssetName +
			'}';
		}
	}
}
