package drr.regulation.csa.rewrite.dtcc.reports;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.party.LegalEntity;
import cdm.product.asset.BasketReferenceInformation;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.ReferencePair;
import cdm.product.asset.ReferencePool;
import cdm.product.asset.ReferencePoolItem;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.GetAllUnderlierProductIdentifier;
import drr.regulation.common.functions.GetUnderlyingIdentificationType;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.common.trade.underlier.UnderlyingIdentificationTypeEnum;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetReport;
import drr.regulation.csa.rewrite.functions.GetUnderlierIDForBasketCSA;
import drr.regulation.csa.rewrite.functions.GetUnderlierIDForIndexCSA;
import drr.regulation.csa.rewrite.functions.GetUnderlierLEIForCreditCSA;
import drr.regulation.csa.rewrite.functions.IsUnderlierForIndex;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(DTCC_UnderlyingAssetReportRule.DTCC_UnderlyingAssetReportRuleDefault.class)
public abstract class DTCC_UnderlyingAssetReportRule implements ReportFunction<TransactionReportInstruction, List<? extends UnderlyingAssetReport>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected DTCC_UnderlyingAssetIDTypeRule dTCC_UnderlyingAssetIDTypeRule;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetAllUnderlierProductIdentifier getAllUnderlierProductIdentifier;
	@Inject protected GetUnderlierIDForBasketCSA getUnderlierIDForBasketCSA;
	@Inject protected GetUnderlierIDForIndexCSA getUnderlierIDForIndexCSA;
	@Inject protected GetUnderlierLEIForCreditCSA getUnderlierLEIForCreditCSA;
	@Inject protected GetUnderlyingIdentificationType getUnderlyingIdentificationType;
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsUnderlierForIndex isUnderlierForIndex;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends UnderlyingAssetReport> evaluate(TransactionReportInstruction input) {
		List<UnderlyingAssetReport.UnderlyingAssetReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends UnderlyingAssetReport> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(UnderlyingAssetReport::build).collect(Collectors.toList());
			objectValidator.validate(UnderlyingAssetReport.class, output);
		}
		
		return output;
	}

	protected abstract List<UnderlyingAssetReport.UnderlyingAssetReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class DTCC_UnderlyingAssetReportRuleDefault extends DTCC_UnderlyingAssetReportRule {
		@Override
		protected List<UnderlyingAssetReport.UnderlyingAssetReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<UnderlyingAssetReport.UnderlyingAssetReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<UnderlyingAssetReport.UnderlyingAssetReportBuilder> assignOutput(List<UnderlyingAssetReport.UnderlyingAssetReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final MapperS<TransactionReportInstruction> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> ComparisonResult.of(MapperS.of(qualify_AssetClass_Credit.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))))).or(ComparisonResult.of(MapperS.of(qualify_AssetClass_Equity.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get())))))).get());
			output = toBuilder(thenArg1
				.mapSingleToList(reportableEvent -> {
					final MapperS<Product> _thenArg0 = MapperS.of(productForEvent.evaluate(thenArg1.get()));
					final MapperS<Product> _thenArg1 = _thenArg0
						.mapSingleToItem(item -> {
							final Boolean _boolean = isCreditSwaption.evaluate(item.get());
							if ((_boolean == null ? false : _boolean)) {
								return MapperS.of(underlierForProduct.evaluate(item.get()));
							}
							return item;
						});
					return _thenArg1
						.mapSingleToList(item -> {
							if (exists(MapperC.<ProductIdentifier>of(getAllUnderlierProductIdentifier.evaluate(item.get()))).getOrDefault(false)) {
								final MapperC<ProductIdentifier> __thenArg0 = MapperC.<ProductIdentifier>of(getAllUnderlierProductIdentifier.evaluate(item.get()));
								return __thenArg0
									.mapItem(_item -> {
										if (areEqual(MapperS.of(dTCC_UnderlyingAssetIDTypeRule.evaluate(_item.get())), MapperS.of("SingleOther"), CardinalityOperator.All).and(ComparisonResult.of(MapperS.of(isUnderlierForIndex.evaluate(reportableEvent.get())))).getOrDefault(false)) {
											final FieldWithMetaString fieldWithMetaString0 = _item.<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
											return MapperS.of(UnderlyingAssetReport.builder()
												.setUnderlyingAssetID((fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()))
												.setUnderlyingAssetIDType("Index")
												.build());
										}
										final FieldWithMetaString fieldWithMetaString1 = _item.<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
										return MapperS.of(UnderlyingAssetReport.builder()
											.setUnderlyingAssetID((fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()))
											.setUnderlyingAssetIDType(dTCC_UnderlyingAssetIDTypeRule.evaluate(_item.get()))
											.build());
									});
							}
							if (exists(MapperC.<String>of(getUnderlierIDForIndexCSA.evaluate(item.get()))).getOrDefault(false)) {
								final MapperC<String> __thenArg1 = MapperC.<String>of(getUnderlierIDForIndexCSA.evaluate(item.get()));
								return __thenArg1
									.mapItem(_item -> MapperS.of(UnderlyingAssetReport.builder()
										.setUnderlyingAssetID(_item.get())
										.setUnderlyingAssetIDType("Index")
										.build()));
							}
							if (areEqual(MapperS.of(getUnderlyingIdentificationType.evaluate(reportableEvent.get())), MapperS.of(UnderlyingIdentificationTypeEnum.B), CardinalityOperator.All).getOrDefault(false)) {
								if (exists(MapperC.<String>of(getUnderlierIDForBasketCSA.evaluate(item.get()))).getOrDefault(false)) {
									final MapperC<String> thenArg2 = MapperC.<String>of(getUnderlierIDForBasketCSA.evaluate(item.get()));
									return thenArg2
										.mapItem(_item -> MapperS.of(UnderlyingAssetReport.builder()
											.setUnderlyingAssetID(_item.get())
											.setUnderlyingAssetIDType("Basket")
											.build()));
								}
								if (exists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).<ReferencePool>map("getReferencePool", basketReferenceInformation -> basketReferenceInformation.getReferencePool()).<ReferencePoolItem>mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem()).<ReferencePair>map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).<LegalEntity>map("getReferenceEntity", referencePair -> referencePair.getReferenceEntity()).<FieldWithMetaString>mapC("getEntityId", legalEntity -> legalEntity.getEntityId())).getOrDefault(false)) {
									final MapperC<FieldWithMetaString> thenArg3 = MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).<ReferencePool>map("getReferencePool", basketReferenceInformation -> basketReferenceInformation.getReferencePool()).<ReferencePoolItem>mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem()).<ReferencePair>map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).<LegalEntity>map("getReferenceEntity", referencePair -> referencePair.getReferenceEntity()).<FieldWithMetaString>mapC("getEntityId", legalEntity -> legalEntity.getEntityId());
									return thenArg3
										.mapItem(_item -> {
											final FieldWithMetaString fieldWithMetaString = _item.get();
											return MapperS.of(UnderlyingAssetReport.builder()
												.setUnderlyingAssetID((fieldWithMetaString == null ? null : fieldWithMetaString.getValue()))
												.setUnderlyingAssetIDType("LEI")
												.build());
										});
								}
								return MapperC.of(Collections.singletonList(UnderlyingAssetReport.builder()
									.setUnderlyingAssetIDType("Basket")
									.build()));
							}
							if (exists(MapperC.<String>of(getUnderlierLEIForCreditCSA.evaluate(item.get()))).getOrDefault(false)) {
								final MapperC<String> thenArg4 = MapperC.<String>of(getUnderlierLEIForCreditCSA.evaluate(item.get()));
								return thenArg4
									.mapItem(_item -> MapperS.of(UnderlyingAssetReport.builder()
										.setUnderlyingAssetID(_item.get())
										.setUnderlyingAssetIDType("LEI")
										.build()));
							}
							return MapperC.<UnderlyingAssetReport>ofNull();
						});
				}).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
