package drr.regulation.csa.rewrite.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsUnderlierForIndex.IsUnderlierForIndexDefault.class)
public abstract class IsUnderlierForIndex implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetUnderlierIDForIndexCSA getUnderlierIDForIndexCSA;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param reportableEvent 
	* @return result 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean result = doEvaluate(reportableEvent);
		
		return result;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	public static class IsUnderlierForIndexDefault extends IsUnderlierForIndex {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean result = null;
			return assignOutput(result, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean result, ReportableEvent reportableEvent) {
			final MapperS<Product> thenArg0 = MapperS.of(productForEvent.evaluate(reportableEvent));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCreditSwaption.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(underlierForProduct.evaluate(item.get()));
					}
					return item;
				});
			result = thenArg1
				.mapSingleToItem(item -> {
					if (exists(MapperC.<String>of(getUnderlierIDForIndexCSA.evaluate(item.get()))).getOrDefault(false)) {
						return MapperS.of(true);
					}
					return MapperS.of(false);
				}).get();
			
			return result;
		}
	}
}
