package drr.regulation.csa.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.csa.rewrite.margin.meta.CSAMarginReportMeta;
import drr.standards.iso.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 6.17.1
 */
@RosettaDataType(value="CSAMarginReport", builder=CSAMarginReport.CSAMarginReportBuilderImpl.class, version="6.17.1")
@RuneDataType(value="CSAMarginReport", model="drr", builder=CSAMarginReport.CSAMarginReportBuilderImpl.class, version="6.17.1")
public interface CSAMarginReport extends RosettaModelObject {

	CSAMarginReportMeta metaData = new CSAMarginReportMeta();

	/*********************** Getter Methods  ***********************/
	String getCounterparty1();
	String getCounterparty2();
	String getCounterparty2IdentifierSource();
	ZonedDateTime getReportingTimestamp();
	String getUniqueTransactionIdentifier();
	String getSubmitterIdentifier();
	CollateralisationType3Code__1 getCollateralisationCategory();
	Boolean getPortfolioContainingNonReportableComponentIndicator();
	BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut();
	BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut();
	ISOCurrencyCodeEnum getCurrencyOfInitialMarginPosted();
	BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPreHaircut();
	BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPostHaircut();
	ISOCurrencyCodeEnum getCurrencyOfInitialMarginCollected();
	BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut();
	BigDecimal getVariationMarginPostedByTheReportingCounterpartyPostHaircut();
	ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted();
	BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut();
	BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPostHaircut();
	ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected();
	String getVariationMarginCollateralPortfolioCode();
	String getInitialMarginCollateralPortfolioCode();
	ZonedDateTime getEventTimestamp();
	MarginActionEnum getActionType();
	PartyIdentifierTypeEnum getTradeParty1IDType();
	PartyIdentifierTypeEnum getSubmittingPartyIDType();
	String getUsiID();
	String getUsiIDPrefix();
	List<SupervisoryBodyEnum> getTradeParty1ReportingDestination();
	String getComment1();
	String getMessageID();
	String getMessageType();
	String getVersion();

	/*********************** Build Methods  ***********************/
	CSAMarginReport build();
	
	CSAMarginReport.CSAMarginReportBuilder toBuilder();
	
	static CSAMarginReport.CSAMarginReportBuilder builder() {
		return new CSAMarginReport.CSAMarginReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CSAMarginReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CSAMarginReport> getType() {
		return CSAMarginReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, getCounterparty2IdentifierSource(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
		processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, getCollateralisationCategory(), this);
		processor.processBasic(path.newSubPath("portfolioContainingNonReportableComponentIndicator"), Boolean.class, getPortfolioContainingNonReportableComponentIndicator(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfInitialMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfInitialMarginPosted(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingCounterpartyPreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingCounterpartyPostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfInitialMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfInitialMarginCollected(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginPosted(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginCollected(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, getTradeParty1IDType(), this);
		processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, getSubmittingPartyIDType(), this);
		processor.processBasic(path.newSubPath("usiID"), String.class, getUsiID(), this);
		processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, getUsiIDPrefix(), this);
		processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, getTradeParty1ReportingDestination(), this);
		processor.processBasic(path.newSubPath("comment1"), String.class, getComment1(), this);
		processor.processBasic(path.newSubPath("messageID"), String.class, getMessageID(), this);
		processor.processBasic(path.newSubPath("messageType"), String.class, getMessageType(), this);
		processor.processBasic(path.newSubPath("version"), String.class, getVersion(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CSAMarginReportBuilder extends CSAMarginReport, RosettaModelObjectBuilder {
		CSAMarginReport.CSAMarginReportBuilder setCounterparty1(String counterparty1);
		CSAMarginReport.CSAMarginReportBuilder setCounterparty2(String counterparty2);
		CSAMarginReport.CSAMarginReportBuilder setCounterparty2IdentifierSource(String counterparty2IdentifierSource);
		CSAMarginReport.CSAMarginReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		CSAMarginReport.CSAMarginReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		CSAMarginReport.CSAMarginReportBuilder setSubmitterIdentifier(String submitterIdentifier);
		CSAMarginReport.CSAMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 collateralisationCategory);
		CSAMarginReport.CSAMarginReportBuilder setPortfolioContainingNonReportableComponentIndicator(Boolean portfolioContainingNonReportableComponentIndicator);
		CSAMarginReport.CSAMarginReportBuilder setInitialMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal initialMarginPostedByTheReportingCounterpartyPreHaircut);
		CSAMarginReport.CSAMarginReportBuilder setInitialMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal initialMarginPostedByTheReportingCounterpartyPostHaircut);
		CSAMarginReport.CSAMarginReportBuilder setCurrencyOfInitialMarginPosted(ISOCurrencyCodeEnum currencyOfInitialMarginPosted);
		CSAMarginReport.CSAMarginReportBuilder setInitialMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal initialMarginCollectedByTheReportingCounterpartyPreHaircut);
		CSAMarginReport.CSAMarginReportBuilder setInitialMarginCollectedByTheReportingCounterpartyPostHaircut(BigDecimal initialMarginCollectedByTheReportingCounterpartyPostHaircut);
		CSAMarginReport.CSAMarginReportBuilder setCurrencyOfInitialMarginCollected(ISOCurrencyCodeEnum currencyOfInitialMarginCollected);
		CSAMarginReport.CSAMarginReportBuilder setVariationMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal variationMarginPostedByTheReportingCounterpartyPreHaircut);
		CSAMarginReport.CSAMarginReportBuilder setVariationMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal variationMarginPostedByTheReportingCounterpartyPostHaircut);
		CSAMarginReport.CSAMarginReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum currencyOfVariationMarginPosted);
		CSAMarginReport.CSAMarginReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal variationMarginCollectedByTheReportingCounterpartyPreHaircut);
		CSAMarginReport.CSAMarginReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPostHaircut(BigDecimal variationMarginCollectedByTheReportingCounterpartyPostHaircut);
		CSAMarginReport.CSAMarginReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum currencyOfVariationMarginCollected);
		CSAMarginReport.CSAMarginReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		CSAMarginReport.CSAMarginReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		CSAMarginReport.CSAMarginReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		CSAMarginReport.CSAMarginReportBuilder setActionType(MarginActionEnum actionType);
		CSAMarginReport.CSAMarginReportBuilder setTradeParty1IDType(PartyIdentifierTypeEnum tradeParty1IDType);
		CSAMarginReport.CSAMarginReportBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum submittingPartyIDType);
		CSAMarginReport.CSAMarginReportBuilder setUsiID(String usiID);
		CSAMarginReport.CSAMarginReportBuilder setUsiIDPrefix(String usiIDPrefix);
		CSAMarginReport.CSAMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum tradeParty1ReportingDestination);
		CSAMarginReport.CSAMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum tradeParty1ReportingDestination, int idx);
		CSAMarginReport.CSAMarginReportBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestination);
		CSAMarginReport.CSAMarginReportBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestination);
		CSAMarginReport.CSAMarginReportBuilder setComment1(String comment1);
		CSAMarginReport.CSAMarginReportBuilder setMessageID(String messageID);
		CSAMarginReport.CSAMarginReportBuilder setMessageType(String messageType);
		CSAMarginReport.CSAMarginReportBuilder setVersion(String version);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, getCounterparty2IdentifierSource(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
			processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, getCollateralisationCategory(), this);
			processor.processBasic(path.newSubPath("portfolioContainingNonReportableComponentIndicator"), Boolean.class, getPortfolioContainingNonReportableComponentIndicator(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfInitialMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfInitialMarginPosted(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingCounterpartyPreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingCounterpartyPostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfInitialMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfInitialMarginCollected(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginPosted(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginCollected(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, getTradeParty1IDType(), this);
			processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, getSubmittingPartyIDType(), this);
			processor.processBasic(path.newSubPath("usiID"), String.class, getUsiID(), this);
			processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, getUsiIDPrefix(), this);
			processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, getTradeParty1ReportingDestination(), this);
			processor.processBasic(path.newSubPath("comment1"), String.class, getComment1(), this);
			processor.processBasic(path.newSubPath("messageID"), String.class, getMessageID(), this);
			processor.processBasic(path.newSubPath("messageType"), String.class, getMessageType(), this);
			processor.processBasic(path.newSubPath("version"), String.class, getVersion(), this);
		}
		

		CSAMarginReport.CSAMarginReportBuilder prune();
	}

	/*********************** Immutable Implementation of CSAMarginReport  ***********************/
	class CSAMarginReportImpl implements CSAMarginReport {
		private final String counterparty1;
		private final String counterparty2;
		private final String counterparty2IdentifierSource;
		private final ZonedDateTime reportingTimestamp;
		private final String uniqueTransactionIdentifier;
		private final String submitterIdentifier;
		private final CollateralisationType3Code__1 collateralisationCategory;
		private final Boolean portfolioContainingNonReportableComponentIndicator;
		private final BigDecimal initialMarginPostedByTheReportingCounterpartyPreHaircut;
		private final BigDecimal initialMarginPostedByTheReportingCounterpartyPostHaircut;
		private final ISOCurrencyCodeEnum currencyOfInitialMarginPosted;
		private final BigDecimal initialMarginCollectedByTheReportingCounterpartyPreHaircut;
		private final BigDecimal initialMarginCollectedByTheReportingCounterpartyPostHaircut;
		private final ISOCurrencyCodeEnum currencyOfInitialMarginCollected;
		private final BigDecimal variationMarginPostedByTheReportingCounterpartyPreHaircut;
		private final BigDecimal variationMarginPostedByTheReportingCounterpartyPostHaircut;
		private final ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
		private final BigDecimal variationMarginCollectedByTheReportingCounterpartyPreHaircut;
		private final BigDecimal variationMarginCollectedByTheReportingCounterpartyPostHaircut;
		private final ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
		private final String variationMarginCollateralPortfolioCode;
		private final String initialMarginCollateralPortfolioCode;
		private final ZonedDateTime eventTimestamp;
		private final MarginActionEnum actionType;
		private final PartyIdentifierTypeEnum tradeParty1IDType;
		private final PartyIdentifierTypeEnum submittingPartyIDType;
		private final String usiID;
		private final String usiIDPrefix;
		private final List<SupervisoryBodyEnum> tradeParty1ReportingDestination;
		private final String comment1;
		private final String messageID;
		private final String messageType;
		private final String version;
		
		protected CSAMarginReportImpl(CSAMarginReport.CSAMarginReportBuilder builder) {
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.counterparty2IdentifierSource = builder.getCounterparty2IdentifierSource();
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
			this.submitterIdentifier = builder.getSubmitterIdentifier();
			this.collateralisationCategory = builder.getCollateralisationCategory();
			this.portfolioContainingNonReportableComponentIndicator = builder.getPortfolioContainingNonReportableComponentIndicator();
			this.initialMarginPostedByTheReportingCounterpartyPreHaircut = builder.getInitialMarginPostedByTheReportingCounterpartyPreHaircut();
			this.initialMarginPostedByTheReportingCounterpartyPostHaircut = builder.getInitialMarginPostedByTheReportingCounterpartyPostHaircut();
			this.currencyOfInitialMarginPosted = builder.getCurrencyOfInitialMarginPosted();
			this.initialMarginCollectedByTheReportingCounterpartyPreHaircut = builder.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut();
			this.initialMarginCollectedByTheReportingCounterpartyPostHaircut = builder.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut();
			this.currencyOfInitialMarginCollected = builder.getCurrencyOfInitialMarginCollected();
			this.variationMarginPostedByTheReportingCounterpartyPreHaircut = builder.getVariationMarginPostedByTheReportingCounterpartyPreHaircut();
			this.variationMarginPostedByTheReportingCounterpartyPostHaircut = builder.getVariationMarginPostedByTheReportingCounterpartyPostHaircut();
			this.currencyOfVariationMarginPosted = builder.getCurrencyOfVariationMarginPosted();
			this.variationMarginCollectedByTheReportingCounterpartyPreHaircut = builder.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut();
			this.variationMarginCollectedByTheReportingCounterpartyPostHaircut = builder.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut();
			this.currencyOfVariationMarginCollected = builder.getCurrencyOfVariationMarginCollected();
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.eventTimestamp = builder.getEventTimestamp();
			this.actionType = builder.getActionType();
			this.tradeParty1IDType = builder.getTradeParty1IDType();
			this.submittingPartyIDType = builder.getSubmittingPartyIDType();
			this.usiID = builder.getUsiID();
			this.usiIDPrefix = builder.getUsiIDPrefix();
			this.tradeParty1ReportingDestination = ofNullable(builder.getTradeParty1ReportingDestination()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.comment1 = builder.getComment1();
			this.messageID = builder.getMessageID();
			this.messageType = builder.getMessageType();
			this.version = builder.getVersion();
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
		public String getCounterparty2IdentifierSource() {
			return counterparty2IdentifierSource;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		public CollateralisationType3Code__1 getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
		@RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
		public Boolean getPortfolioContainingNonReportableComponentIndicator() {
			return portfolioContainingNonReportableComponentIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut() {
			return initialMarginPostedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut() {
			return initialMarginPostedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfInitialMarginPosted")
		@RuneAttribute("currencyOfInitialMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfInitialMarginPosted() {
			return currencyOfInitialMarginPosted;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPreHaircut() {
			return initialMarginCollectedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPostHaircut() {
			return initialMarginCollectedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfInitialMarginCollected")
		@RuneAttribute("currencyOfInitialMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfInitialMarginCollected() {
			return currencyOfInitialMarginCollected;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut() {
			return variationMarginPostedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPostHaircut() {
			return variationMarginPostedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
			return currencyOfVariationMarginPosted;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() {
			return variationMarginCollectedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPostHaircut() {
			return variationMarginCollectedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
			return currencyOfVariationMarginCollected;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="tradeParty1IDType", isRequired=true)
		@RuneAttribute(value="tradeParty1IDType", isRequired=true)
		public PartyIdentifierTypeEnum getTradeParty1IDType() {
			return tradeParty1IDType;
		}
		
		@Override
		@RosettaAttribute(value="submittingPartyIDType", isRequired=true)
		@RuneAttribute(value="submittingPartyIDType", isRequired=true)
		public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
			return submittingPartyIDType;
		}
		
		@Override
		@RosettaAttribute(value="usiID", isRequired=true)
		@RuneAttribute(value="usiID", isRequired=true)
		public String getUsiID() {
			return usiID;
		}
		
		@Override
		@RosettaAttribute(value="usiIDPrefix", isRequired=true)
		@RuneAttribute(value="usiIDPrefix", isRequired=true)
		public String getUsiIDPrefix() {
			return usiIDPrefix;
		}
		
		@Override
		@RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
		@RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
		public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
			return tradeParty1ReportingDestination;
		}
		
		@Override
		@RosettaAttribute(value="comment1", isRequired=true)
		@RuneAttribute(value="comment1", isRequired=true)
		public String getComment1() {
			return comment1;
		}
		
		@Override
		@RosettaAttribute(value="messageID", isRequired=true)
		@RuneAttribute(value="messageID", isRequired=true)
		public String getMessageID() {
			return messageID;
		}
		
		@Override
		@RosettaAttribute(value="messageType", isRequired=true)
		@RuneAttribute(value="messageType", isRequired=true)
		public String getMessageType() {
			return messageType;
		}
		
		@Override
		@RosettaAttribute(value="version", isRequired=true)
		@RuneAttribute(value="version", isRequired=true)
		public String getVersion() {
			return version;
		}
		
		@Override
		public CSAMarginReport build() {
			return this;
		}
		
		@Override
		public CSAMarginReport.CSAMarginReportBuilder toBuilder() {
			CSAMarginReport.CSAMarginReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CSAMarginReport.CSAMarginReportBuilder builder) {
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCounterparty2IdentifierSource()).ifPresent(builder::setCounterparty2IdentifierSource);
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
			ofNullable(getSubmitterIdentifier()).ifPresent(builder::setSubmitterIdentifier);
			ofNullable(getCollateralisationCategory()).ifPresent(builder::setCollateralisationCategory);
			ofNullable(getPortfolioContainingNonReportableComponentIndicator()).ifPresent(builder::setPortfolioContainingNonReportableComponentIndicator);
			ofNullable(getInitialMarginPostedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingCounterpartyPreHaircut);
			ofNullable(getInitialMarginPostedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingCounterpartyPostHaircut);
			ofNullable(getCurrencyOfInitialMarginPosted()).ifPresent(builder::setCurrencyOfInitialMarginPosted);
			ofNullable(getInitialMarginCollectedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setInitialMarginCollectedByTheReportingCounterpartyPreHaircut);
			ofNullable(getInitialMarginCollectedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setInitialMarginCollectedByTheReportingCounterpartyPostHaircut);
			ofNullable(getCurrencyOfInitialMarginCollected()).ifPresent(builder::setCurrencyOfInitialMarginCollected);
			ofNullable(getVariationMarginPostedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setVariationMarginPostedByTheReportingCounterpartyPreHaircut);
			ofNullable(getVariationMarginPostedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setVariationMarginPostedByTheReportingCounterpartyPostHaircut);
			ofNullable(getCurrencyOfVariationMarginPosted()).ifPresent(builder::setCurrencyOfVariationMarginPosted);
			ofNullable(getVariationMarginCollectedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setVariationMarginCollectedByTheReportingCounterpartyPreHaircut);
			ofNullable(getVariationMarginCollectedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setVariationMarginCollectedByTheReportingCounterpartyPostHaircut);
			ofNullable(getCurrencyOfVariationMarginCollected()).ifPresent(builder::setCurrencyOfVariationMarginCollected);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getEventTimestamp()).ifPresent(builder::setEventTimestamp);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getTradeParty1IDType()).ifPresent(builder::setTradeParty1IDType);
			ofNullable(getSubmittingPartyIDType()).ifPresent(builder::setSubmittingPartyIDType);
			ofNullable(getUsiID()).ifPresent(builder::setUsiID);
			ofNullable(getUsiIDPrefix()).ifPresent(builder::setUsiIDPrefix);
			ofNullable(getTradeParty1ReportingDestination()).ifPresent(builder::setTradeParty1ReportingDestination);
			ofNullable(getComment1()).ifPresent(builder::setComment1);
			ofNullable(getMessageID()).ifPresent(builder::setMessageID);
			ofNullable(getMessageType()).ifPresent(builder::setMessageType);
			ofNullable(getVersion()).ifPresent(builder::setVersion);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CSAMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(portfolioContainingNonReportableComponentIndicator, _that.getPortfolioContainingNonReportableComponentIndicator())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfInitialMarginPosted, _that.getCurrencyOfInitialMarginPosted())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfInitialMarginCollected, _that.getCurrencyOfInitialMarginCollected())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(tradeParty1IDType, _that.getTradeParty1IDType())) return false;
			if (!Objects.equals(submittingPartyIDType, _that.getSubmittingPartyIDType())) return false;
			if (!Objects.equals(usiID, _that.getUsiID())) return false;
			if (!Objects.equals(usiIDPrefix, _that.getUsiIDPrefix())) return false;
			if (!ListEquals.listEquals(tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) return false;
			if (!Objects.equals(comment1, _that.getComment1())) return false;
			if (!Objects.equals(messageID, _that.getMessageID())) return false;
			if (!Objects.equals(messageType, _that.getMessageType())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierSource != null ? counterparty2IdentifierSource.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (portfolioContainingNonReportableComponentIndicator != null ? portfolioContainingNonReportableComponentIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterpartyPreHaircut != null ? initialMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterpartyPostHaircut != null ? initialMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfInitialMarginPosted != null ? currencyOfInitialMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingCounterpartyPreHaircut != null ? initialMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingCounterpartyPostHaircut != null ? initialMarginCollectedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfInitialMarginCollected != null ? currencyOfInitialMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterpartyPreHaircut != null ? variationMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterpartyPostHaircut != null ? variationMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginPosted != null ? currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterpartyPreHaircut != null ? variationMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterpartyPostHaircut != null ? variationMarginCollectedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginCollected != null ? currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tradeParty1IDType != null ? tradeParty1IDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (submittingPartyIDType != null ? submittingPartyIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (usiID != null ? usiID.hashCode() : 0);
			_result = 31 * _result + (usiIDPrefix != null ? usiIDPrefix.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ReportingDestination != null ? tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (comment1 != null ? comment1.hashCode() : 0);
			_result = 31 * _result + (messageID != null ? messageID.hashCode() : 0);
			_result = 31 * _result + (messageType != null ? messageType.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CSAMarginReport {" +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"portfolioContainingNonReportableComponentIndicator=" + this.portfolioContainingNonReportableComponentIndicator + ", " +
				"initialMarginPostedByTheReportingCounterpartyPreHaircut=" + this.initialMarginPostedByTheReportingCounterpartyPreHaircut + ", " +
				"initialMarginPostedByTheReportingCounterpartyPostHaircut=" + this.initialMarginPostedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfInitialMarginPosted=" + this.currencyOfInitialMarginPosted + ", " +
				"initialMarginCollectedByTheReportingCounterpartyPreHaircut=" + this.initialMarginCollectedByTheReportingCounterpartyPreHaircut + ", " +
				"initialMarginCollectedByTheReportingCounterpartyPostHaircut=" + this.initialMarginCollectedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfInitialMarginCollected=" + this.currencyOfInitialMarginCollected + ", " +
				"variationMarginPostedByTheReportingCounterpartyPreHaircut=" + this.variationMarginPostedByTheReportingCounterpartyPreHaircut + ", " +
				"variationMarginPostedByTheReportingCounterpartyPostHaircut=" + this.variationMarginPostedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfVariationMarginPosted=" + this.currencyOfVariationMarginPosted + ", " +
				"variationMarginCollectedByTheReportingCounterpartyPreHaircut=" + this.variationMarginCollectedByTheReportingCounterpartyPreHaircut + ", " +
				"variationMarginCollectedByTheReportingCounterpartyPostHaircut=" + this.variationMarginCollectedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfVariationMarginCollected=" + this.currencyOfVariationMarginCollected + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"actionType=" + this.actionType + ", " +
				"tradeParty1IDType=" + this.tradeParty1IDType + ", " +
				"submittingPartyIDType=" + this.submittingPartyIDType + ", " +
				"usiID=" + this.usiID + ", " +
				"usiIDPrefix=" + this.usiIDPrefix + ", " +
				"tradeParty1ReportingDestination=" + this.tradeParty1ReportingDestination + ", " +
				"comment1=" + this.comment1 + ", " +
				"messageID=" + this.messageID + ", " +
				"messageType=" + this.messageType + ", " +
				"version=" + this.version +
			'}';
		}
	}

	/*********************** Builder Implementation of CSAMarginReport  ***********************/
	class CSAMarginReportBuilderImpl implements CSAMarginReport.CSAMarginReportBuilder {
	
		protected String counterparty1;
		protected String counterparty2;
		protected String counterparty2IdentifierSource;
		protected ZonedDateTime reportingTimestamp;
		protected String uniqueTransactionIdentifier;
		protected String submitterIdentifier;
		protected CollateralisationType3Code__1 collateralisationCategory;
		protected Boolean portfolioContainingNonReportableComponentIndicator;
		protected BigDecimal initialMarginPostedByTheReportingCounterpartyPreHaircut;
		protected BigDecimal initialMarginPostedByTheReportingCounterpartyPostHaircut;
		protected ISOCurrencyCodeEnum currencyOfInitialMarginPosted;
		protected BigDecimal initialMarginCollectedByTheReportingCounterpartyPreHaircut;
		protected BigDecimal initialMarginCollectedByTheReportingCounterpartyPostHaircut;
		protected ISOCurrencyCodeEnum currencyOfInitialMarginCollected;
		protected BigDecimal variationMarginPostedByTheReportingCounterpartyPreHaircut;
		protected BigDecimal variationMarginPostedByTheReportingCounterpartyPostHaircut;
		protected ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
		protected BigDecimal variationMarginCollectedByTheReportingCounterpartyPreHaircut;
		protected BigDecimal variationMarginCollectedByTheReportingCounterpartyPostHaircut;
		protected ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
		protected String variationMarginCollateralPortfolioCode;
		protected String initialMarginCollateralPortfolioCode;
		protected ZonedDateTime eventTimestamp;
		protected MarginActionEnum actionType;
		protected PartyIdentifierTypeEnum tradeParty1IDType;
		protected PartyIdentifierTypeEnum submittingPartyIDType;
		protected String usiID;
		protected String usiIDPrefix;
		protected List<SupervisoryBodyEnum> tradeParty1ReportingDestination = new ArrayList<>();
		protected String comment1;
		protected String messageID;
		protected String messageType;
		protected String version;
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
		public String getCounterparty2IdentifierSource() {
			return counterparty2IdentifierSource;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		public CollateralisationType3Code__1 getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
		@RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
		public Boolean getPortfolioContainingNonReportableComponentIndicator() {
			return portfolioContainingNonReportableComponentIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut() {
			return initialMarginPostedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut() {
			return initialMarginPostedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfInitialMarginPosted")
		@RuneAttribute("currencyOfInitialMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfInitialMarginPosted() {
			return currencyOfInitialMarginPosted;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPreHaircut() {
			return initialMarginCollectedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPostHaircut() {
			return initialMarginCollectedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfInitialMarginCollected")
		@RuneAttribute("currencyOfInitialMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfInitialMarginCollected() {
			return currencyOfInitialMarginCollected;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut() {
			return variationMarginPostedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPostHaircut() {
			return variationMarginPostedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
			return currencyOfVariationMarginPosted;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() {
			return variationMarginCollectedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPostHaircut() {
			return variationMarginCollectedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
			return currencyOfVariationMarginCollected;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="tradeParty1IDType", isRequired=true)
		@RuneAttribute(value="tradeParty1IDType", isRequired=true)
		public PartyIdentifierTypeEnum getTradeParty1IDType() {
			return tradeParty1IDType;
		}
		
		@Override
		@RosettaAttribute(value="submittingPartyIDType", isRequired=true)
		@RuneAttribute(value="submittingPartyIDType", isRequired=true)
		public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
			return submittingPartyIDType;
		}
		
		@Override
		@RosettaAttribute(value="usiID", isRequired=true)
		@RuneAttribute(value="usiID", isRequired=true)
		public String getUsiID() {
			return usiID;
		}
		
		@Override
		@RosettaAttribute(value="usiIDPrefix", isRequired=true)
		@RuneAttribute(value="usiIDPrefix", isRequired=true)
		public String getUsiIDPrefix() {
			return usiIDPrefix;
		}
		
		@Override
		@RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
		@RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
		public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
			return tradeParty1ReportingDestination;
		}
		
		@Override
		@RosettaAttribute(value="comment1", isRequired=true)
		@RuneAttribute(value="comment1", isRequired=true)
		public String getComment1() {
			return comment1;
		}
		
		@Override
		@RosettaAttribute(value="messageID", isRequired=true)
		@RuneAttribute(value="messageID", isRequired=true)
		public String getMessageID() {
			return messageID;
		}
		
		@Override
		@RosettaAttribute(value="messageType", isRequired=true)
		@RuneAttribute(value="messageType", isRequired=true)
		public String getMessageType() {
			return messageType;
		}
		
		@Override
		@RosettaAttribute(value="version", isRequired=true)
		@RuneAttribute(value="version", isRequired=true)
		public String getVersion() {
			return version;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setCounterparty2IdentifierSource(String _counterparty2IdentifierSource) {
			this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
			return this;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setSubmitterIdentifier(String _submitterIdentifier) {
			this.submitterIdentifier = _submitterIdentifier == null ? null : _submitterIdentifier;
			return this;
		}
		
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 _collateralisationCategory) {
			this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
			return this;
		}
		
		@RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
		@RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setPortfolioContainingNonReportableComponentIndicator(Boolean _portfolioContainingNonReportableComponentIndicator) {
			this.portfolioContainingNonReportableComponentIndicator = _portfolioContainingNonReportableComponentIndicator == null ? null : _portfolioContainingNonReportableComponentIndicator;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setInitialMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal _initialMarginPostedByTheReportingCounterpartyPreHaircut) {
			this.initialMarginPostedByTheReportingCounterpartyPreHaircut = _initialMarginPostedByTheReportingCounterpartyPreHaircut == null ? null : _initialMarginPostedByTheReportingCounterpartyPreHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setInitialMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal _initialMarginPostedByTheReportingCounterpartyPostHaircut) {
			this.initialMarginPostedByTheReportingCounterpartyPostHaircut = _initialMarginPostedByTheReportingCounterpartyPostHaircut == null ? null : _initialMarginPostedByTheReportingCounterpartyPostHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyOfInitialMarginPosted")
		@RuneAttribute("currencyOfInitialMarginPosted")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setCurrencyOfInitialMarginPosted(ISOCurrencyCodeEnum _currencyOfInitialMarginPosted) {
			this.currencyOfInitialMarginPosted = _currencyOfInitialMarginPosted == null ? null : _currencyOfInitialMarginPosted;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterpartyPreHaircut")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setInitialMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal _initialMarginCollectedByTheReportingCounterpartyPreHaircut) {
			this.initialMarginCollectedByTheReportingCounterpartyPreHaircut = _initialMarginCollectedByTheReportingCounterpartyPreHaircut == null ? null : _initialMarginCollectedByTheReportingCounterpartyPreHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingCounterpartyPostHaircut")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setInitialMarginCollectedByTheReportingCounterpartyPostHaircut(BigDecimal _initialMarginCollectedByTheReportingCounterpartyPostHaircut) {
			this.initialMarginCollectedByTheReportingCounterpartyPostHaircut = _initialMarginCollectedByTheReportingCounterpartyPostHaircut == null ? null : _initialMarginCollectedByTheReportingCounterpartyPostHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyOfInitialMarginCollected")
		@RuneAttribute("currencyOfInitialMarginCollected")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setCurrencyOfInitialMarginCollected(ISOCurrencyCodeEnum _currencyOfInitialMarginCollected) {
			this.currencyOfInitialMarginCollected = _currencyOfInitialMarginCollected == null ? null : _currencyOfInitialMarginCollected;
			return this;
		}
		
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setVariationMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal _variationMarginPostedByTheReportingCounterpartyPreHaircut) {
			this.variationMarginPostedByTheReportingCounterpartyPreHaircut = _variationMarginPostedByTheReportingCounterpartyPreHaircut == null ? null : _variationMarginPostedByTheReportingCounterpartyPreHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setVariationMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal _variationMarginPostedByTheReportingCounterpartyPostHaircut) {
			this.variationMarginPostedByTheReportingCounterpartyPostHaircut = _variationMarginPostedByTheReportingCounterpartyPostHaircut == null ? null : _variationMarginPostedByTheReportingCounterpartyPostHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum _currencyOfVariationMarginPosted) {
			this.currencyOfVariationMarginPosted = _currencyOfVariationMarginPosted == null ? null : _currencyOfVariationMarginPosted;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal _variationMarginCollectedByTheReportingCounterpartyPreHaircut) {
			this.variationMarginCollectedByTheReportingCounterpartyPreHaircut = _variationMarginCollectedByTheReportingCounterpartyPreHaircut == null ? null : _variationMarginCollectedByTheReportingCounterpartyPreHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPostHaircut(BigDecimal _variationMarginCollectedByTheReportingCounterpartyPostHaircut) {
			this.variationMarginCollectedByTheReportingCounterpartyPostHaircut = _variationMarginCollectedByTheReportingCounterpartyPostHaircut == null ? null : _variationMarginCollectedByTheReportingCounterpartyPostHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum _currencyOfVariationMarginCollected) {
			this.currencyOfVariationMarginCollected = _currencyOfVariationMarginCollected == null ? null : _currencyOfVariationMarginCollected;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setActionType(MarginActionEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute(value="tradeParty1IDType", isRequired=true)
		@RuneAttribute(value="tradeParty1IDType", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setTradeParty1IDType(PartyIdentifierTypeEnum _tradeParty1IDType) {
			this.tradeParty1IDType = _tradeParty1IDType == null ? null : _tradeParty1IDType;
			return this;
		}
		
		@RosettaAttribute(value="submittingPartyIDType", isRequired=true)
		@RuneAttribute(value="submittingPartyIDType", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum _submittingPartyIDType) {
			this.submittingPartyIDType = _submittingPartyIDType == null ? null : _submittingPartyIDType;
			return this;
		}
		
		@RosettaAttribute(value="usiID", isRequired=true)
		@RuneAttribute(value="usiID", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setUsiID(String _usiID) {
			this.usiID = _usiID == null ? null : _usiID;
			return this;
		}
		
		@RosettaAttribute(value="usiIDPrefix", isRequired=true)
		@RuneAttribute(value="usiIDPrefix", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setUsiIDPrefix(String _usiIDPrefix) {
			this.usiIDPrefix = _usiIDPrefix == null ? null : _usiIDPrefix;
			return this;
		}
		
		@RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
		@RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination) {
			if (_tradeParty1ReportingDestination != null) {
				this.tradeParty1ReportingDestination.add(_tradeParty1ReportingDestination);
			}
			return this;
		}
		
		@Override
		public CSAMarginReport.CSAMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination, int idx) {
			getIndex(this.tradeParty1ReportingDestination, idx, () -> _tradeParty1ReportingDestination);
			return this;
		}
		
		@Override
		public CSAMarginReport.CSAMarginReportBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
			if (tradeParty1ReportingDestinations != null) {
				for (final SupervisoryBodyEnum toAdd : tradeParty1ReportingDestinations) {
					this.tradeParty1ReportingDestination.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("tradeParty1ReportingDestination")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
			if (tradeParty1ReportingDestinations == null) {
				this.tradeParty1ReportingDestination = new ArrayList<>();
			} else {
				this.tradeParty1ReportingDestination = tradeParty1ReportingDestinations.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute(value="comment1", isRequired=true)
		@RuneAttribute(value="comment1", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setComment1(String _comment1) {
			this.comment1 = _comment1 == null ? null : _comment1;
			return this;
		}
		
		@RosettaAttribute(value="messageID", isRequired=true)
		@RuneAttribute(value="messageID", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setMessageID(String _messageID) {
			this.messageID = _messageID == null ? null : _messageID;
			return this;
		}
		
		@RosettaAttribute(value="messageType", isRequired=true)
		@RuneAttribute(value="messageType", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setMessageType(String _messageType) {
			this.messageType = _messageType == null ? null : _messageType;
			return this;
		}
		
		@RosettaAttribute(value="version", isRequired=true)
		@RuneAttribute(value="version", isRequired=true)
		@Override
		public CSAMarginReport.CSAMarginReportBuilder setVersion(String _version) {
			this.version = _version == null ? null : _version;
			return this;
		}
		
		@Override
		public CSAMarginReport build() {
			return new CSAMarginReport.CSAMarginReportImpl(this);
		}
		
		@Override
		public CSAMarginReport.CSAMarginReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCounterparty2IdentifierSource()!=null) return true;
			if (getReportingTimestamp()!=null) return true;
			if (getUniqueTransactionIdentifier()!=null) return true;
			if (getSubmitterIdentifier()!=null) return true;
			if (getCollateralisationCategory()!=null) return true;
			if (getPortfolioContainingNonReportableComponentIndicator()!=null) return true;
			if (getInitialMarginPostedByTheReportingCounterpartyPreHaircut()!=null) return true;
			if (getInitialMarginPostedByTheReportingCounterpartyPostHaircut()!=null) return true;
			if (getCurrencyOfInitialMarginPosted()!=null) return true;
			if (getInitialMarginCollectedByTheReportingCounterpartyPreHaircut()!=null) return true;
			if (getInitialMarginCollectedByTheReportingCounterpartyPostHaircut()!=null) return true;
			if (getCurrencyOfInitialMarginCollected()!=null) return true;
			if (getVariationMarginPostedByTheReportingCounterpartyPreHaircut()!=null) return true;
			if (getVariationMarginPostedByTheReportingCounterpartyPostHaircut()!=null) return true;
			if (getCurrencyOfVariationMarginPosted()!=null) return true;
			if (getVariationMarginCollectedByTheReportingCounterpartyPreHaircut()!=null) return true;
			if (getVariationMarginCollectedByTheReportingCounterpartyPostHaircut()!=null) return true;
			if (getCurrencyOfVariationMarginCollected()!=null) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getEventTimestamp()!=null) return true;
			if (getActionType()!=null) return true;
			if (getTradeParty1IDType()!=null) return true;
			if (getSubmittingPartyIDType()!=null) return true;
			if (getUsiID()!=null) return true;
			if (getUsiIDPrefix()!=null) return true;
			if (getTradeParty1ReportingDestination()!=null && !getTradeParty1ReportingDestination().isEmpty()) return true;
			if (getComment1()!=null) return true;
			if (getMessageID()!=null) return true;
			if (getMessageType()!=null) return true;
			if (getVersion()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CSAMarginReport.CSAMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CSAMarginReport.CSAMarginReportBuilder o = (CSAMarginReport.CSAMarginReportBuilder) other;
			
			
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCounterparty2IdentifierSource(), o.getCounterparty2IdentifierSource(), this::setCounterparty2IdentifierSource);
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getUniqueTransactionIdentifier(), o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier);
			merger.mergeBasic(getSubmitterIdentifier(), o.getSubmitterIdentifier(), this::setSubmitterIdentifier);
			merger.mergeBasic(getCollateralisationCategory(), o.getCollateralisationCategory(), this::setCollateralisationCategory);
			merger.mergeBasic(getPortfolioContainingNonReportableComponentIndicator(), o.getPortfolioContainingNonReportableComponentIndicator(), this::setPortfolioContainingNonReportableComponentIndicator);
			merger.mergeBasic(getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), o.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), this::setInitialMarginPostedByTheReportingCounterpartyPreHaircut);
			merger.mergeBasic(getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), o.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), this::setInitialMarginPostedByTheReportingCounterpartyPostHaircut);
			merger.mergeBasic(getCurrencyOfInitialMarginPosted(), o.getCurrencyOfInitialMarginPosted(), this::setCurrencyOfInitialMarginPosted);
			merger.mergeBasic(getInitialMarginCollectedByTheReportingCounterpartyPreHaircut(), o.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut(), this::setInitialMarginCollectedByTheReportingCounterpartyPreHaircut);
			merger.mergeBasic(getInitialMarginCollectedByTheReportingCounterpartyPostHaircut(), o.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut(), this::setInitialMarginCollectedByTheReportingCounterpartyPostHaircut);
			merger.mergeBasic(getCurrencyOfInitialMarginCollected(), o.getCurrencyOfInitialMarginCollected(), this::setCurrencyOfInitialMarginCollected);
			merger.mergeBasic(getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), o.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), this::setVariationMarginPostedByTheReportingCounterpartyPreHaircut);
			merger.mergeBasic(getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), o.getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), this::setVariationMarginPostedByTheReportingCounterpartyPostHaircut);
			merger.mergeBasic(getCurrencyOfVariationMarginPosted(), o.getCurrencyOfVariationMarginPosted(), this::setCurrencyOfVariationMarginPosted);
			merger.mergeBasic(getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), o.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), this::setVariationMarginCollectedByTheReportingCounterpartyPreHaircut);
			merger.mergeBasic(getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), o.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), this::setVariationMarginCollectedByTheReportingCounterpartyPostHaircut);
			merger.mergeBasic(getCurrencyOfVariationMarginCollected(), o.getCurrencyOfVariationMarginCollected(), this::setCurrencyOfVariationMarginCollected);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getEventTimestamp(), o.getEventTimestamp(), this::setEventTimestamp);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getTradeParty1IDType(), o.getTradeParty1IDType(), this::setTradeParty1IDType);
			merger.mergeBasic(getSubmittingPartyIDType(), o.getSubmittingPartyIDType(), this::setSubmittingPartyIDType);
			merger.mergeBasic(getUsiID(), o.getUsiID(), this::setUsiID);
			merger.mergeBasic(getUsiIDPrefix(), o.getUsiIDPrefix(), this::setUsiIDPrefix);
			merger.mergeBasic(getTradeParty1ReportingDestination(), o.getTradeParty1ReportingDestination(), (Consumer<SupervisoryBodyEnum>) this::addTradeParty1ReportingDestination);
			merger.mergeBasic(getComment1(), o.getComment1(), this::setComment1);
			merger.mergeBasic(getMessageID(), o.getMessageID(), this::setMessageID);
			merger.mergeBasic(getMessageType(), o.getMessageType(), this::setMessageType);
			merger.mergeBasic(getVersion(), o.getVersion(), this::setVersion);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CSAMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(portfolioContainingNonReportableComponentIndicator, _that.getPortfolioContainingNonReportableComponentIndicator())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfInitialMarginPosted, _that.getCurrencyOfInitialMarginPosted())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfInitialMarginCollected, _that.getCurrencyOfInitialMarginCollected())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(tradeParty1IDType, _that.getTradeParty1IDType())) return false;
			if (!Objects.equals(submittingPartyIDType, _that.getSubmittingPartyIDType())) return false;
			if (!Objects.equals(usiID, _that.getUsiID())) return false;
			if (!Objects.equals(usiIDPrefix, _that.getUsiIDPrefix())) return false;
			if (!ListEquals.listEquals(tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) return false;
			if (!Objects.equals(comment1, _that.getComment1())) return false;
			if (!Objects.equals(messageID, _that.getMessageID())) return false;
			if (!Objects.equals(messageType, _that.getMessageType())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierSource != null ? counterparty2IdentifierSource.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (portfolioContainingNonReportableComponentIndicator != null ? portfolioContainingNonReportableComponentIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterpartyPreHaircut != null ? initialMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterpartyPostHaircut != null ? initialMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfInitialMarginPosted != null ? currencyOfInitialMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingCounterpartyPreHaircut != null ? initialMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingCounterpartyPostHaircut != null ? initialMarginCollectedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfInitialMarginCollected != null ? currencyOfInitialMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterpartyPreHaircut != null ? variationMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterpartyPostHaircut != null ? variationMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginPosted != null ? currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterpartyPreHaircut != null ? variationMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterpartyPostHaircut != null ? variationMarginCollectedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginCollected != null ? currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tradeParty1IDType != null ? tradeParty1IDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (submittingPartyIDType != null ? submittingPartyIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (usiID != null ? usiID.hashCode() : 0);
			_result = 31 * _result + (usiIDPrefix != null ? usiIDPrefix.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ReportingDestination != null ? tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (comment1 != null ? comment1.hashCode() : 0);
			_result = 31 * _result + (messageID != null ? messageID.hashCode() : 0);
			_result = 31 * _result + (messageType != null ? messageType.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CSAMarginReportBuilder {" +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"portfolioContainingNonReportableComponentIndicator=" + this.portfolioContainingNonReportableComponentIndicator + ", " +
				"initialMarginPostedByTheReportingCounterpartyPreHaircut=" + this.initialMarginPostedByTheReportingCounterpartyPreHaircut + ", " +
				"initialMarginPostedByTheReportingCounterpartyPostHaircut=" + this.initialMarginPostedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfInitialMarginPosted=" + this.currencyOfInitialMarginPosted + ", " +
				"initialMarginCollectedByTheReportingCounterpartyPreHaircut=" + this.initialMarginCollectedByTheReportingCounterpartyPreHaircut + ", " +
				"initialMarginCollectedByTheReportingCounterpartyPostHaircut=" + this.initialMarginCollectedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfInitialMarginCollected=" + this.currencyOfInitialMarginCollected + ", " +
				"variationMarginPostedByTheReportingCounterpartyPreHaircut=" + this.variationMarginPostedByTheReportingCounterpartyPreHaircut + ", " +
				"variationMarginPostedByTheReportingCounterpartyPostHaircut=" + this.variationMarginPostedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfVariationMarginPosted=" + this.currencyOfVariationMarginPosted + ", " +
				"variationMarginCollectedByTheReportingCounterpartyPreHaircut=" + this.variationMarginCollectedByTheReportingCounterpartyPreHaircut + ", " +
				"variationMarginCollectedByTheReportingCounterpartyPostHaircut=" + this.variationMarginCollectedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfVariationMarginCollected=" + this.currencyOfVariationMarginCollected + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"actionType=" + this.actionType + ", " +
				"tradeParty1IDType=" + this.tradeParty1IDType + ", " +
				"submittingPartyIDType=" + this.submittingPartyIDType + ", " +
				"usiID=" + this.usiID + ", " +
				"usiIDPrefix=" + this.usiIDPrefix + ", " +
				"tradeParty1ReportingDestination=" + this.tradeParty1ReportingDestination + ", " +
				"comment1=" + this.comment1 + ", " +
				"messageID=" + this.messageID + ", " +
				"messageType=" + this.messageType + ", " +
				"version=" + this.version +
			'}';
		}
	}
}
