package drr.regulation.csa.rewrite.trade.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import javax.inject.Inject;


@ImplementedBy(IsCSALeg2Aligned.IsCSALeg2AlignedDefault.class)
public abstract class IsCSALeg2Aligned implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg20;
	@Inject protected drr.regulation.csa.rewrite.trade.functions.CommodityLeg2 commodityLeg21;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected InterestRateLeg2 interestRateLeg20;
	@Inject protected drr.regulation.csa.rewrite.trade.functions.InterestRateLeg2 interestRateLeg21;
	@Inject protected PayoutMatches payoutMatches;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param transactionReportInstruction 
	* @return result 
	*/
	public Boolean evaluate(TransactionReportInstruction transactionReportInstruction) {
		Boolean result = doEvaluate(transactionReportInstruction);
		
		return result;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends Product> product(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends EconomicTerms> economicTerms(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends InterestRatePayout> csaInterestRateLeg2(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends InterestRatePayout> drrInterestRateLeg2(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends CommodityPayout> csaCommodityLeg2(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<? extends CommodityPayout> drrCommodityLeg2(TransactionReportInstruction transactionReportInstruction);

	public static class IsCSALeg2AlignedDefault extends IsCSALeg2Aligned {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction transactionReportInstruction) {
			Boolean result = null;
			return assignOutput(result, transactionReportInstruction);
		}
		
		protected Boolean assignOutput(Boolean result, TransactionReportInstruction transactionReportInstruction) {
			final Boolean boolean0 = qualify_AssetClass_InterestRate.evaluate(economicTerms(transactionReportInstruction).get());
			if ((boolean0 == null ? false : boolean0)) {
				result = payoutMatches.evaluate(csaInterestRateLeg2(transactionReportInstruction).get(), drrInterestRateLeg2(transactionReportInstruction).get());
			} else {
				final Boolean boolean1 = qualify_AssetClass_Commodity.evaluate(economicTerms(transactionReportInstruction).get());
				if ((boolean1 == null ? false : boolean1)) {
					result = payoutMatches.evaluate(csaCommodityLeg2(transactionReportInstruction).get(), drrCommodityLeg2(transactionReportInstruction).get());
				} else {
					result = true;
				}
			}
			
			return result;
		}
		
		@Override
		protected MapperS<? extends Product> product(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(transactionReportInstruction)));
		}
		
		@Override
		protected MapperS<? extends EconomicTerms> economicTerms(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(economicTermsForProduct.evaluate(product(transactionReportInstruction).get()));
		}
		
		@Override
		protected MapperS<? extends InterestRatePayout> csaInterestRateLeg2(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(interestRateLeg21.evaluate(product(transactionReportInstruction).get()));
		}
		
		@Override
		protected MapperS<? extends InterestRatePayout> drrInterestRateLeg2(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(interestRateLeg20.evaluate(product(transactionReportInstruction).get()));
		}
		
		@Override
		protected MapperS<? extends CommodityPayout> csaCommodityLeg2(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(commodityLeg21.evaluate(product(transactionReportInstruction).get()));
		}
		
		@Override
		protected MapperS<? extends CommodityPayout> drrCommodityLeg2(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(commodityLeg20.evaluate(product(transactionReportInstruction).get()));
		}
	}
}
