package drr.regulation.csa.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.product.template.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import javax.inject.Inject;


@ImplementedBy(BasketConstituentIdentifierSourceRule.BasketConstituentIdentifierSourceRuleDefault.class)
public abstract class BasketConstituentIdentifierSourceRule implements ReportFunction<BasketConstituent, ProductIdTypeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.regulation.common.trade.basket.reports.BasketConstituentIdentifierSourceRule basketConstituentIdentifierSourceRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ProductIdTypeEnum evaluate(BasketConstituent input) {
		ProductIdTypeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ProductIdTypeEnum doEvaluate(BasketConstituent input);

	public static class BasketConstituentIdentifierSourceRuleDefault extends BasketConstituentIdentifierSourceRule {
		@Override
		protected ProductIdTypeEnum doEvaluate(BasketConstituent input) {
			ProductIdTypeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ProductIdTypeEnum assignOutput(ProductIdTypeEnum output, BasketConstituent input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(basketConstituentIdentifierSourceRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
