package drr.regulation.esma.emir.refit.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.Counterparty2IdentifierEnum;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.EMIRTransactionReport;
import drr.regulation.common.trade.NonReportable;
import drr.regulation.common.trade.contract.MasterAgreementEnum;
import drr.regulation.common.trade.party.NatureOfCounterpartyEnum;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.underlier.UnderlyingIdentificationTypeEnum;
import drr.regulation.esma.emir.refit.trade.meta.ESMAEMIRTransactionReportMeta;
import drr.standards.iosco.cde.base.basket.BasketConstituentsReport;
import drr.standards.iosco.cde.base.payment.OtherPayment;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.PricePeriod;
import drr.standards.iosco.cde.version1.LegV1;
import drr.standards.iosco.cde.version2.LegV2;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ClearingObligationEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EnergyLoadType1Code;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.IndexEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.RiskReductionTechniqueEnum;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 6.17.1
 */
@RosettaDataType(value="ESMAEMIRTransactionReport", builder=ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilderImpl.class, version="6.17.1")
@RuneDataType(value="ESMAEMIRTransactionReport", model="drr", builder=ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilderImpl.class, version="6.17.1")
public interface ESMAEMIRTransactionReport extends EMIRTransactionReport {

	ESMAEMIRTransactionReportMeta metaData = new ESMAEMIRTransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 *
	 * Body ESMA
	 * Corpus Regulation EMIR 648/2012 "Regulation (EU) No 648/2012 of the European Parliament and of the Council of 4 July 2012 on OTC derivatives, central counterparties and trade repositories Text with EEA relevance"  * Corpus CommissionDelegatedRegulation RTS 2022/1855 "Commission Delegated Regulation (EU) No 2022/1855 of 10 June 2022 supplementing Regulation (EU) No 648/2012 of the European Parliament and of the Council on OTC derivatives, central counterparties and trade repositories with regard to regulatory technical standards specifying the minimum details of the data to be reported to trade repositories and the type of reports to be used." 
	 * table "1" * dataElement "5" * field "Nature of the Counterparty 1"
	 *
	 * Provision Indicate if the counterparty 1 is a CCP, a financial or a non-financial counterparty or other type of 
	         counterparty as defines in Article 2, points 1, 8 and 9, of Regulation (EU) No 648/2012, or an entity as referred to in Article 1, point 5, of that Regulation.
	 *
	 */
	@Override
	NatureOfCounterpartyEnum getNatureOfCounterparty1();
	/**
	 *
	 * Body ESMA
	 * Corpus Regulation EMIR 648/2012 "Regulation (EU) No 648/2012 of the European Parliament and of the Council of 4 July 2012 on OTC derivatives, central counterparties and trade repositories Text with EEA relevance"  * Corpus CommissionDelegatedRegulation RTS 2022/1855 "Commission Delegated Regulation (EU) No 2022/1855 of 10 June 2022 supplementing Regulation (EU) No 648/2012 of the European Parliament and of the Council on OTC derivatives, central counterparties and trade repositories with regard to regulatory technical standards specifying the minimum details of the data to be reported to trade repositories and the type of reports to be used." 
	 * table "1" * dataElement "8" * field "Counterparty 2 Identifier Type"
	 *
	 * Provision Indicator of whether LEI was used to identify the Counterparty 2
	 *
	 */
	@Override
	Boolean getCounterparty2IdentifierType();
	/**
	 *
	 * Body ESMA
	 * Corpus Regulation EMIR 648/2012 "Regulation (EU) No 648/2012 of the European Parliament and of the Council of 4 July 2012 on OTC derivatives, central counterparties and trade repositories Text with EEA relevance"  * Corpus CommissionDelegatedRegulation RTS 2022/1855 "Commission Delegated Regulation (EU) No 2022/1855 of 10 June 2022 supplementing Regulation (EU) No 648/2012 of the European Parliament and of the Council on OTC derivatives, central counterparties and trade repositories with regard to regulatory technical standards specifying the minimum details of the data to be reported to trade repositories and the type of reports to be used." 
	 * table "2" * dataElement "10" * field "Contract type"
	 *
	 * Provision Each reported contract shall be classified according to its type.
	                 CFDS = Financial contracts for difference FRAS = Forward rate agreements FUTR = Futures FORW = Forwards OPTN = Option SPDB = Spreadbet SWAP = Swap SWPT = Swaption OTHR = Other
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20230920"
	 *
	 * Provision SPDB and CFDS output values will not be supported in DRR until CDM is able to functionally qualify them as distinct products. The qualification of these products needs to be backed by transaction or reporting samples provided by DRR firms.
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20230920"
	 *
	 * Provision OTHR is populated if none of the possible outputs are a precise fit
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup TechnicalExecutionGroup ISDA DRR Technical Execution Working Group "Working Group comprised of firms who determine the approach to modeling DRR and contribute to the development of DRR via test packs, coding and/or reviewing what has been modeled in line with DRR SteerCO-determined roadmap, scope &amp; priorities." 
	 * date "20231003"
	 *
	 * Provision The decision has been to apply ETD functionality to all products as a matter of prudence and consistency, understanding products like Swap are generally not ETD
	 *
	 */
	@Override
	CommonContractType getContractType();
	/**
	 *
	 * Body ESMA
	 * Corpus Regulation EMIR 648/2012 "Regulation (EU) No 648/2012 of the European Parliament and of the Council of 4 July 2012 on OTC derivatives, central counterparties and trade repositories Text with EEA relevance"  * Corpus CommissionDelegatedRegulation RTS 2022/1855 "Commission Delegated Regulation (EU) No 2022/1855 of 10 June 2022 supplementing Regulation (EU) No 648/2012 of the European Parliament and of the Council on OTC derivatives, central counterparties and trade repositories with regard to regulatory technical standards specifying the minimum details of the data to be reported to trade repositories and the type of reports to be used." 
	 * table "2" * dataElement "11" * field "Asset class"
	 *
	 * Provision Each reported contract shall be classified according to the asset class it is based on.
	 *
	 *
	 * Body ESMA
	 * Corpus QandAOnEMIRReporting QandA_On_EMIR_Reporting ESMA70-1861941480-52 "Questions and Answers. Implementation of the Regulation (EU) No 648/2012 on OTC derivatives, central counterparties and trade repositories (EMIR)" 
	 * section "TR" * question "1"
	 *
	 * Provision TR Question 1 [last update 24 September 2020] How should the following financial instruments be classified for reporting and other purposes under EMIR? (b) Cross-currency swaps, swaptions, Caps and Floors? (c) Total Return Swaps
	                 TR Answer 1 (b) These financial instruments should be classified as interest rates, in line with current market practice. On the sections to be reported, ESMA finds that where both sections are relevant having in mind the terms of the contract being reported, both sections of reporting fields are to be reported i.e.option and interest rate for swaption, Caps and Floors, and FX and interest rate or crosscurrency swaps. The contract type (Field 1 of Table 2) should be populated with the value ST for swaption.There are two fields for the notional amount currency and one for the notional amount. To avoid that one counterparty reports the notional amount in CCY1 (Field 9 of Table 2) while the other would report in CCY2 (Field 10 of Table 2), which would create a reconciliation problem, the Field Notional Amount (Field 20 of Table 2) should be denominated in the currency reported in Notional currency 1 (Field 9 of Table 2).
	                 (c) Total Return Swaps should be classified based on the underlying. For example, a Total Return Swap on an equity index should be reported with value EQ in field Asset class (Table 2 field 2), whereas a Total Return Swap on a bond or loan should be reported with value CR in field Asset class (Table 2 field 2).
	 *
	 */
	@Override
	CommonAssetClass getAssetClass();
	/**
	 *
	 * Body ESMA
	 * Corpus Regulation EMIR 648/2012 "Regulation (EU) No 648/2012 of the European Parliament and of the Council of 4 July 2012 on OTC derivatives, central counterparties and trade repositories Text with EEA relevance"  * Corpus CommissionDelegatedRegulation RTS 2022/1855 "Commission Delegated Regulation (EU) No 2022/1855 of 10 June 2022 supplementing Regulation (EU) No 648/2012 of the European Parliament and of the Council on OTC derivatives, central counterparties and trade repositories with regard to regulatory technical standards specifying the minimum details of the data to be reported to trade repositories and the type of reports to be used." 
	 * table "2" * dataElement "12" * field "Derivative based on crypto-assets"
	 *
	 * Provision Indicator whether the derivative is based on crypto-assets.
	 *
	 */
	@Override
	Boolean getCryptoAssetUnderlyingIndicator();
	/**
	 *
	 * Body ESMA
	 * Corpus Regulation EMIR 648/2012 "Regulation (EU) No 648/2012 of the European Parliament and of the Council of 4 July 2012 on OTC derivatives, central counterparties and trade repositories Text with EEA relevance"  * Corpus CommissionDelegatedRegulation RTS 2022/1855 "Commission Delegated Regulation (EU) No 2022/1855 of 10 June 2022 supplementing Regulation (EU) No 648/2012 of the European Parliament and of the Council on OTC derivatives, central counterparties and trade repositories with regard to regulatory technical standards specifying the minimum details of the data to be reported to trade repositories and the type of reports to be used." 
	 * table "2" * dataElement "31" * field "Cleared"
	 *
	 * Provision Indicator of whether the derivative has been cleared by a CCP.
	 *
	 */
	@Override
	ClearedEnum getCleared();
	/**
	 *
	 * Body ESMA
	 * Corpus Regulation EMIR 648/2012 "Regulation (EU) No 648/2012 of the European Parliament and of the Council of 4 July 2012 on OTC derivatives, central counterparties and trade repositories Text with EEA relevance"  * Corpus CommissionDelegatedRegulation RTS 2022/1855 "Commission Delegated Regulation (EU) No 2022/1855 of 10 June 2022 supplementing Regulation (EU) No 648/2012 of the European Parliament and of the Council on OTC derivatives, central counterparties and trade repositories with regard to regulatory technical standards specifying the minimum details of the data to be reported to trade repositories and the type of reports to be used." 
	 * table "2" * dataElement "34" * field "Master Agreement Type"
	 *
	 * Provision Reference to the master agreement type under which the counterparties concluded a derivative
	 *
	 */
	@Override
	MasterAgreementEnum getMasterAgreementType();
	/**
	 *
	 * Body ESMA
	 * Corpus Regulation EMIR 648/2012 "Regulation (EU) No 648/2012 of the European Parliament and of the Council of 4 July 2012 on OTC derivatives, central counterparties and trade repositories Text with EEA relevance"  * Corpus CommissionDelegatedRegulation RTS 2022/1855 "Commission Delegated Regulation (EU) No 2022/1855 of 10 June 2022 supplementing Regulation (EU) No 648/2012 of the European Parliament and of the Council on OTC derivatives, central counterparties and trade repositories with regard to regulatory technical standards specifying the minimum details of the data to be reported to trade repositories and the type of reports to be used." 
	 * table "2" * dataElement "42" * field "Execution Timestamp"
	 *
	 * Provision Date and time a transaction was originally executed, resulting in the generation of a new UTI. This data element remains unchanged throughout the life of the UTI. For position level reporting it should refer to the time when position was opened for the first time.
	 *
	 */
	@Override
	ZonedDateTime getExecutionTimestamp();
	/**
	 *
	 * Body ESMA
	 * Corpus Regulation EMIR 648/2012 "Regulation (EU) No 648/2012 of the European Parliament and of the Council of 4 July 2012 on OTC derivatives, central counterparties and trade repositories Text with EEA relevance"  * Corpus CommissionDelegatedRegulation RTS 2022/1855 "Commission Delegated Regulation (EU) No 2022/1855 of 10 June 2022 supplementing Regulation (EU) No 648/2012 of the European Parliament and of the Council on OTC derivatives, central counterparties and trade repositories with regard to regulatory technical standards specifying the minimum details of the data to be reported to trade repositories and the type of reports to be used." 
	 * table "2" * dataElement "43" * field "Effective Date"
	 *
	 * Provision Unadjusted date at which obligations under the OTC derivative transaction come into effect, as included in the confirmation. If the effective date is not specified as part of the terms of the contract, the counterparties shall report in this field the date of execution of the derivative.
	 *
	 *
	 * Body ISDA
	 * Corpus BestPractice EMIRReportingBestPractice 24Apr2024 "The EMIR Reporting Best Practices cover 238 data points across 203 reporting fields, including both over-the-counter and exchange-traded derivatives, and were developed to improve the accuracy and efficiency of trade reporting and to reduce compliance costs. The best practices are available to all market participants to access and implement.  The EMIR Reporting Best Practices is a cross-trade association initiative developed jointly by the European Fund and Asset Management Association (EFAMA), European Venues and Intermediaries Association (EVIA), Futures Industry Association (FIA), German Investment Funds Association (BVI), Global Foreign Exchange Division (GFXD), International Swaps and Derivatives Association, Inc. (ISDA) and Investment Association (IA)." 
	 * table "2" * field "26"
	 *
	 * Provision Where an Effective Date is specified in the terms of the contract, report that date (i.e. the effective date represented on the confirmation). If an effective date is not specified in the terms of the contract, report the execution date (see best practice for Execution Timestamp).
	 *
	 */
	@Override
	Date getEffectiveDate();
	/**
	 *
	 * Body ESMA
	 * Corpus Regulation EMIR 648/2012 "Regulation (EU) No 648/2012 of the European Parliament and of the Council of 4 July 2012 on OTC derivatives, central counterparties and trade repositories Text with EEA relevance"  * Corpus CommissionDelegatedRegulation RTS 2022/1855 "Commission Delegated Regulation (EU) No 2022/1855 of 10 June 2022 supplementing Regulation (EU) No 648/2012 of the European Parliament and of the Council on OTC derivatives, central counterparties and trade repositories with regard to regulatory technical standards specifying the minimum details of the data to be reported to trade repositories and the type of reports to be used." 
	 * table "2" * dataElement "47" * field "Delivery type"
	 *
	 * Provision Indicates whether the contract is settled physically or in cash.
	 *
	 */
	@Override
	DeliveryTypeEnum getDeliveryType();
	/**
	 *
	 * Body ESMA
	 * Corpus Regulation EMIR 648/2012 "Regulation (EU) No 648/2012 of the European Parliament and of the Council of 4 July 2012 on OTC derivatives, central counterparties and trade repositories Text with EEA relevance"  * Corpus CommissionDelegatedRegulation RTS 2022/1855 "Commission Delegated Regulation (EU) No 2022/1855 of 10 June 2022 supplementing Regulation (EU) No 648/2012 of the European Parliament and of the Council on OTC derivatives, central counterparties and trade repositories with regard to regulatory technical standards specifying the minimum details of the data to be reported to trade repositories and the type of reports to be used." 
	 * table "2" * dataElement "154" * field "Level"
	 *
	 * Provision Indication whether the report is done at trade or position level. Position level report can be used only as a supplement to trade level reporting to report post-trade events and only if individual trades in fungible products have been replaced by the position.
	 *
	 */
	@Override
	ReportLevelEnum getLevel();

	/*********************** Build Methods  ***********************/
	ESMAEMIRTransactionReport build();
	
	ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder toBuilder();
	
	static ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder builder() {
		return new ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ESMAEMIRTransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ESMAEMIRTransactionReport> getType() {
		return ESMAEMIRTransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
		processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, getBuyerIdentifier(), this);
		processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, getSellerIdentifier(), this);
		processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
		processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, getPriceSchedule());
		processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, getStrikePriceSchedule());
		processRosetta(path.newSubPath("price"), processor, PriceFormat.class, getPrice());
		processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
		processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, getPackageTransactionPrice());
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, getPackageTransactionSpread());
		processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, getStrikePrice());
		processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
		processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, getSettlementLocation(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
		processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, getBasketConstituents());
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, getOtherPayment());
		processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, getLeg1());
		processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, getLeg2());
		processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, getUnderlyingIdOther(), this);
		processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, getUnderlyingIdOtherSource(), this);
		processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, getUnderlyingAssetTradingPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, getUnderlyingAssetPriceSource(), this);
		processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, getCryptoAssetUnderlyingIndicator(), this);
		processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, getLevel(), this);
		processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, getExecutionAgentCounterparty2(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
		processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
		processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, getBarrier());
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
		processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
		processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
		processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
		processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, getClearingAccountOrigin(), this);
		processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, getOriginalSwapUTI(), this);
		processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, getOriginalSwapSDRIdentifier(), this);
		processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
		processor.processBasic(path.newSubPath("priorUSI"), String.class, getPriorUSI(), this);
		processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
		processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, getMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
		processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
		processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
		processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
		processor.processBasic(path.newSubPath("brokerID"), String.class, getBrokerID(), this);
		processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
		processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, getSeriesVersion(), this);
		processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, getSecondaryTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, getNatureOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, getNatureOfCounterparty2(), this);
		processor.processBasic(path.newSubPath("swapLinkID"), String.class, getSwapLinkID(), this);
		processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty1(), this);
		processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty2(), this);
		processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
		processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
		processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
		processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, getCounterparty2IdentifierSource(), this);
		processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
		processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
		processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, getUnderlyingIdentificationType(), this);
		processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, getCorporateSectorOfTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, getCorporateSectorOfTheCounterparty2(), this);
		processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.class, getNonReportable());
		processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, getClearingThresholdOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, getClearingThresholdOfCounterparty2(), this);
		processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, getReportingObligationOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this);
		processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
		processor.processBasic(path.newSubPath("ptrrId"), String.class, getPtrrId(), this);
		processor.processBasic(path.newSubPath("isin"), String.class, getIsin(), this);
		processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
		processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), IndexEnum.class, getIndicatorOfTheUnderlyingIndex(), this);
		processor.processBasic(path.newSubPath("clearingObligation"), ClearingObligationEnum.class, getClearingObligation(), this);
		processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, getOtherMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("ptrr"), Boolean.class, getPtrr(), this);
		processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), RiskReductionTechniqueEnum.class, getTypeOfPTRRTechnique(), this);
		processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, getPtrrServiceProvider(), this);
		processor.processBasic(path.newSubPath("venueOfExecution"), String.class, getVenueOfExecution(), this);
		processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
		processor.processBasic(path.newSubPath("deliveryPoint"), String.class, getDeliveryPoint(), this);
		processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, getInterconnectionPoint(), this);
		processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, getLoadType(), this);
		processRosetta(path.newSubPath("deliveryReport"), processor, ReportableDelivery.class, getDeliveryReport());
		processor.processBasic(path.newSubPath("tranche"), Boolean.class, getTranche(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, getCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ESMAEMIRTransactionReportBuilder extends ESMAEMIRTransactionReport, EMIRTransactionReport.EMIRTransactionReportBuilder {
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEffectiveDate(Date effectiveDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEarlyTerminationDate(Date earlyTerminationDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExpirationDate(Date expirationDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty1(String counterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2(String counterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBeneficiary1(String beneficiary1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean beneficiary1IdentifierTypeIndicator);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBuyerIdentifier(String buyerIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSellerIdentifier(String sellerIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCleared(ClearedEnum cleared);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingMember(String clearingMember);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setConfirmed(ConfirmationEnum confirmed);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCallAmount(BigDecimal callAmount);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPutAmount(BigDecimal putAmount);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDelta(BigDecimal delta);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule, int idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule, int idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPrice(PriceFormat price);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceNotation(PriceNotationEnum priceNotation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum priceCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPrice(PriceFormat packageTransactionPrice);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum packageTransactionPriceNotation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum packageTransactionPriceCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpread(PriceFormat packageTransactionSpread);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum packageTransactionSpreadNotation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum packageTransactionSpreadCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePrice(PriceFormat strikePrice);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum strikePriceNotation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceCurrency(String strikePriceCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFirstExerciseDate(Date firstExerciseDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum settlementLocation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriorUTI(String priorUTI);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationAmount(BigDecimal valuationAmount);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCustomBasketCode(String customBasketCode);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents, int idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment otherPayment);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment otherPayment, int idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(LegV1 leg1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(LegV1 leg2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(LegV2 leg1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(LegV2 leg2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(Leg leg1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(Leg leg2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingIdOther(String underlyingIdOther);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum underlyingIdOtherSource);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String underlyingAssetTradingPlatformIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingAssetPriceSource(String underlyingAssetPriceSource);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean cryptoAssetUnderlyingIndicator);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLevel(ReportLevelEnum level);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setActionType(ActionTypeEnum actionType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventType(EventTypeEnum eventType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventIdentifier(String eventIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(CommonLeg leg1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(CommonLeg leg2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2Name(String counterparty2Name);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty1(String executionAgentCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty2(String executionAgentCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriorUTIProprietary(String priorUTIProprietary);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setContractType(CommonContractType contractType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setAssetClass(CommonAssetClass assetClass);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirection1(Direction1Enum direction1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier barrier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionType(OptionTypeCode optionType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionStyle(OptionStyleEnum optionStyle);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryType(DeliveryTypeEnum deliveryType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum countryOfTheCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum bookingLocation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum traderLocation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTradingCapacity(TradingCapacity7Code tradingCapacity);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum embeddedOptionType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSeniority(SeniorityEnum seniority);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSeries(Integer series);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTechnicalRecordId(String technicalRecordId);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum clearingAccountOrigin);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOriginalSwapUTI(String originalSwapUTI);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOriginalSwapSDRIdentifier(String originalSwapSDRIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime clearingReceiptTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriorUSI(String priorUSI);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNewSDRIdentifier(String newSDRIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSubsequentPositionUTI(String subsequentPositionUTI);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMasterAgreementType(MasterAgreementEnum masterAgreementType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMasterAgreementVersion(Integer masterAgreementVersion);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNonStandardizedTermIndicator(Boolean nonStandardizedTermIndicator);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setAmendmentIndicator(Boolean amendmentIndicator);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageIndicator(Boolean packageIndicator);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBrokerID(String brokerID);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime confirmationTimestamp);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSeriesVersion(Integer seriesVersion);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSecondaryTransactionIdentifier(String secondaryTransactionIdentifier);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum natureOfCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum natureOfCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSwapLinkID(String swapLinkID);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty1, int idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty2, int idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBaseProduct(String baseProduct);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSubProduct(String subProduct);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFurtherSubProduct(String furtherSubProduct);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIntragroup(Boolean intragroup);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReferenceEntity(String referenceEntity);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum counterparty2IdentifierSource);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCustomBasketIndicator(Boolean customBasketIndicator);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingIdentification(String underlyingIdentification);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum underlyingIdentificationType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String corporateSectorOfTheCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String corporateSectorOfTheCounterparty1, int idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String corporateSectorOfTheCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String corporateSectorOfTheCounterparty2, int idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNonReportable(NonReportable nonReportable);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean clearingThresholdOfCounterparty1);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean clearingThresholdOfCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean reportingObligationOfTheCounterparty2);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportTrackingNumber(String reportTrackingNumber);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrrId(String ptrrId);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIsin(String isin);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setProductClassification(String productClassification);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum indicatorOfTheUnderlyingIndex);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum indicatorOfTheUnderlyingIndex, int idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndex);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndex);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingObligation(ClearingObligationEnum clearingObligation);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOtherMasterAgreementType(String otherMasterAgreementType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrr(Boolean ptrr);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTypeOfPTRRTechnique(RiskReductionTechniqueEnum typeOfPTRRTechnique);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrrServiceProvider(String ptrrServiceProvider);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setVenueOfExecution(String venueOfExecution);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal forwardExchangeRate);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(String deliveryPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(String deliveryPoint, int idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(List<String> deliveryPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryPoint(List<String> deliveryPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setInterconnectionPoint(String interconnectionPoint);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code loadType);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery deliveryReport);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery deliveryReport, int idx);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(List<? extends ReportableDelivery> deliveryReport);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryReport(List<? extends ReportableDelivery> deliveryReport);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTranche(Boolean tranche);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCollateralPortfolioCode(String collateralPortfolioCode);
		@Override
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventDate(Date eventDate);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum(NatureOfCounterpartyEnum natureOfCounterparty1);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean counterparty2IdentifierType);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setContractTypeOverriddenAsCommonContractType(CommonContractType contractType);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setAssetClassOverriddenAsCommonAssetClass(CommonAssetClass assetClass);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCryptoAssetUnderlyingIndicatorOverriddenAsBoolean(Boolean cryptoAssetUnderlyingIndicator);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum cleared);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMasterAgreementTypeOverriddenAsMasterAgreementEnum(MasterAgreementEnum masterAgreementType);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionTimestampOverriddenAsZonedDateTime(ZonedDateTime executionTimestamp);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEffectiveDateOverriddenAsDate(Date effectiveDate);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryTypeOverriddenAsDeliveryTypeEnum(DeliveryTypeEnum deliveryType);
		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLevelOverriddenAsReportLevelEnum(ReportLevelEnum level);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
			processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, getBuyerIdentifier(), this);
			processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, getSellerIdentifier(), this);
			processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
			processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getPriceSchedule());
			processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getStrikePriceSchedule());
			processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, getPrice());
			processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
			processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionPrice());
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionSpread());
			processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, getStrikePrice());
			processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
			processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, getSettlementLocation(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
			processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, getBasketConstituents());
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, getOtherPayment());
			processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, getLeg1());
			processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, getLeg2());
			processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, getUnderlyingIdOther(), this);
			processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, getUnderlyingIdOtherSource(), this);
			processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, getUnderlyingAssetTradingPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, getUnderlyingAssetPriceSource(), this);
			processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, getCryptoAssetUnderlyingIndicator(), this);
			processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, getLevel(), this);
			processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, getExecutionAgentCounterparty2(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
			processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
			processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, getBarrier());
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
			processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
			processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
			processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
			processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, getClearingAccountOrigin(), this);
			processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, getOriginalSwapUTI(), this);
			processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, getOriginalSwapSDRIdentifier(), this);
			processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
			processor.processBasic(path.newSubPath("priorUSI"), String.class, getPriorUSI(), this);
			processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
			processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, getMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
			processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
			processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
			processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
			processor.processBasic(path.newSubPath("brokerID"), String.class, getBrokerID(), this);
			processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
			processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, getSeriesVersion(), this);
			processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, getSecondaryTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, getNatureOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, getNatureOfCounterparty2(), this);
			processor.processBasic(path.newSubPath("swapLinkID"), String.class, getSwapLinkID(), this);
			processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty1(), this);
			processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty2(), this);
			processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
			processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
			processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
			processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, getCounterparty2IdentifierSource(), this);
			processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
			processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
			processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, getUnderlyingIdentificationType(), this);
			processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, getCorporateSectorOfTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, getCorporateSectorOfTheCounterparty2(), this);
			processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.NonReportableBuilder.class, getNonReportable());
			processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, getClearingThresholdOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, getClearingThresholdOfCounterparty2(), this);
			processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, getReportingObligationOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this);
			processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
			processor.processBasic(path.newSubPath("ptrrId"), String.class, getPtrrId(), this);
			processor.processBasic(path.newSubPath("isin"), String.class, getIsin(), this);
			processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
			processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), IndexEnum.class, getIndicatorOfTheUnderlyingIndex(), this);
			processor.processBasic(path.newSubPath("clearingObligation"), ClearingObligationEnum.class, getClearingObligation(), this);
			processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, getOtherMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("ptrr"), Boolean.class, getPtrr(), this);
			processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), RiskReductionTechniqueEnum.class, getTypeOfPTRRTechnique(), this);
			processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, getPtrrServiceProvider(), this);
			processor.processBasic(path.newSubPath("venueOfExecution"), String.class, getVenueOfExecution(), this);
			processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
			processor.processBasic(path.newSubPath("deliveryPoint"), String.class, getDeliveryPoint(), this);
			processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, getInterconnectionPoint(), this);
			processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, getLoadType(), this);
			processRosetta(path.newSubPath("deliveryReport"), processor, ReportableDelivery.ReportableDeliveryBuilder.class, getDeliveryReport());
			processor.processBasic(path.newSubPath("tranche"), Boolean.class, getTranche(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, getCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
		}
		

		ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of ESMAEMIRTransactionReport  ***********************/
	class ESMAEMIRTransactionReportImpl extends EMIRTransactionReport.EMIRTransactionReportImpl implements ESMAEMIRTransactionReport {
		private final NatureOfCounterpartyEnum natureOfCounterparty1;
		private final Boolean counterparty2IdentifierType;
		private final CommonContractType contractType;
		private final CommonAssetClass assetClass;
		private final Boolean cryptoAssetUnderlyingIndicator;
		private final ClearedEnum cleared;
		private final MasterAgreementEnum masterAgreementType;
		private final ZonedDateTime executionTimestamp;
		private final Date effectiveDate;
		private final DeliveryTypeEnum deliveryType;
		private final ReportLevelEnum level;
		
		protected ESMAEMIRTransactionReportImpl(ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder builder) {
			super(builder);
			this.natureOfCounterparty1 = builder.getNatureOfCounterparty1();
			this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
			this.contractType = builder.getContractType();
			this.assetClass = builder.getAssetClass();
			this.cryptoAssetUnderlyingIndicator = builder.getCryptoAssetUnderlyingIndicator();
			this.cleared = builder.getCleared();
			this.masterAgreementType = builder.getMasterAgreementType();
			this.executionTimestamp = builder.getExecutionTimestamp();
			this.effectiveDate = builder.getEffectiveDate();
			this.deliveryType = builder.getDeliveryType();
			this.level = builder.getLevel();
		}
		
		@Override
		@RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
		@RuneAttribute(value="natureOfCounterparty1", isRequired=true)
		public NatureOfCounterpartyEnum getNatureOfCounterparty1() {
			return natureOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		public CommonContractType getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public CommonAssetClass getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
		@RuneAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
		public Boolean getCryptoAssetUnderlyingIndicator() {
			return cryptoAssetUnderlyingIndicator;
		}
		
		@Override
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		public ClearedEnum getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute(value="masterAgreementType", isRequired=true)
		@RuneAttribute(value="masterAgreementType", isRequired=true)
		public MasterAgreementEnum getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute(value="deliveryType", isRequired=true)
		@RuneAttribute(value="deliveryType", isRequired=true)
		public DeliveryTypeEnum getDeliveryType() {
			return deliveryType;
		}
		
		@Override
		@RosettaAttribute(value="level", isRequired=true)
		@RuneAttribute(value="level", isRequired=true)
		public ReportLevelEnum getLevel() {
			return level;
		}
		
		@Override
		public ESMAEMIRTransactionReport build() {
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder toBuilder() {
			ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getNatureOfCounterparty1()).ifPresent(builder::setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum);
			ofNullable(getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierTypeOverriddenAsBoolean);
			ofNullable(getContractType()).ifPresent(builder::setContractTypeOverriddenAsCommonContractType);
			ofNullable(getAssetClass()).ifPresent(builder::setAssetClassOverriddenAsCommonAssetClass);
			ofNullable(getCryptoAssetUnderlyingIndicator()).ifPresent(builder::setCryptoAssetUnderlyingIndicatorOverriddenAsBoolean);
			ofNullable(getCleared()).ifPresent(builder::setClearedOverriddenAsClearedEnum);
			ofNullable(getMasterAgreementType()).ifPresent(builder::setMasterAgreementTypeOverriddenAsMasterAgreementEnum);
			ofNullable(getExecutionTimestamp()).ifPresent(builder::setExecutionTimestampOverriddenAsZonedDateTime);
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDateOverriddenAsDate);
			ofNullable(getDeliveryType()).ifPresent(builder::setDeliveryTypeOverriddenAsDeliveryTypeEnum);
			ofNullable(getLevel()).ifPresent(builder::setLevelOverriddenAsReportLevelEnum);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			ESMAEMIRTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(natureOfCounterparty1, _that.getNatureOfCounterparty1())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(cryptoAssetUnderlyingIndicator, _that.getCryptoAssetUnderlyingIndicator())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(masterAgreementType, _that.getMasterAgreementType())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(deliveryType, _that.getDeliveryType())) return false;
			if (!Objects.equals(level, _that.getLevel())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (natureOfCounterparty1 != null ? natureOfCounterparty1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (cryptoAssetUnderlyingIndicator != null ? cryptoAssetUnderlyingIndicator.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (masterAgreementType != null ? masterAgreementType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (deliveryType != null ? deliveryType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (level != null ? level.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ESMAEMIRTransactionReport {" +
				"natureOfCounterparty1=" + this.natureOfCounterparty1 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"contractType=" + this.contractType + ", " +
				"assetClass=" + this.assetClass + ", " +
				"cryptoAssetUnderlyingIndicator=" + this.cryptoAssetUnderlyingIndicator + ", " +
				"cleared=" + this.cleared + ", " +
				"masterAgreementType=" + this.masterAgreementType + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"deliveryType=" + this.deliveryType + ", " +
				"level=" + this.level +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of ESMAEMIRTransactionReport  ***********************/
	class ESMAEMIRTransactionReportBuilderImpl extends EMIRTransactionReport.EMIRTransactionReportBuilderImpl implements ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder {
	
		protected NatureOfCounterpartyEnum natureOfCounterparty1;
		protected Boolean counterparty2IdentifierType;
		protected CommonContractType contractType;
		protected CommonAssetClass assetClass;
		protected Boolean cryptoAssetUnderlyingIndicator;
		protected ClearedEnum cleared;
		protected MasterAgreementEnum masterAgreementType;
		protected ZonedDateTime executionTimestamp;
		protected Date effectiveDate;
		protected DeliveryTypeEnum deliveryType;
		protected ReportLevelEnum level;
		
		@Override
		@RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
		@RuneAttribute(value="natureOfCounterparty1", isRequired=true)
		public NatureOfCounterpartyEnum getNatureOfCounterparty1() {
			return natureOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		public CommonContractType getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public CommonAssetClass getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
		@RuneAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
		public Boolean getCryptoAssetUnderlyingIndicator() {
			return cryptoAssetUnderlyingIndicator;
		}
		
		@Override
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		public ClearedEnum getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute(value="masterAgreementType", isRequired=true)
		@RuneAttribute(value="masterAgreementType", isRequired=true)
		public MasterAgreementEnum getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute(value="deliveryType", isRequired=true)
		@RuneAttribute(value="deliveryType", isRequired=true)
		public DeliveryTypeEnum getDeliveryType() {
			return deliveryType;
		}
		
		@Override
		@RosettaAttribute(value="level", isRequired=true)
		@RuneAttribute(value="level", isRequired=true)
		public ReportLevelEnum getLevel() {
			return level;
		}
		
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEffectiveDateOverriddenAsDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			return setEffectiveDateOverriddenAsDate(_effectiveDate);
		}
		
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
			this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
			return this;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionTimestampOverriddenAsZonedDateTime(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			return setExecutionTimestampOverriddenAsZonedDateTime(_executionTimestamp);
		}
		
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			return setCounterparty2IdentifierTypeOverriddenAsBoolean(_counterparty2IdentifierType);
		}
		
		@RosettaAttribute("beneficiary1")
		@RuneAttribute("beneficiary1")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBeneficiary1(String _beneficiary1) {
			this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
			return this;
		}
		
		@RosettaAttribute("beneficiary1IdentifierTypeIndicator")
		@RuneAttribute("beneficiary1IdentifierTypeIndicator")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
			this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
			return this;
		}
		
		@RosettaAttribute("buyerIdentifier")
		@RuneAttribute("buyerIdentifier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBuyerIdentifier(String _buyerIdentifier) {
			this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
			return this;
		}
		
		@RosettaAttribute("sellerIdentifier")
		@RuneAttribute("sellerIdentifier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSellerIdentifier(String _sellerIdentifier) {
			this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
			return this;
		}
		
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCleared(ClearedEnum _cleared) {
			return setClearedOverriddenAsClearedEnum(_cleared);
		}
		
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDelta(BigDecimal _delta) {
			this.delta = _delta == null ? null : _delta;
			return this;
		}
		
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
			if (_priceSchedule != null) {
				this.priceSchedule.add(_priceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int idx) {
			getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules != null) {
				for (final PricePeriod toAdd : priceSchedules) {
					this.priceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("priceSchedule")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules == null) {
				this.priceSchedule = new ArrayList<>();
			} else {
				this.priceSchedule = priceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
			if (_strikePriceSchedule != null) {
				this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int idx) {
			getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules != null) {
				for (final PricePeriod toAdd : strikePriceSchedules) {
					this.strikePriceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("strikePriceSchedule")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules == null) {
				this.strikePriceSchedule = new ArrayList<>();
			} else {
				this.strikePriceSchedule = strikePriceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("price")
		@RuneAttribute("price")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPrice(PriceFormat _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
			this.priceNotation = _priceNotation == null ? null : _priceNotation;
			return this;
		}
		
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
			this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
			this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
			this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
			this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
			return this;
		}
		
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
			this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
			return this;
		}
		
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
			this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
			return this;
		}
		
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
			this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
			return this;
		}
		
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@RosettaAttribute("settlementLocation")
		@RuneAttribute("settlementLocation")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
			this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
			return this;
		}
		
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
			this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
			return this;
		}
		
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
			if (_basketConstituents != null) {
				this.basketConstituents.add(_basketConstituents.toBuilder());
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
			getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss != null) {
				for (final BasketConstituentsReport toAdd : basketConstituentss) {
					this.basketConstituents.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("basketConstituents")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss == null) {
				this.basketConstituents = new ArrayList<>();
			} else {
				this.basketConstituents = basketConstituentss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int idx) {
			getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPayment toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("otherPayment")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("leg1")
		@RuneAttribute("leg1")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(CommonLeg _leg1) {
			this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(Leg _leg1) {
			final CommonLeg ifThenElseResult;
			if (_leg1 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg1 instanceof CommonLeg ? CommonLeg.class.cast(_leg1) : null;
			}
			return setLeg1(ifThenElseResult);
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(LegV2 _leg1) {
			final CommonLeg ifThenElseResult;
			if (_leg1 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg1 instanceof CommonLeg ? CommonLeg.class.cast(_leg1) : null;
			}
			return setLeg1(ifThenElseResult);
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg1(LegV1 _leg1) {
			final CommonLeg ifThenElseResult;
			if (_leg1 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg1 instanceof CommonLeg ? CommonLeg.class.cast(_leg1) : null;
			}
			return setLeg1(ifThenElseResult);
		}
		
		@RosettaAttribute("leg2")
		@RuneAttribute("leg2")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(CommonLeg _leg2) {
			this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(Leg _leg2) {
			final CommonLeg ifThenElseResult;
			if (_leg2 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg2 instanceof CommonLeg ? CommonLeg.class.cast(_leg2) : null;
			}
			return setLeg2(ifThenElseResult);
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(LegV2 _leg2) {
			final CommonLeg ifThenElseResult;
			if (_leg2 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg2 instanceof CommonLeg ? CommonLeg.class.cast(_leg2) : null;
			}
			return setLeg2(ifThenElseResult);
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLeg2(LegV1 _leg2) {
			final CommonLeg ifThenElseResult;
			if (_leg2 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg2 instanceof CommonLeg ? CommonLeg.class.cast(_leg2) : null;
			}
			return setLeg2(ifThenElseResult);
		}
		
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
			this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
			return this;
		}
		
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum _underlyingIdOtherSource) {
			this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
			return this;
		}
		
		@RosettaAttribute("underlyingAssetTradingPlatformIdentifier")
		@RuneAttribute("underlyingAssetTradingPlatformIdentifier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String _underlyingAssetTradingPlatformIdentifier) {
			this.underlyingAssetTradingPlatformIdentifier = _underlyingAssetTradingPlatformIdentifier == null ? null : _underlyingAssetTradingPlatformIdentifier;
			return this;
		}
		
		@RosettaAttribute("underlyingAssetPriceSource")
		@RuneAttribute("underlyingAssetPriceSource")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingAssetPriceSource(String _underlyingAssetPriceSource) {
			this.underlyingAssetPriceSource = _underlyingAssetPriceSource == null ? null : _underlyingAssetPriceSource;
			return this;
		}
		
		@RosettaAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
		@RuneAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCryptoAssetUnderlyingIndicatorOverriddenAsBoolean(Boolean _cryptoAssetUnderlyingIndicator) {
			this.cryptoAssetUnderlyingIndicator = _cryptoAssetUnderlyingIndicator == null ? null : _cryptoAssetUnderlyingIndicator;
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean _cryptoAssetUnderlyingIndicator) {
			return setCryptoAssetUnderlyingIndicatorOverriddenAsBoolean(_cryptoAssetUnderlyingIndicator);
		}
		
		@RosettaAttribute(value="level", isRequired=true)
		@RuneAttribute(value="level", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLevelOverriddenAsReportLevelEnum(ReportLevelEnum _level) {
			this.level = _level == null ? null : _level;
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLevel(ReportLevelEnum _level) {
			return setLevelOverriddenAsReportLevelEnum(_level);
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventType(EventTypeEnum _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@RosettaAttribute("executionAgentCounterparty1")
		@RuneAttribute("executionAgentCounterparty1")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
			this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
			return this;
		}
		
		@RosettaAttribute("executionAgentCounterparty2")
		@RuneAttribute("executionAgentCounterparty2")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty2(String _executionAgentCounterparty2) {
			this.executionAgentCounterparty2 = _executionAgentCounterparty2 == null ? null : _executionAgentCounterparty2;
			return this;
		}
		
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
			this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
			return this;
		}
		
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setContractTypeOverriddenAsCommonContractType(CommonContractType _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setContractType(CommonContractType _contractType) {
			return setContractTypeOverriddenAsCommonContractType(_contractType);
		}
		
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setAssetClassOverriddenAsCommonAssetClass(CommonAssetClass _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
			return setAssetClassOverriddenAsCommonAssetClass(_assetClass);
		}
		
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@RosettaAttribute("direction1")
		@RuneAttribute("direction1")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirection1(Direction1Enum _direction1) {
			this.direction1 = _direction1 == null ? null : _direction1;
			return this;
		}
		
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
			this.barrier = _barrier == null ? null : _barrier.toBuilder();
			return this;
		}
		
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
			return this;
		}
		
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@RosettaAttribute(value="deliveryType", isRequired=true)
		@RuneAttribute(value="deliveryType", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryTypeOverriddenAsDeliveryTypeEnum(DeliveryTypeEnum _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
			return setDeliveryTypeOverriddenAsDeliveryTypeEnum(_deliveryType);
		}
		
		@RosettaAttribute("countryOfTheCounterparty2")
		@RuneAttribute("countryOfTheCounterparty2")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
			this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
			return this;
		}
		
		@RosettaAttribute("bookingLocation")
		@RuneAttribute("bookingLocation")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
			this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
			return this;
		}
		
		@RosettaAttribute("traderLocation")
		@RuneAttribute("traderLocation")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
			this.traderLocation = _traderLocation == null ? null : _traderLocation;
			return this;
		}
		
		@RosettaAttribute("tradingCapacity")
		@RuneAttribute("tradingCapacity")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
			this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
			return this;
		}
		
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
			this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
			return this;
		}
		
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@RosettaAttribute("series")
		@RuneAttribute("series")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSeries(Integer _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum _clearingAccountOrigin) {
			this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
			return this;
		}
		
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
			this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
			return this;
		}
		
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
			this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
			return this;
		}
		
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
			this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
			return this;
		}
		
		@RosettaAttribute("priorUSI")
		@RuneAttribute("priorUSI")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPriorUSI(String _priorUSI) {
			this.priorUSI = _priorUSI == null ? null : _priorUSI;
			return this;
		}
		
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
			this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
			this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
			return this;
		}
		
		@RosettaAttribute(value="masterAgreementType", isRequired=true)
		@RuneAttribute(value="masterAgreementType", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMasterAgreementTypeOverriddenAsMasterAgreementEnum(MasterAgreementEnum _masterAgreementType) {
			this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMasterAgreementType(MasterAgreementEnum _masterAgreementType) {
			return setMasterAgreementTypeOverriddenAsMasterAgreementEnum(_masterAgreementType);
		}
		
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
			this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
			return this;
		}
		
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
			this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
			return this;
		}
		
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
			this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
			return this;
		}
		
		@RosettaAttribute("packageIndicator")
		@RuneAttribute("packageIndicator")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPackageIndicator(Boolean _packageIndicator) {
			this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
			return this;
		}
		
		@RosettaAttribute("brokerID")
		@RuneAttribute("brokerID")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBrokerID(String _brokerID) {
			this.brokerID = _brokerID == null ? null : _brokerID;
			return this;
		}
		
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
			this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
			return this;
		}
		
		@RosettaAttribute("seriesVersion")
		@RuneAttribute("seriesVersion")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSeriesVersion(Integer _seriesVersion) {
			this.seriesVersion = _seriesVersion == null ? null : _seriesVersion;
			return this;
		}
		
		@RosettaAttribute("secondaryTransactionIdentifier")
		@RuneAttribute("secondaryTransactionIdentifier")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSecondaryTransactionIdentifier(String _secondaryTransactionIdentifier) {
			this.secondaryTransactionIdentifier = _secondaryTransactionIdentifier == null ? null : _secondaryTransactionIdentifier;
			return this;
		}
		
		@RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
		@RuneAttribute(value="natureOfCounterparty1", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum(NatureOfCounterpartyEnum _natureOfCounterparty1) {
			this.natureOfCounterparty1 = _natureOfCounterparty1 == null ? null : _natureOfCounterparty1;
			return this;
		}
		
		@RosettaIgnore
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum _natureOfCounterparty1) {
			return setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum(_natureOfCounterparty1);
		}
		
		@RosettaAttribute("natureOfCounterparty2")
		@RuneAttribute("natureOfCounterparty2")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum _natureOfCounterparty2) {
			this.natureOfCounterparty2 = _natureOfCounterparty2 == null ? null : _natureOfCounterparty2;
			return this;
		}
		
		@RosettaAttribute("swapLinkID")
		@RuneAttribute("swapLinkID")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSwapLinkID(String _swapLinkID) {
			this.swapLinkID = _swapLinkID == null ? null : _swapLinkID;
			return this;
		}
		
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1) {
			if (_clearingExceptionsAndExemptionsCounterparty1 != null) {
				this.clearingExceptionsAndExemptionsCounterparty1.add(_clearingExceptionsAndExemptionsCounterparty1);
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1, int idx) {
			getIndex(this.clearingExceptionsAndExemptionsCounterparty1, idx, () -> _clearingExceptionsAndExemptionsCounterparty1);
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
			if (clearingExceptionsAndExemptionsCounterparty1s != null) {
				for (final ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty1s) {
					this.clearingExceptionsAndExemptionsCounterparty1.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
			if (clearingExceptionsAndExemptionsCounterparty1s == null) {
				this.clearingExceptionsAndExemptionsCounterparty1 = new ArrayList<>();
			} else {
				this.clearingExceptionsAndExemptionsCounterparty1 = clearingExceptionsAndExemptionsCounterparty1s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2) {
			if (_clearingExceptionsAndExemptionsCounterparty2 != null) {
				this.clearingExceptionsAndExemptionsCounterparty2.add(_clearingExceptionsAndExemptionsCounterparty2);
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2, int idx) {
			getIndex(this.clearingExceptionsAndExemptionsCounterparty2, idx, () -> _clearingExceptionsAndExemptionsCounterparty2);
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
			if (clearingExceptionsAndExemptionsCounterparty2s != null) {
				for (final ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty2s) {
					this.clearingExceptionsAndExemptionsCounterparty2.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
			if (clearingExceptionsAndExemptionsCounterparty2s == null) {
				this.clearingExceptionsAndExemptionsCounterparty2 = new ArrayList<>();
			} else {
				this.clearingExceptionsAndExemptionsCounterparty2 = clearingExceptionsAndExemptionsCounterparty2s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setBaseProduct(String _baseProduct) {
			this.baseProduct = _baseProduct == null ? null : _baseProduct;
			return this;
		}
		
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setSubProduct(String _subProduct) {
			this.subProduct = _subProduct == null ? null : _subProduct;
			return this;
		}
		
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
			this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
			return this;
		}
		
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIntragroup(Boolean _intragroup) {
			this.intragroup = _intragroup == null ? null : _intragroup;
			return this;
		}
		
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReferenceEntity(String _referenceEntity) {
			this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
			return this;
		}
		
		@RosettaAttribute("counterparty2IdentifierSource")
		@RuneAttribute("counterparty2IdentifierSource")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum _counterparty2IdentifierSource) {
			this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
			return this;
		}
		
		@RosettaAttribute("customBasketIndicator")
		@RuneAttribute("customBasketIndicator")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
			this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
			return this;
		}
		
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
			this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
			return this;
		}
		
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum _underlyingIdentificationType) {
			this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
			return this;
		}
		
		@RosettaAttribute("corporateSectorOfTheCounterparty1")
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1) {
			if (_corporateSectorOfTheCounterparty1 != null) {
				this.corporateSectorOfTheCounterparty1.add(_corporateSectorOfTheCounterparty1);
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1, int idx) {
			getIndex(this.corporateSectorOfTheCounterparty1, idx, () -> _corporateSectorOfTheCounterparty1);
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
			if (corporateSectorOfTheCounterparty1s != null) {
				for (final String toAdd : corporateSectorOfTheCounterparty1s) {
					this.corporateSectorOfTheCounterparty1.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
			if (corporateSectorOfTheCounterparty1s == null) {
				this.corporateSectorOfTheCounterparty1 = new ArrayList<>();
			} else {
				this.corporateSectorOfTheCounterparty1 = corporateSectorOfTheCounterparty1s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("corporateSectorOfTheCounterparty2")
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2) {
			if (_corporateSectorOfTheCounterparty2 != null) {
				this.corporateSectorOfTheCounterparty2.add(_corporateSectorOfTheCounterparty2);
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2, int idx) {
			getIndex(this.corporateSectorOfTheCounterparty2, idx, () -> _corporateSectorOfTheCounterparty2);
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
			if (corporateSectorOfTheCounterparty2s != null) {
				for (final String toAdd : corporateSectorOfTheCounterparty2s) {
					this.corporateSectorOfTheCounterparty2.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
			if (corporateSectorOfTheCounterparty2s == null) {
				this.corporateSectorOfTheCounterparty2 = new ArrayList<>();
			} else {
				this.corporateSectorOfTheCounterparty2 = corporateSectorOfTheCounterparty2s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setNonReportable(NonReportable _nonReportable) {
			this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
			return this;
		}
		
		@RosettaAttribute("clearingThresholdOfCounterparty1")
		@RuneAttribute("clearingThresholdOfCounterparty1")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean _clearingThresholdOfCounterparty1) {
			this.clearingThresholdOfCounterparty1 = _clearingThresholdOfCounterparty1 == null ? null : _clearingThresholdOfCounterparty1;
			return this;
		}
		
		@RosettaAttribute("clearingThresholdOfCounterparty2")
		@RuneAttribute("clearingThresholdOfCounterparty2")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean _clearingThresholdOfCounterparty2) {
			this.clearingThresholdOfCounterparty2 = _clearingThresholdOfCounterparty2 == null ? null : _clearingThresholdOfCounterparty2;
			return this;
		}
		
		@RosettaAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		@RuneAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean _reportingObligationOfTheCounterparty2) {
			this.reportingObligationOfTheCounterparty2 = _reportingObligationOfTheCounterparty2 == null ? null : _reportingObligationOfTheCounterparty2;
			return this;
		}
		
		@RosettaAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@RuneAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean _directlyLinkedToCommercialActivityOrTreasuryFinancing) {
			this.directlyLinkedToCommercialActivityOrTreasuryFinancing = _directlyLinkedToCommercialActivityOrTreasuryFinancing == null ? null : _directlyLinkedToCommercialActivityOrTreasuryFinancing;
			return this;
		}
		
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setReportTrackingNumber(String _reportTrackingNumber) {
			this.reportTrackingNumber = _reportTrackingNumber == null ? null : _reportTrackingNumber;
			return this;
		}
		
		@RosettaAttribute("ptrrId")
		@RuneAttribute("ptrrId")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrrId(String _ptrrId) {
			this.ptrrId = _ptrrId == null ? null : _ptrrId;
			return this;
		}
		
		@RosettaAttribute("isin")
		@RuneAttribute("isin")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIsin(String _isin) {
			this.isin = _isin == null ? null : _isin;
			return this;
		}
		
		@RosettaAttribute(value="productClassification", isRequired=true)
		@RuneAttribute(value="productClassification", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setProductClassification(String _productClassification) {
			this.productClassification = _productClassification == null ? null : _productClassification;
			return this;
		}
		
		@RosettaAttribute("indicatorOfTheUnderlyingIndex")
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum _indicatorOfTheUnderlyingIndex) {
			if (_indicatorOfTheUnderlyingIndex != null) {
				this.indicatorOfTheUnderlyingIndex.add(_indicatorOfTheUnderlyingIndex);
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum _indicatorOfTheUnderlyingIndex, int idx) {
			getIndex(this.indicatorOfTheUnderlyingIndex, idx, () -> _indicatorOfTheUnderlyingIndex);
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndexs) {
			if (indicatorOfTheUnderlyingIndexs != null) {
				for (final IndexEnum toAdd : indicatorOfTheUnderlyingIndexs) {
					this.indicatorOfTheUnderlyingIndex.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndexs) {
			if (indicatorOfTheUnderlyingIndexs == null) {
				this.indicatorOfTheUnderlyingIndex = new ArrayList<>();
			} else {
				this.indicatorOfTheUnderlyingIndex = indicatorOfTheUnderlyingIndexs.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("clearingObligation")
		@RuneAttribute("clearingObligation")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setClearingObligation(ClearingObligationEnum _clearingObligation) {
			this.clearingObligation = _clearingObligation == null ? null : _clearingObligation;
			return this;
		}
		
		@RosettaAttribute("otherMasterAgreementType")
		@RuneAttribute("otherMasterAgreementType")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setOtherMasterAgreementType(String _otherMasterAgreementType) {
			this.otherMasterAgreementType = _otherMasterAgreementType == null ? null : _otherMasterAgreementType;
			return this;
		}
		
		@RosettaAttribute("ptrr")
		@RuneAttribute("ptrr")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrr(Boolean _ptrr) {
			this.ptrr = _ptrr == null ? null : _ptrr;
			return this;
		}
		
		@RosettaAttribute("typeOfPTRRTechnique")
		@RuneAttribute("typeOfPTRRTechnique")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTypeOfPTRRTechnique(RiskReductionTechniqueEnum _typeOfPTRRTechnique) {
			this.typeOfPTRRTechnique = _typeOfPTRRTechnique == null ? null : _typeOfPTRRTechnique;
			return this;
		}
		
		@RosettaAttribute("ptrrServiceProvider")
		@RuneAttribute("ptrrServiceProvider")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setPtrrServiceProvider(String _ptrrServiceProvider) {
			this.ptrrServiceProvider = _ptrrServiceProvider == null ? null : _ptrrServiceProvider;
			return this;
		}
		
		@RosettaAttribute("venueOfExecution")
		@RuneAttribute("venueOfExecution")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setVenueOfExecution(String _venueOfExecution) {
			this.venueOfExecution = _venueOfExecution == null ? null : _venueOfExecution;
			return this;
		}
		
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal _forwardExchangeRate) {
			this.forwardExchangeRate = _forwardExchangeRate == null ? null : _forwardExchangeRate;
			return this;
		}
		
		@RosettaAttribute("deliveryPoint")
		@RuneAttribute("deliveryPoint")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint) {
			if (_deliveryPoint != null) {
				this.deliveryPoint.add(_deliveryPoint);
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint, int idx) {
			getIndex(this.deliveryPoint, idx, () -> _deliveryPoint);
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryPoint(List<String> deliveryPoints) {
			if (deliveryPoints != null) {
				for (final String toAdd : deliveryPoints) {
					this.deliveryPoint.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("deliveryPoint")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryPoint(List<String> deliveryPoints) {
			if (deliveryPoints == null) {
				this.deliveryPoint = new ArrayList<>();
			} else {
				this.deliveryPoint = deliveryPoints.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("interconnectionPoint")
		@RuneAttribute("interconnectionPoint")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setInterconnectionPoint(String _interconnectionPoint) {
			this.interconnectionPoint = _interconnectionPoint == null ? null : _interconnectionPoint;
			return this;
		}
		
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code _loadType) {
			this.loadType = _loadType == null ? null : _loadType;
			return this;
		}
		
		@RosettaAttribute("deliveryReport")
		@RuneAttribute("deliveryReport")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery _deliveryReport) {
			if (_deliveryReport != null) {
				this.deliveryReport.add(_deliveryReport.toBuilder());
			}
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery _deliveryReport, int idx) {
			getIndex(this.deliveryReport, idx, () -> _deliveryReport.toBuilder());
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder addDeliveryReport(List<? extends ReportableDelivery> deliveryReports) {
			if (deliveryReports != null) {
				for (final ReportableDelivery toAdd : deliveryReports) {
					this.deliveryReport.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("deliveryReport")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setDeliveryReport(List<? extends ReportableDelivery> deliveryReports) {
			if (deliveryReports == null) {
				this.deliveryReport = new ArrayList<>();
			} else {
				this.deliveryReport = deliveryReports.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setTranche(Boolean _tranche) {
			this.tranche = _tranche == null ? null : _tranche;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioCode")
		@RuneAttribute("collateralPortfolioCode")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
			this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder setEventDate(Date _eventDate) {
			this.eventDate = _eventDate == null ? null : _eventDate;
			return this;
		}
		
		@Override
		public ESMAEMIRTransactionReport build() {
			return new ESMAEMIRTransactionReport.ESMAEMIRTransactionReportImpl(this);
		}
		
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder prune() {
			super.prune();
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getNatureOfCounterparty1()!=null) return true;
			if (getCounterparty2IdentifierType()!=null) return true;
			if (getContractType()!=null) return true;
			if (getAssetClass()!=null) return true;
			if (getCryptoAssetUnderlyingIndicator()!=null) return true;
			if (getCleared()!=null) return true;
			if (getMasterAgreementType()!=null) return true;
			if (getExecutionTimestamp()!=null) return true;
			if (getEffectiveDate()!=null) return true;
			if (getDeliveryType()!=null) return true;
			if (getLevel()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder o = (ESMAEMIRTransactionReport.ESMAEMIRTransactionReportBuilder) other;
			
			
			merger.mergeBasic(getNatureOfCounterparty1(), o.getNatureOfCounterparty1(), this::setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum);
			merger.mergeBasic(getCounterparty2IdentifierType(), o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierTypeOverriddenAsBoolean);
			merger.mergeBasic(getContractType(), o.getContractType(), this::setContractTypeOverriddenAsCommonContractType);
			merger.mergeBasic(getAssetClass(), o.getAssetClass(), this::setAssetClassOverriddenAsCommonAssetClass);
			merger.mergeBasic(getCryptoAssetUnderlyingIndicator(), o.getCryptoAssetUnderlyingIndicator(), this::setCryptoAssetUnderlyingIndicatorOverriddenAsBoolean);
			merger.mergeBasic(getCleared(), o.getCleared(), this::setClearedOverriddenAsClearedEnum);
			merger.mergeBasic(getMasterAgreementType(), o.getMasterAgreementType(), this::setMasterAgreementTypeOverriddenAsMasterAgreementEnum);
			merger.mergeBasic(getExecutionTimestamp(), o.getExecutionTimestamp(), this::setExecutionTimestampOverriddenAsZonedDateTime);
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDateOverriddenAsDate);
			merger.mergeBasic(getDeliveryType(), o.getDeliveryType(), this::setDeliveryTypeOverriddenAsDeliveryTypeEnum);
			merger.mergeBasic(getLevel(), o.getLevel(), this::setLevelOverriddenAsReportLevelEnum);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			ESMAEMIRTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(natureOfCounterparty1, _that.getNatureOfCounterparty1())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(cryptoAssetUnderlyingIndicator, _that.getCryptoAssetUnderlyingIndicator())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(masterAgreementType, _that.getMasterAgreementType())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(deliveryType, _that.getDeliveryType())) return false;
			if (!Objects.equals(level, _that.getLevel())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (natureOfCounterparty1 != null ? natureOfCounterparty1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (cryptoAssetUnderlyingIndicator != null ? cryptoAssetUnderlyingIndicator.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (masterAgreementType != null ? masterAgreementType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (deliveryType != null ? deliveryType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (level != null ? level.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ESMAEMIRTransactionReportBuilder {" +
				"natureOfCounterparty1=" + this.natureOfCounterparty1 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"contractType=" + this.contractType + ", " +
				"assetClass=" + this.assetClass + ", " +
				"cryptoAssetUnderlyingIndicator=" + this.cryptoAssetUnderlyingIndicator + ", " +
				"cleared=" + this.cleared + ", " +
				"masterAgreementType=" + this.masterAgreementType + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"deliveryType=" + this.deliveryType + ", " +
				"level=" + this.level +
			'}' + " " + super.toString();
		}
	}
}
