package drr.regulation.fca.ukemir.refit.margin.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.margin.CollateralReport;
import drr.regulation.fca.ukemir.refit.margin.FCAUKEMIRMarginReport;
import drr.standards.iso.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.17.1
 */
@RosettaDataRule("FCAUKEMIRMarginReportUKEMIR_VR_3012_01")
@ImplementedBy(FCAUKEMIRMarginReportUKEMIR_VR_3012_01.Default.class)
public interface FCAUKEMIRMarginReportUKEMIR_VR_3012_01 extends Validator<FCAUKEMIRMarginReport> {
	
	String NAME = "FCAUKEMIRMarginReportUKEMIR_VR_3012_01";
	String DEFINITION = "if [CollateralisationType3Code__1 -> OWC1, CollateralisationType3Code__1 -> OWP1, CollateralisationType3Code__1 -> FLCL] any = collateral -> collateralisationCategory then collateral -> initialMarginPostedByTheCounterparty1PreHaircut exists";
	
	class Default implements FCAUKEMIRMarginReportUKEMIR_VR_3012_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRMarginReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRMarginReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRMarginReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			try {
				if (areEqual(MapperC.<CollateralisationType3Code__1>of(MapperS.of(CollateralisationType3Code__1.OWC1), MapperS.of(CollateralisationType3Code__1.OWP1), MapperS.of(CollateralisationType3Code__1.FLCL)), MapperS.of(fCAUKEMIRMarginReport).<CollateralReport>map("getCollateral", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getCollateral()).<CollateralisationType3Code__1>map("getCollateralisationCategory", collateralReport -> collateralReport.getCollateralisationCategory()), CardinalityOperator.Any).getOrDefault(false)) {
					return exists(MapperS.of(fCAUKEMIRMarginReport).<CollateralReport>map("getCollateral", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getCollateral()).<BigDecimal>map("getInitialMarginPostedByTheCounterparty1PreHaircut", collateralReport -> collateralReport.getInitialMarginPostedByTheCounterparty1PreHaircut()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRMarginReportUKEMIR_VR_3012_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			return Collections.emptyList();
		}
	}
}
