package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNameOfTheFloatingRateOfLeg1;
import drr.regulation.common.functions.IsAllowableAction;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg1NotationEnumRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg1Rule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SpreadOfLeg1NotationRule.SpreadOfLeg1NotationRuleDefault.class)
public abstract class SpreadOfLeg1NotationRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetNameOfTheFloatingRateOfLeg1 getNameOfTheFloatingRateOfLeg1;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected SpreadLeg1NotationEnumRule spreadLeg1NotationEnumRule;
	@Inject protected SpreadLeg1Rule spreadLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class SpreadOfLeg1NotationRuleDefault extends SpreadOfLeg1NotationRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					final PriceSchedule priceSchedule = spreadLeg1Rule.evaluate(item.get());
					if ((priceSchedule == null ? exists(MapperS.<ReferenceWithMetaPriceSchedule>ofNull()).getOrDefault(false) : exists(MapperS.of(ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build())).getOrDefault(false))) {
						return MapperS.of(spreadLeg1NotationEnumRule.evaluate(item.get()));
					}
					if (exists(MapperS.of(getNameOfTheFloatingRateOfLeg1.evaluate(item.get()))).getOrDefault(false)) {
						return MapperS.of(PriceNotationEnum.BASIS);
					}
					return MapperS.<PriceNotationEnum>ofNull();
				}).get();
			
			return output;
		}
	}
}
