package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.17.1
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2001_04")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2001_04.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2001_04 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2001_04";
	String DEFINITION = "if uniqueTransactionIdentifier exists then [reportTrackingNumber, subsequentPositionUTI, priorUTI, priorUTIProprietary] all <> uniqueTransactionIdentifier else [reportTrackingNumber, subsequentPositionUTI, priorUTI, priorUTIProprietary] all <> uniqueTransactionIdentifierProprietary";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2001_04 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				if (exists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getUniqueTransactionIdentifier", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getUniqueTransactionIdentifier())).getOrDefault(false)) {
					return notEqual(MapperC.<String>of(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getReportTrackingNumber", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getReportTrackingNumber()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getSubsequentPositionUTI", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getSubsequentPositionUTI()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getPriorUTI", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPriorUTI()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getPriorUTIProprietary", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPriorUTIProprietary())), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getUniqueTransactionIdentifier", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getUniqueTransactionIdentifier()), CardinalityOperator.All);
				}
				return notEqual(MapperC.<String>of(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getReportTrackingNumber", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getReportTrackingNumber()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getSubsequentPositionUTI", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getSubsequentPositionUTI()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getPriorUTI", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPriorUTI()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getPriorUTIProprietary", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPriorUTIProprietary())), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getUniqueTransactionIdentifierProprietary", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getUniqueTransactionIdentifierProprietary()), CardinalityOperator.All);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2001_04 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
