package drr.regulation.hkma.rewrite.trade.functions;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.BusinessEvent;
import cdm.event.common.Trade;
import cdm.event.common.TradeIdentifier;
import cdm.event.qualification.functions.Qualify_Compression;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.TradeForEvent;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Extract_PriorUTIPropietary.Extract_PriorUTIPropietaryDefault.class)
public abstract class Extract_PriorUTIPropietary implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected Qualify_Compression qualify_Compression;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @return tradeIdentifier 
	*/
	public TradeIdentifier evaluate(ReportableEvent reportableEvent) {
		TradeIdentifier.TradeIdentifierBuilder tradeIdentifierBuilder = doEvaluate(reportableEvent);
		
		final TradeIdentifier tradeIdentifier;
		if (tradeIdentifierBuilder == null) {
			tradeIdentifier = null;
		} else {
			tradeIdentifier = tradeIdentifierBuilder.build();
			objectValidator.validate(TradeIdentifier.class, tradeIdentifier);
		}
		
		return tradeIdentifier;
	}

	protected abstract TradeIdentifier.TradeIdentifierBuilder doEvaluate(ReportableEvent reportableEvent);

	public static class Extract_PriorUTIPropietaryDefault extends Extract_PriorUTIPropietary {
		@Override
		protected TradeIdentifier.TradeIdentifierBuilder doEvaluate(ReportableEvent reportableEvent) {
			TradeIdentifier.TradeIdentifierBuilder tradeIdentifier = TradeIdentifier.builder();
			return assignOutput(tradeIdentifier, reportableEvent);
		}
		
		protected TradeIdentifier.TradeIdentifierBuilder assignOutput(TradeIdentifier.TradeIdentifierBuilder tradeIdentifier, ReportableEvent reportableEvent) {
			final MapperS<ReportableEvent> thenArg = MapperS.of(reportableEvent);
			tradeIdentifier = toBuilder(thenArg
				.mapSingleToItem(item -> {
					if (notEqual(MapperS.of(tradeForEvent.evaluate(item.get())).<TradeIdentifier>mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()).<AssignedIdentifier>mapC("getAssignedIdentifier", _tradeIdentifier -> _tradeIdentifier.getAssignedIdentifier()).<FieldWithMetaString>map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), MapperS.of(beforeTradeForEvent.evaluate(item.get())).<TradeIdentifier>mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()).<AssignedIdentifier>mapC("getAssignedIdentifier", _tradeIdentifier -> _tradeIdentifier.getAssignedIdentifier()).<FieldWithMetaString>map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), CardinalityOperator.Any).and(areEqual(MapperS.of(qualify_Compression.evaluate(item.<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
						final MapperS<Trade> thenArg0 = MapperS.of(beforeTradeForEvent.evaluate(item.get()));
						final MapperC<TradeIdentifier> thenArg1 = thenArg0
							.mapSingleToList(_item -> _item.<TradeIdentifier>mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()));
						final MapperC<TradeIdentifier> thenArg2 = thenArg1
							.filterItemNullSafe(_item -> areEqual(_item.<TradeIdentifierTypeEnum>map("getIdentifierType", _tradeIdentifier -> _tradeIdentifier.getIdentifierType()), MapperS.of(TradeIdentifierTypeEnum.UNIQUE_SWAP_IDENTIFIER), CardinalityOperator.All).or(notExists(_item.<TradeIdentifierTypeEnum>map("getIdentifierType", _tradeIdentifier -> _tradeIdentifier.getIdentifierType()))).get());
						final MapperC<TradeIdentifier> thenArg3 = distinct(thenArg2);
						return MapperS.of(thenArg3.get());
					}
					return MapperS.<TradeIdentifier>ofNull();
				}).get());
			
			return Optional.ofNullable(tradeIdentifier)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
