package drr.regulation.hkma.rewrite.trade.functions;

import cdm.base.staticdata.party.LegalEntity;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.ReferenceInformation;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReferenceEntityFormatEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.IsCreditDefaultSwap;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.common.util.functions.StringContains;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Extract_ReferenceEntityFormat.Extract_ReferenceEntityFormatDefault.class)
public abstract class Extract_ReferenceEntityFormat implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected StringContains stringContains;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param reportableEvent 
	* @return referenceEntityFormat 
	*/
	public ReferenceEntityFormatEnum evaluate(ReportableEvent reportableEvent) {
		ReferenceEntityFormatEnum referenceEntityFormat = doEvaluate(reportableEvent);
		
		return referenceEntityFormat;
	}

	protected abstract ReferenceEntityFormatEnum doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Product> product(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends LegalEntity> referenceEntityProduct(ReportableEvent reportableEvent);

	public static class Extract_ReferenceEntityFormatDefault extends Extract_ReferenceEntityFormat {
		@Override
		protected ReferenceEntityFormatEnum doEvaluate(ReportableEvent reportableEvent) {
			ReferenceEntityFormatEnum referenceEntityFormat = null;
			return assignOutput(referenceEntityFormat, reportableEvent);
		}
		
		protected ReferenceEntityFormatEnum assignOutput(ReferenceEntityFormatEnum referenceEntityFormat, ReportableEvent reportableEvent) {
			final MapperC<FieldWithMetaString> thenArg0 = referenceEntityProduct(reportableEvent).<FieldWithMetaString>mapC("getEntityId", legalEntity -> legalEntity.getEntityId());
			final MapperC<FieldWithMetaString> thenArg1 = thenArg0
				.filterItemNullSafe(item -> ComparisonResult.of(MapperS.of(stringContains.evaluate(item.map("getMeta", a->a.getMeta()).map("getScheme", a->a.getScheme()).get(), "http://www.fpml.org/coding-scheme/external/iso17442"))).or(ComparisonResult.of(MapperS.of(stringContains.evaluate(item.map("getMeta", a->a.getMeta()).map("getScheme", a->a.getScheme()).get(), "http://www.fpml.org/coding-scheme/external/iso3166")))).get());
			final MapperS<FieldWithMetaString> thenArg2 = thenArg1
				.first();
			referenceEntityFormat = thenArg2
				.mapSingleToItem(item -> {
					if (areEqual(item.map("getMeta", a->a.getMeta()).map("getScheme", a->a.getScheme()), MapperS.of("http://www.fpml.org/coding-scheme/external/iso17442"), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(ReferenceEntityFormatEnum.LEI);
					}
					if (areEqual(item.map("getMeta", a->a.getMeta()).map("getScheme", a->a.getScheme()), MapperS.of("http://www.fpml.org/coding-scheme/external/iso3166"), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(ReferenceEntityFormatEnum.COUNTRY);
					}
					return MapperS.<ReferenceEntityFormatEnum>ofNull();
				}).get();
			
			return referenceEntityFormat;
		}
		
		@Override
		protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
			return MapperS.of(productForEvent.evaluate(reportableEvent));
		}
		
		@Override
		protected MapperS<? extends LegalEntity> referenceEntityProduct(ReportableEvent reportableEvent) {
			final Boolean boolean0 = isCreditSwaption.evaluate(product(reportableEvent).get());
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<LegalEntity>map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity());
			}
			final Boolean boolean1 = isCreditDefaultSwap.evaluate(product(reportableEvent).get());
			if ((boolean1 == null ? false : boolean1)) {
				return product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<LegalEntity>map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity());
			}
			return MapperS.<LegalEntity>ofNull();
		}
	}
}
