package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.qualification.functions.Qualify_BaseProduct_IRSwap;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.GetIndexIndicatorFromFloatingRate;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsFRA;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.standards.iso.IndexEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(UnderlyingIndexIndicatorRule.UnderlyingIndexIndicatorRuleDefault.class)
public abstract class UnderlyingIndexIndicatorRule implements ReportFunction<TransactionReportInstruction, IndexEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetIndexIndicatorFromFloatingRate getIndexIndicatorFromFloatingRate;
	@Inject protected IsAllowableActionForJFSA isAllowableActionForJFSA;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsFRA isFRA;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_BaseProduct_IRSwap qualify_BaseProduct_IRSwap;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public IndexEnum evaluate(TransactionReportInstruction input) {
		IndexEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract IndexEnum doEvaluate(TransactionReportInstruction input);

	public static class UnderlyingIndexIndicatorRuleDefault extends UnderlyingIndexIndicatorRule {
		@Override
		protected IndexEnum doEvaluate(TransactionReportInstruction input) {
			IndexEnum output = null;
			return assignOutput(output, input);
		}
		
		protected IndexEnum assignOutput(IndexEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForJFSA.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					if (ComparisonResult.of(MapperS.of(isCreditSwaption.evaluate(productForEvent.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isIRSwaption.evaluate(productForEvent.evaluate(item.get()))))).getOrDefault(false)) {
						return MapperS.of(underlierForProduct.evaluate(productForEvent.evaluate(item.get())));
					}
					return MapperS.of(productForEvent.evaluate(item.get()));
				});
			final MapperC<String> thenArg2 = thenArg1
				.mapSingleToList(item -> {
					if (exists(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).getOrDefault(false)) {
						return MapperC.of(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName()).<String>map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()));
					}
					if (exists(MapperS.of(underlierForProduct.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).getOrDefault(false)) {
						return MapperC.of(MapperS.of(underlierForProduct.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName()).<String>map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()));
					}
					if (exists(MapperS.of(underlierForProduct.evaluate(item.get())).<Index>map("getIndex", product -> product.getIndex())).and(areEqual(MapperS.of(underlierForProduct.evaluate(item.get())).<Index>map("getIndex", product -> product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.Any)).getOrDefault(false)) {
						final MapperC<ReferenceWithMetaProductIdentifier> _thenArg0 = MapperS.of(underlierForProduct.evaluate(item.get())).<Index>map("getIndex", product -> product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
						final MapperC<ReferenceWithMetaProductIdentifier> _thenArg1 = _thenArg0
							.filterItemNullSafe(_item -> areEqual(_item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
						return _thenArg1
							.mapItem(_item -> _item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue());
					}
					if (exists(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Index>map("getIndex", product -> product.getIndex())).getOrDefault(false)) {
						final MapperC<ReferenceWithMetaProductIdentifier> _thenArg2 = item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Index>map("getIndex", product -> product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
						final MapperC<ReferenceWithMetaProductIdentifier> _thenArg3 = _thenArg2
							.filterItemNullSafe(_item -> areEqual(_item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
						return _thenArg3
							.mapItem(_item -> _item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue());
					}
					if (exists(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Index>map("getIndex", product -> product.getIndex())).getOrDefault(false)) {
						final MapperC<ReferenceWithMetaProductIdentifier> thenArg4 = item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Index>map("getIndex", product -> product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
						final MapperC<ReferenceWithMetaProductIdentifier> thenArg5 = thenArg4
							.filterItemNullSafe(_item -> areEqual(_item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
						return thenArg5
							.mapItem(_item -> _item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue());
					}
					final Boolean boolean0 = isFRA.evaluate(item.get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperC.of(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex())
							.first().<FloatingRateIndexEnum>map("Type coercion", fieldWithMetaFloatingRateIndexEnum0 -> fieldWithMetaFloatingRateIndexEnum0 == null ? null : fieldWithMetaFloatingRateIndexEnum0.getValue()).map("to-string", FloatingRateIndexEnum::toDisplayString));
					}
					final Boolean boolean1 = qualify_BaseProduct_IRSwap.evaluate(economicTermsForProduct.evaluate(item.get()));
					if ((boolean1 == null ? false : boolean1)) {
						return MapperC.of(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex())
							.first().<FloatingRateIndexEnum>map("Type coercion", fieldWithMetaFloatingRateIndexEnum1 -> fieldWithMetaFloatingRateIndexEnum1 == null ? null : fieldWithMetaFloatingRateIndexEnum1.getValue()).map("to-string", FloatingRateIndexEnum::toDisplayString));
					}
					return MapperC.<String>ofNull();
				});
			final MapperC<IndexEnum> thenArg3 = thenArg2
				.mapItem(item -> MapperS.of(getIndexIndicatorFromFloatingRate.evaluate(item.get())));
			output = MapperS.of(distinct(thenArg3).get()).get();
			
			return output;
		}
	}
}
