package drr.regulation.mas.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.IsActionTypeCORR;
import drr.regulation.common.functions.IsActionTypeMODI;
import drr.regulation.common.functions.IsActionTypeNEWT;
import drr.regulation.common.functions.IsActionTypePOSC;
import drr.regulation.common.functions.IsActionTypePositionMODI;
import drr.regulation.common.functions.IsActionTypeREVI;
import javax.inject.Inject;


@ImplementedBy(IsAllowableActionForMAS.IsAllowableActionForMASDefault.class)
public abstract class IsAllowableActionForMAS implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsActionTypeCORR isActionTypeCORR;
	@Inject protected IsActionTypeMODI isActionTypeMODI;
	@Inject protected IsActionTypeNEWT isActionTypeNEWT;
	@Inject protected IsActionTypePOSC isActionTypePOSC;
	@Inject protected IsActionTypePositionMODI isActionTypePositionMODI;
	@Inject protected IsActionTypeREVI isActionTypeREVI;

	/**
	* @param reportableEvent 
	* @return isAllowableAction 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isAllowableAction = doEvaluate(reportableEvent);
		
		return isAllowableAction;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	public static class IsAllowableActionForMASDefault extends IsAllowableActionForMAS {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isAllowableAction = null;
			return assignOutput(isAllowableAction, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isAllowableAction, ReportableEvent reportableEvent) {
			isAllowableAction = ComparisonResult.of(MapperS.of(isActionTypeNEWT.evaluate(reportableEvent))).or(ComparisonResult.of(MapperS.of(isActionTypeMODI.evaluate(reportableEvent)))).or(ComparisonResult.of(MapperS.of(isActionTypePositionMODI.evaluate(reportableEvent)))).or(ComparisonResult.of(MapperS.of(isActionTypeCORR.evaluate(reportableEvent)))).or(ComparisonResult.of(MapperS.of(isActionTypeREVI.evaluate(reportableEvent)))).or(ComparisonResult.of(MapperS.of(isActionTypePOSC.evaluate(reportableEvent)))).get();
			
			return isAllowableAction;
		}
	}
}
