package drr.regulation.mas.rewrite.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.mas.rewrite.valuation.meta.MASValuationReportMeta;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.17.1
 */
@RosettaDataType(value="MASValuationReport", builder=MASValuationReport.MASValuationReportBuilderImpl.class, version="6.17.1")
@RuneDataType(value="MASValuationReport", model="drr", builder=MASValuationReport.MASValuationReportBuilderImpl.class, version="6.17.1")
public interface MASValuationReport extends RosettaModelObject {

	MASValuationReportMeta metaData = new MASValuationReportMeta();

	/*********************** Getter Methods  ***********************/
	String getUniqueTransactionIdentifier();
	String getUniqueTransactionIdentifierProprietary();
	String getReportingSpecifiedPerson();
	String getCounterparty1();
	String getCounterparty2();
	Boolean getCounterparty2IdentifierType();
	String getActionType();
	ZonedDateTime getReportingTimestamp();
	String getDataSubmitter();
	ZonedDateTime getValuationTimestamp();
	BigDecimal getValuationAmount();
	ISOCurrencyCodeEnum getValuationCurrency();
	ValuationType1Code getValuationMethod();
	String getTechnicalRecordId();
	String getExecutionAgentOfTheCounterparty1();
	String getExecutionAgentOfTheCounterparty2();

	/*********************** Build Methods  ***********************/
	MASValuationReport build();
	
	MASValuationReport.MASValuationReportBuilder toBuilder();
	
	static MASValuationReport.MASValuationReportBuilder builder() {
		return new MASValuationReport.MASValuationReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends MASValuationReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends MASValuationReport> getType() {
		return MASValuationReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, getReportingSpecifiedPerson(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("dataSubmitter"), String.class, getDataSubmitter(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, getExecutionAgentOfTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty2"), String.class, getExecutionAgentOfTheCounterparty2(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface MASValuationReportBuilder extends MASValuationReport, RosettaModelObjectBuilder {
		MASValuationReport.MASValuationReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		MASValuationReport.MASValuationReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		MASValuationReport.MASValuationReportBuilder setReportingSpecifiedPerson(String reportingSpecifiedPerson);
		MASValuationReport.MASValuationReportBuilder setCounterparty1(String counterparty1);
		MASValuationReport.MASValuationReportBuilder setCounterparty2(String counterparty2);
		MASValuationReport.MASValuationReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		MASValuationReport.MASValuationReportBuilder setActionType(String actionType);
		MASValuationReport.MASValuationReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		MASValuationReport.MASValuationReportBuilder setDataSubmitter(String dataSubmitter);
		MASValuationReport.MASValuationReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		MASValuationReport.MASValuationReportBuilder setValuationAmount(BigDecimal valuationAmount);
		MASValuationReport.MASValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		MASValuationReport.MASValuationReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		MASValuationReport.MASValuationReportBuilder setTechnicalRecordId(String technicalRecordId);
		MASValuationReport.MASValuationReportBuilder setExecutionAgentOfTheCounterparty1(String executionAgentOfTheCounterparty1);
		MASValuationReport.MASValuationReportBuilder setExecutionAgentOfTheCounterparty2(String executionAgentOfTheCounterparty2);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, getReportingSpecifiedPerson(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("dataSubmitter"), String.class, getDataSubmitter(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, getExecutionAgentOfTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty2"), String.class, getExecutionAgentOfTheCounterparty2(), this);
		}
		

		MASValuationReport.MASValuationReportBuilder prune();
	}

	/*********************** Immutable Implementation of MASValuationReport  ***********************/
	class MASValuationReportImpl implements MASValuationReport {
		private final String uniqueTransactionIdentifier;
		private final String uniqueTransactionIdentifierProprietary;
		private final String reportingSpecifiedPerson;
		private final String counterparty1;
		private final String counterparty2;
		private final Boolean counterparty2IdentifierType;
		private final String actionType;
		private final ZonedDateTime reportingTimestamp;
		private final String dataSubmitter;
		private final ZonedDateTime valuationTimestamp;
		private final BigDecimal valuationAmount;
		private final ISOCurrencyCodeEnum valuationCurrency;
		private final ValuationType1Code valuationMethod;
		private final String technicalRecordId;
		private final String executionAgentOfTheCounterparty1;
		private final String executionAgentOfTheCounterparty2;
		
		protected MASValuationReportImpl(MASValuationReport.MASValuationReportBuilder builder) {
			this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
			this.uniqueTransactionIdentifierProprietary = builder.getUniqueTransactionIdentifierProprietary();
			this.reportingSpecifiedPerson = builder.getReportingSpecifiedPerson();
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
			this.actionType = builder.getActionType();
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.dataSubmitter = builder.getDataSubmitter();
			this.valuationTimestamp = builder.getValuationTimestamp();
			this.valuationAmount = builder.getValuationAmount();
			this.valuationCurrency = builder.getValuationCurrency();
			this.valuationMethod = builder.getValuationMethod();
			this.technicalRecordId = builder.getTechnicalRecordId();
			this.executionAgentOfTheCounterparty1 = builder.getExecutionAgentOfTheCounterparty1();
			this.executionAgentOfTheCounterparty2 = builder.getExecutionAgentOfTheCounterparty2();
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public String getUniqueTransactionIdentifierProprietary() {
			return uniqueTransactionIdentifierProprietary;
		}
		
		@Override
		@RosettaAttribute("reportingSpecifiedPerson")
		@RuneAttribute("reportingSpecifiedPerson")
		public String getReportingSpecifiedPerson() {
			return reportingSpecifiedPerson;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="dataSubmitter", isRequired=true)
		@RuneAttribute(value="dataSubmitter", isRequired=true)
		public String getDataSubmitter() {
			return dataSubmitter;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfTheCounterparty1")
		@RuneAttribute("executionAgentOfTheCounterparty1")
		public String getExecutionAgentOfTheCounterparty1() {
			return executionAgentOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfTheCounterparty2")
		@RuneAttribute("executionAgentOfTheCounterparty2")
		public String getExecutionAgentOfTheCounterparty2() {
			return executionAgentOfTheCounterparty2;
		}
		
		@Override
		public MASValuationReport build() {
			return this;
		}
		
		@Override
		public MASValuationReport.MASValuationReportBuilder toBuilder() {
			MASValuationReport.MASValuationReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(MASValuationReport.MASValuationReportBuilder builder) {
			ofNullable(getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
			ofNullable(getUniqueTransactionIdentifierProprietary()).ifPresent(builder::setUniqueTransactionIdentifierProprietary);
			ofNullable(getReportingSpecifiedPerson()).ifPresent(builder::setReportingSpecifiedPerson);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierType);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getDataSubmitter()).ifPresent(builder::setDataSubmitter);
			ofNullable(getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
			ofNullable(getValuationAmount()).ifPresent(builder::setValuationAmount);
			ofNullable(getValuationCurrency()).ifPresent(builder::setValuationCurrency);
			ofNullable(getValuationMethod()).ifPresent(builder::setValuationMethod);
			ofNullable(getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
			ofNullable(getExecutionAgentOfTheCounterparty1()).ifPresent(builder::setExecutionAgentOfTheCounterparty1);
			ofNullable(getExecutionAgentOfTheCounterparty2()).ifPresent(builder::setExecutionAgentOfTheCounterparty2);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			MASValuationReport _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) return false;
			if (!Objects.equals(reportingSpecifiedPerson, _that.getReportingSpecifiedPerson())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(dataSubmitter, _that.getDataSubmitter())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) return false;
			if (!Objects.equals(executionAgentOfTheCounterparty2, _that.getExecutionAgentOfTheCounterparty2())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifierProprietary != null ? uniqueTransactionIdentifierProprietary.hashCode() : 0);
			_result = 31 * _result + (reportingSpecifiedPerson != null ? reportingSpecifiedPerson.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (dataSubmitter != null ? dataSubmitter.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfTheCounterparty1 != null ? executionAgentOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfTheCounterparty2 != null ? executionAgentOfTheCounterparty2.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "MASValuationReport {" +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", " +
				"reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"actionType=" + this.actionType + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"dataSubmitter=" + this.dataSubmitter + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", " +
				"executionAgentOfTheCounterparty2=" + this.executionAgentOfTheCounterparty2 +
			'}';
		}
	}

	/*********************** Builder Implementation of MASValuationReport  ***********************/
	class MASValuationReportBuilderImpl implements MASValuationReport.MASValuationReportBuilder {
	
		protected String uniqueTransactionIdentifier;
		protected String uniqueTransactionIdentifierProprietary;
		protected String reportingSpecifiedPerson;
		protected String counterparty1;
		protected String counterparty2;
		protected Boolean counterparty2IdentifierType;
		protected String actionType;
		protected ZonedDateTime reportingTimestamp;
		protected String dataSubmitter;
		protected ZonedDateTime valuationTimestamp;
		protected BigDecimal valuationAmount;
		protected ISOCurrencyCodeEnum valuationCurrency;
		protected ValuationType1Code valuationMethod;
		protected String technicalRecordId;
		protected String executionAgentOfTheCounterparty1;
		protected String executionAgentOfTheCounterparty2;
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public String getUniqueTransactionIdentifierProprietary() {
			return uniqueTransactionIdentifierProprietary;
		}
		
		@Override
		@RosettaAttribute("reportingSpecifiedPerson")
		@RuneAttribute("reportingSpecifiedPerson")
		public String getReportingSpecifiedPerson() {
			return reportingSpecifiedPerson;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="dataSubmitter", isRequired=true)
		@RuneAttribute(value="dataSubmitter", isRequired=true)
		public String getDataSubmitter() {
			return dataSubmitter;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfTheCounterparty1")
		@RuneAttribute("executionAgentOfTheCounterparty1")
		public String getExecutionAgentOfTheCounterparty1() {
			return executionAgentOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfTheCounterparty2")
		@RuneAttribute("executionAgentOfTheCounterparty2")
		public String getExecutionAgentOfTheCounterparty2() {
			return executionAgentOfTheCounterparty2;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		@Override
		public MASValuationReport.MASValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		@Override
		public MASValuationReport.MASValuationReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@RosettaAttribute("reportingSpecifiedPerson")
		@RuneAttribute("reportingSpecifiedPerson")
		@Override
		public MASValuationReport.MASValuationReportBuilder setReportingSpecifiedPerson(String _reportingSpecifiedPerson) {
			this.reportingSpecifiedPerson = _reportingSpecifiedPerson == null ? null : _reportingSpecifiedPerson;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public MASValuationReport.MASValuationReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		@Override
		public MASValuationReport.MASValuationReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		@Override
		public MASValuationReport.MASValuationReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public MASValuationReport.MASValuationReportBuilder setActionType(String _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public MASValuationReport.MASValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="dataSubmitter", isRequired=true)
		@RuneAttribute(value="dataSubmitter", isRequired=true)
		@Override
		public MASValuationReport.MASValuationReportBuilder setDataSubmitter(String _dataSubmitter) {
			this.dataSubmitter = _dataSubmitter == null ? null : _dataSubmitter;
			return this;
		}
		
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		@Override
		public MASValuationReport.MASValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		@Override
		public MASValuationReport.MASValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		@Override
		public MASValuationReport.MASValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		@Override
		public MASValuationReport.MASValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		@Override
		public MASValuationReport.MASValuationReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@RosettaAttribute("executionAgentOfTheCounterparty1")
		@RuneAttribute("executionAgentOfTheCounterparty1")
		@Override
		public MASValuationReport.MASValuationReportBuilder setExecutionAgentOfTheCounterparty1(String _executionAgentOfTheCounterparty1) {
			this.executionAgentOfTheCounterparty1 = _executionAgentOfTheCounterparty1 == null ? null : _executionAgentOfTheCounterparty1;
			return this;
		}
		
		@RosettaAttribute("executionAgentOfTheCounterparty2")
		@RuneAttribute("executionAgentOfTheCounterparty2")
		@Override
		public MASValuationReport.MASValuationReportBuilder setExecutionAgentOfTheCounterparty2(String _executionAgentOfTheCounterparty2) {
			this.executionAgentOfTheCounterparty2 = _executionAgentOfTheCounterparty2 == null ? null : _executionAgentOfTheCounterparty2;
			return this;
		}
		
		@Override
		public MASValuationReport build() {
			return new MASValuationReport.MASValuationReportImpl(this);
		}
		
		@Override
		public MASValuationReport.MASValuationReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public MASValuationReport.MASValuationReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUniqueTransactionIdentifier()!=null) return true;
			if (getUniqueTransactionIdentifierProprietary()!=null) return true;
			if (getReportingSpecifiedPerson()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCounterparty2IdentifierType()!=null) return true;
			if (getActionType()!=null) return true;
			if (getReportingTimestamp()!=null) return true;
			if (getDataSubmitter()!=null) return true;
			if (getValuationTimestamp()!=null) return true;
			if (getValuationAmount()!=null) return true;
			if (getValuationCurrency()!=null) return true;
			if (getValuationMethod()!=null) return true;
			if (getTechnicalRecordId()!=null) return true;
			if (getExecutionAgentOfTheCounterparty1()!=null) return true;
			if (getExecutionAgentOfTheCounterparty2()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public MASValuationReport.MASValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			MASValuationReport.MASValuationReportBuilder o = (MASValuationReport.MASValuationReportBuilder) other;
			
			
			merger.mergeBasic(getUniqueTransactionIdentifier(), o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier);
			merger.mergeBasic(getUniqueTransactionIdentifierProprietary(), o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary);
			merger.mergeBasic(getReportingSpecifiedPerson(), o.getReportingSpecifiedPerson(), this::setReportingSpecifiedPerson);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCounterparty2IdentifierType(), o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getDataSubmitter(), o.getDataSubmitter(), this::setDataSubmitter);
			merger.mergeBasic(getValuationTimestamp(), o.getValuationTimestamp(), this::setValuationTimestamp);
			merger.mergeBasic(getValuationAmount(), o.getValuationAmount(), this::setValuationAmount);
			merger.mergeBasic(getValuationCurrency(), o.getValuationCurrency(), this::setValuationCurrency);
			merger.mergeBasic(getValuationMethod(), o.getValuationMethod(), this::setValuationMethod);
			merger.mergeBasic(getTechnicalRecordId(), o.getTechnicalRecordId(), this::setTechnicalRecordId);
			merger.mergeBasic(getExecutionAgentOfTheCounterparty1(), o.getExecutionAgentOfTheCounterparty1(), this::setExecutionAgentOfTheCounterparty1);
			merger.mergeBasic(getExecutionAgentOfTheCounterparty2(), o.getExecutionAgentOfTheCounterparty2(), this::setExecutionAgentOfTheCounterparty2);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			MASValuationReport _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) return false;
			if (!Objects.equals(reportingSpecifiedPerson, _that.getReportingSpecifiedPerson())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(dataSubmitter, _that.getDataSubmitter())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) return false;
			if (!Objects.equals(executionAgentOfTheCounterparty2, _that.getExecutionAgentOfTheCounterparty2())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifierProprietary != null ? uniqueTransactionIdentifierProprietary.hashCode() : 0);
			_result = 31 * _result + (reportingSpecifiedPerson != null ? reportingSpecifiedPerson.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (dataSubmitter != null ? dataSubmitter.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfTheCounterparty1 != null ? executionAgentOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfTheCounterparty2 != null ? executionAgentOfTheCounterparty2.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "MASValuationReportBuilder {" +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", " +
				"reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"actionType=" + this.actionType + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"dataSubmitter=" + this.dataSubmitter + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", " +
				"executionAgentOfTheCounterparty2=" + this.executionAgentOfTheCounterparty2 +
			'}';
		}
	}
}
