package drr.standards.iosco.cde.base.price.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaAssetClassEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.asset.PriceReturnTerms;
import cdm.product.common.settlement.FixedPrice;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_BaseProduct_EquityForward;
import cdm.product.qualification.functions.Qualify_Commodity_OptionOther;
import cdm.product.qualification.functions.Qualify_Credit_OptionOther;
import cdm.product.qualification.functions.Qualify_InterestRate_Forward_Debt;
import cdm.product.template.Basket;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.ReturnTerms;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.IsCommodityForward;
import drr.regulation.common.functions.IsCommoditySwapFixedFloat;
import drr.regulation.common.functions.IsEquityOther;
import drr.regulation.common.functions.IsEquitySwap;
import drr.regulation.common.functions.IsProductETD;
import drr.regulation.common.functions.IsTotalReturnSwapDebtUnderlier;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.TradableProductForEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Contract_Price_Monetary.Contract_Price_MonetaryDefault.class)
public abstract class Contract_Price_Monetary implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected IsCommodityForward isCommodityForward;
	@Inject protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;
	@Inject protected IsEquityOther isEquityOther;
	@Inject protected IsEquitySwap isEquitySwap;
	@Inject protected IsProductETD isProductETD;
	@Inject protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_BaseProduct_EquityForward qualify_BaseProduct_EquityForward;
	@Inject protected Qualify_Commodity_OptionOther qualify_Commodity_OptionOther;
	@Inject protected Qualify_Credit_OptionOther qualify_Credit_OptionOther;
	@Inject protected Qualify_InterestRate_Forward_Debt qualify_InterestRate_Forward_Debt;
	@Inject protected TradableProductForEvent tradableProductForEvent;

	/**
	* @param reportableEvent 
	* @return prices 
	*/
	public List<? extends PriceSchedule> evaluate(ReportableEvent reportableEvent) {
		List<PriceSchedule.PriceScheduleBuilder> pricesBuilder = doEvaluate(reportableEvent);
		
		final List<? extends PriceSchedule> prices;
		if (pricesBuilder == null) {
			prices = null;
		} else {
			prices = pricesBuilder.stream().map(PriceSchedule::build).collect(Collectors.toList());
			objectValidator.validate(PriceSchedule.class, prices);
		}
		
		return prices;
	}

	protected abstract List<PriceSchedule.PriceScheduleBuilder> doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends TradableProduct> tradableProduct(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent);

	public static class Contract_Price_MonetaryDefault extends Contract_Price_Monetary {
		@Override
		protected List<PriceSchedule.PriceScheduleBuilder> doEvaluate(ReportableEvent reportableEvent) {
			List<PriceSchedule.PriceScheduleBuilder> prices = new ArrayList<>();
			return assignOutput(prices, reportableEvent);
		}
		
		protected List<PriceSchedule.PriceScheduleBuilder> assignOutput(List<PriceSchedule.PriceScheduleBuilder> prices, ReportableEvent reportableEvent) {
			if (ComparisonResult.of(MapperS.of(isEquitySwap.evaluate(tradableProduct(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(isEquityOther.evaluate(tradableProduct(reportableEvent).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_OptionOther.evaluate(economicTermsForProduct.evaluate(tradableProduct(reportableEvent).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()))))).or(ComparisonResult.of(MapperS.of(qualify_Credit_OptionOther.evaluate(economicTermsForProduct.evaluate(tradableProduct(reportableEvent).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()))))).getOrDefault(false)) {
				if (exists(MapperS.of(economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<ReturnTerms>map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).<PriceReturnTerms>map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms()).<PriceSchedule>map("getValuationPriceInitial", priceReturnTerms -> priceReturnTerms.getValuationPriceInitial())).getOrDefault(false)) {
					prices.addAll(toBuilder(MapperS.of(economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<ReturnTerms>map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).<PriceReturnTerms>map("getPriceReturnTerms", returnTerms -> returnTerms.getPriceReturnTerms()).<PriceSchedule>map("getValuationPriceInitial", priceReturnTerms -> priceReturnTerms.getValuationPriceInitial()).getMulti()));
				} else {
					prices.addAll(toBuilder(tradableProduct(reportableEvent).<TradeLot>mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice())
						.filterItemNullSafe(item -> areEqual(item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.ASSET_PRICE), CardinalityOperator.All).or(areEqual(item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.CASH_PRICE), CardinalityOperator.All)).get()).<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
				}
			} else if (ComparisonResult.of(MapperS.of(qualify_BaseProduct_EquityForward.evaluate(economicTerms(reportableEvent).get()))).or(exists(economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout())).and(areEqual(MapperS.of(MapperS.of(economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket()).<ProductTaxonomy>mapC("getProductTaxonomy", basket -> basket.getProductTaxonomy()).get()).<FieldWithMetaAssetClassEnum>map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).<AssetClassEnum>map("Type coercion", fieldWithMetaAssetClassEnum -> fieldWithMetaAssetClassEnum == null ? null : fieldWithMetaAssetClassEnum.getValue()), MapperS.of(AssetClassEnum.EQUITY), CardinalityOperator.All))).getOrDefault(false)) {
				if (tradableProduct(reportableEvent).<TradeLot>mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice())
					.filterItemNullSafe(item -> areEqual(item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.ASSET_PRICE), CardinalityOperator.All).or(areEqual(item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.CASH_PRICE), CardinalityOperator.All)).get()).<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti().isEmpty()) {
					prices.addAll(toBuilder(MapperS.of(economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).<ReferenceWithMetaPriceSchedule>mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).<PriceSchedule>map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule.getValue()).getMulti()));
				} else {
					prices.addAll(toBuilder(tradableProduct(reportableEvent).<TradeLot>mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice())
						.filterItemNullSafe(item -> areEqual(item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.ASSET_PRICE), CardinalityOperator.All).or(areEqual(item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.CASH_PRICE), CardinalityOperator.All)).get()).<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
				}
			} else if (ComparisonResult.of(MapperS.of(isTotalReturnSwapDebtUnderlier.evaluate(tradableProduct(reportableEvent).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_Forward_Debt.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				prices.addAll(toBuilder(tradableProduct(reportableEvent).<TradeLot>mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice())
					.filterItemNullSafe(item -> areEqual(item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.ASSET_PRICE), CardinalityOperator.All).or(areEqual(item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.CASH_PRICE), CardinalityOperator.All)).get()).<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
			} else if (onlyExists(economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("forwardPayout")).and(ComparisonResult.of(MapperS.of(isProductETD.evaluate(tradableProduct(reportableEvent).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get())))).getOrDefault(false)) {
				prices.addAll(toBuilder(tradableProduct(reportableEvent).<TradeLot>mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice())
					.filterItemNullSafe(item -> areEqual(item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.ASSET_PRICE), CardinalityOperator.All).or(areEqual(item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.CASH_PRICE), CardinalityOperator.All)).or(areEqual(item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule2 -> fieldWithMetaPriceSchedule2 == null ? null : fieldWithMetaPriceSchedule2.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.EXCHANGE_RATE), CardinalityOperator.All)).get()).<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
			} else {
				final Boolean boolean0 = isCommoditySwapFixedFloat.evaluate(tradableProduct(reportableEvent).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
				if ((boolean0 == null ? false : boolean0)) {
					prices.addAll(toBuilder(MapperS.of(fixedPriceLeg1.evaluate(productForEvent.evaluate(reportableEvent))).<FixedPrice>map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).<ReferenceWithMetaPriceSchedule>map("getPrice", fixedPrice -> fixedPrice.getPrice()).<PriceSchedule>map("Type coercion", referenceWithMetaPriceSchedule0 -> referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()).getMulti()));
				} else {
					final Boolean boolean1 = isCommodityForward.evaluate(tradableProduct(reportableEvent).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get());
					if ((boolean1 == null ? false : boolean1)) {
						if (exists(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())).getOrDefault(false)) {
							prices.addAll(toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()).<FixedPrice>map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).<ReferenceWithMetaPriceSchedule>map("getPrice", fixedPrice -> fixedPrice.getPrice()).<PriceSchedule>map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()).getMulti()));
						} else if (exists(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).getOrDefault(false)) {
							prices.addAll(toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).<ReferenceWithMetaPriceSchedule>mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).<PriceSchedule>map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule.getValue()).getMulti()));
						} else {
							prices.addAll(toBuilder(Collections.<PriceSchedule>emptyList()));
						}
					} else {
						prices.addAll(toBuilder(Collections.<PriceSchedule>emptyList()));
					}
				}
			}
			
			return Optional.ofNullable(prices)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends TradableProduct> tradableProduct(ReportableEvent reportableEvent) {
			return MapperS.of(tradableProductForEvent.evaluate(reportableEvent));
		}
		
		@Override
		protected MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent) {
			return MapperS.of(economicTermsForProduct.evaluate(tradableProduct(reportableEvent).<Product>map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()));
		}
	}
}
