package drr.standards.iosco.cde.version1.price.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetPriceNotation;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SpreadLeg2NotationEnumRule.SpreadLeg2NotationEnumRuleDefault.class)
public abstract class SpreadLeg2NotationEnumRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetPriceNotation getPriceNotation;
	@Inject protected SpreadLeg2Rule spreadLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class SpreadLeg2NotationEnumRuleDefault extends SpreadLeg2NotationEnumRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			final PriceSchedule priceSchedule = spreadLeg2Rule.evaluate(input);
			final MapperS<ReferenceWithMetaPriceSchedule> thenArg = priceSchedule == null ? MapperS.<ReferenceWithMetaPriceSchedule>ofNull() : MapperS.of(ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build());
			output = thenArg
				.mapSingleToItem(item -> {
					if (exists(item.<PriceSchedule>map("Type coercion", referenceWithMetaPriceSchedule0 -> referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()).<BigDecimal>map("getValue", _priceSchedule -> _priceSchedule.getValue())).getOrDefault(false)) {
						final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule1 = item.get();
						return MapperS.of(getPriceNotation.evaluate((referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue())));
					}
					return MapperS.<PriceNotationEnum>ofNull();
				}).get();
			
			return output;
		}
	}
}
