package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNotationString;
import javax.inject.Inject;


@ImplementedBy(SpreadLeg2NotationRule.SpreadLeg2NotationRuleDefault.class)
public abstract class SpreadLeg2NotationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetNotationString getNotationString;
	@Inject protected SpreadLeg2NotationEnumRule spreadLeg2NotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class SpreadLeg2NotationRuleDefault extends SpreadLeg2NotationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = getNotationString.evaluate(spreadLeg2NotationEnumRule.evaluate(input));
			
			return output;
		}
	}
}
