package drr.standards.iosco.cde.version2.basket.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;


@ImplementedBy(IdentifierOfBasketConstituentsRule.IdentifierOfBasketConstituentsRuleDefault.class)
public abstract class IdentifierOfBasketConstituentsRule implements ReportFunction<ReportableEvent, List<String>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version1.basket.reports.IdentifierOfBasketConstituentsRule identifierOfBasketConstituentsRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<String> evaluate(ReportableEvent input) {
		List<String> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<String> doEvaluate(ReportableEvent input);

	public static class IdentifierOfBasketConstituentsRuleDefault extends IdentifierOfBasketConstituentsRule {
		@Override
		protected List<String> doEvaluate(ReportableEvent input) {
			List<String> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<String> assignOutput(List<String> output, ReportableEvent input) {
			output = identifierOfBasketConstituentsRule.evaluate(input);
			
			return output;
		}
	}
}
