package drr.standards.iosco.cde.version2.functions;

import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.common.functions.SettlementTermsLeg2;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.version2.LegV2;
import drr.standards.iosco.cde.version2.execution.reports.SettlementCurrencyRule;
import drr.standards.iosco.cde.version2.party.reports.Direction2Leg2Rule;
import drr.standards.iosco.cde.version2.payment.reports.PeriodicPaymentRule;
import drr.standards.iosco.cde.version2.price.reports.InterestRateFixedRateRule;
import drr.standards.iosco.cde.version2.price.reports.SpreadLeg2CurrencyRule;
import drr.standards.iosco.cde.version2.price.reports.SpreadLeg2Rule;
import drr.standards.iosco.cde.version2.quantity.functions.NotionalAmountLeg2;
import drr.standards.iosco.cde.version2.quantity.functions.TotalNotionalQuantityLeg2;
import drr.standards.iosco.cde.version2.quantity.reports.NotionalAmountScheduleLeg2Rule;
import drr.standards.iosco.cde.version2.quantity.reports.NotionalCurrencyLeg2Rule;
import drr.standards.iosco.cde.version2.quantity.reports.NotionalQuantityScheduleLeg2Rule;
import drr.standards.iosco.cde.version2.quantity.reports.QuantityUnitOfMeasureLeg2Rule;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Leg2.Leg2Default.class)
public abstract class Leg2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Direction2Leg2Rule direction2Leg2Rule;
	@Inject protected InterestRateFixedRateRule interestRateFixedRateRule;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected NotionalAmountLeg2 notionalAmountLeg2;
	@Inject protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
	@Inject protected NotionalCurrencyLeg2Rule notionalCurrencyLeg2Rule;
	@Inject protected NotionalQuantityScheduleLeg2Rule notionalQuantityScheduleLeg2Rule;
	@Inject protected PeriodicPaymentRule periodicPaymentRule;
	@Inject protected PriceFormatFromNotation priceFormatFromNotation;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
	@Inject protected SettlementCurrencyRule settlementCurrencyRule;
	@Inject protected SettlementTermsLeg2 settlementTermsLeg2;
	@Inject protected SpreadLeg2CurrencyRule spreadLeg2CurrencyRule;
	@Inject protected SpreadLeg2Rule spreadLeg2Rule;
	@Inject protected TotalNotionalQuantityLeg2 totalNotionalQuantityLeg2;

	/**
	* @param transaction 
	* @param spreadNotation 
	* @param defaultValue 
	* @return leg 
	*/
	public LegV2 evaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
		LegV2.LegV2Builder legBuilder = doEvaluate(transaction, spreadNotation, defaultValue);
		
		final LegV2 leg;
		if (legBuilder == null) {
			leg = null;
		} else {
			leg = legBuilder.build();
			objectValidator.validate(LegV2.class, leg);
		}
		
		return leg;
	}

	protected abstract LegV2.LegV2Builder doEvaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue);

	public static class Leg2Default extends Leg2 {
		@Override
		protected LegV2.LegV2Builder doEvaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
			LegV2.LegV2Builder leg = LegV2.builder();
			return assignOutput(leg, transaction, spreadNotation, defaultValue);
		}
		
		protected LegV2.LegV2Builder assignOutput(LegV2.LegV2Builder leg, TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
			leg = toBuilder(MapperS.of(transaction)
				.mapSingleToItem(item -> {
					final MapperS<Product> thenArg0 = item
						.mapSingleToItem(_item -> MapperS.of(productForEvent.evaluate(_item.get())));
					final MapperS<Product> thenArg1 = thenArg0
						.mapSingleToItem(_item -> MapperS.of(productOrUnderlierProduct.evaluate(_item.get())));
					final MapperS<Product> thenArg2 = item
						.mapSingleToItem(_item -> MapperS.of(productForEvent.evaluate(_item.get())));
					final MapperS<SettlementTerms> thenArg3 = thenArg2
						.mapSingleToItem(_item -> MapperS.of(settlementTermsLeg2.evaluate(_item.get())));
					return MapperS.of(LegV2.builder()
						.setPeriodicPayment(periodicPaymentRule.evaluate(interestRateLeg2.evaluate(productOrUnderlierProduct.evaluate(productForEvent.evaluate(item.get())))))
						.setFixedRate(MapperS.of(interestRateFixedRateRule.evaluate(interestRateLeg2.evaluate(thenArg1.get()))).get())
						.setNotionalAmount(notionalAmountLeg2.evaluate(transaction, defaultValue))
						.setNotionalCurrency(notionalCurrencyLeg2Rule.evaluate(item.get()))
						.setTotalNotionalQuantity(totalNotionalQuantityLeg2.evaluate(transaction, defaultValue))
						.setNotionalAmountSchedule(new ArrayList(notionalAmountScheduleLeg2Rule.evaluate(item.get())))
						.setNotionalQuantitySchedule(new ArrayList(notionalQuantityScheduleLeg2Rule.evaluate(item.get())))
						.setSettlementCurrency(thenArg3
							.mapSingleToItem(_item -> MapperS.of(settlementCurrencyRule.evaluate(_item.get()))).get())
						.setSpread(item
							.mapSingleToItem(_item -> MapperS.of(priceFormatFromNotation.evaluate(MapperS.of(spreadLeg2Rule.evaluate(_item.get())).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()).get(), spreadNotation))).get())
						.setSpreadNotation(spreadNotation)
						.setSpreadCurrency(item
							.mapSingleToItem(_item -> MapperS.of(spreadLeg2CurrencyRule.evaluate(_item.get()))).get())
						.setQuantityUnitOfMeasure(quantityUnitOfMeasureLeg2Rule.evaluate(item.get()))
						.setDirection2(direction2Leg2Rule.evaluate(item.get()))
						.build());
				}).get());
			
			return Optional.ofNullable(leg)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
