package drr.standards.iosco.cde.version3.basket.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.standards.iosco.cde.version2.basket.reports.IdentifierOfBasketConstituentsRule;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;


@ImplementedBy(BasketConstituentIdentifierRule.BasketConstituentIdentifierRuleDefault.class)
public abstract class BasketConstituentIdentifierRule implements ReportFunction<ReportableEvent, List<String>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IdentifierOfBasketConstituentsRule identifierOfBasketConstituentsRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<String> evaluate(ReportableEvent input) {
		List<String> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<String> doEvaluate(ReportableEvent input);

	public static class BasketConstituentIdentifierRuleDefault extends BasketConstituentIdentifierRule {
		@Override
		protected List<String> doEvaluate(ReportableEvent input) {
			List<String> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<String> assignOutput(List<String> output, ReportableEvent input) {
			output = identifierOfBasketConstituentsRule.evaluate(input);
			
			return output;
		}
	}
}
