package drr.standards.iosco.upi;

import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * @version 6.17.1
 */
@RosettaEnum("AnnaDsbPlaceofSettlementEnum")
public enum AnnaDsbPlaceofSettlementEnum {

	/**
	 * Afghanistan
	 */
	@RosettaEnumValue(value = "Afghanistan", displayName = "Afghanistan") 
	AFGHANISTAN("Afghanistan", "Afghanistan"),
	
	/**
	 * Aland Islands
	 */
	@RosettaEnumValue(value = "Aland_Islands", displayName = "Aland Islands") 
	ALAND_ISLANDS("Aland_Islands", "Aland Islands"),
	
	/**
	 * Albania
	 */
	@RosettaEnumValue(value = "Albania", displayName = "Albania") 
	ALBANIA("Albania", "Albania"),
	
	/**
	 * Algeria
	 */
	@RosettaEnumValue(value = "Algeria", displayName = "Algeria") 
	ALGERIA("Algeria", "Algeria"),
	
	/**
	 * American Samoa
	 */
	@RosettaEnumValue(value = "American_Samoa", displayName = "American Samoa") 
	AMERICAN_SAMOA("American_Samoa", "American Samoa"),
	
	/**
	 * Andorra
	 */
	@RosettaEnumValue(value = "Andorra", displayName = "Andorra") 
	ANDORRA("Andorra", "Andorra"),
	
	/**
	 * Angola
	 */
	@RosettaEnumValue(value = "Angola", displayName = "Angola") 
	ANGOLA("Angola", "Angola"),
	
	/**
	 * Anguilla
	 */
	@RosettaEnumValue(value = "Anguilla", displayName = "Anguilla") 
	ANGUILLA("Anguilla", "Anguilla"),
	
	/**
	 * Antarctica
	 */
	@RosettaEnumValue(value = "Antarctica", displayName = "Antarctica") 
	ANTARCTICA("Antarctica", "Antarctica"),
	
	/**
	 * Antigua and Barbuda
	 */
	@RosettaEnumValue(value = "Antigua_and_Barbuda", displayName = "Antigua and Barbuda") 
	ANTIGUA_AND_BARBUDA("Antigua_and_Barbuda", "Antigua and Barbuda"),
	
	/**
	 * Argentina
	 */
	@RosettaEnumValue(value = "Argentina", displayName = "Argentina") 
	ARGENTINA("Argentina", "Argentina"),
	
	/**
	 * Armenia
	 */
	@RosettaEnumValue(value = "Armenia", displayName = "Armenia") 
	ARMENIA("Armenia", "Armenia"),
	
	/**
	 * Aruba
	 */
	@RosettaEnumValue(value = "Aruba", displayName = "Aruba") 
	ARUBA("Aruba", "Aruba"),
	
	/**
	 * Australia
	 */
	@RosettaEnumValue(value = "Australia", displayName = "Australia") 
	AUSTRALIA("Australia", "Australia"),
	
	/**
	 * Austria
	 */
	@RosettaEnumValue(value = "Austria", displayName = "Austria") 
	AUSTRIA("Austria", "Austria"),
	
	/**
	 * Azerbaijan
	 */
	@RosettaEnumValue(value = "Azerbaijan", displayName = "Azerbaijan") 
	AZERBAIJAN("Azerbaijan", "Azerbaijan"),
	
	/**
	 * Bahamas
	 */
	@RosettaEnumValue(value = "Bahamas", displayName = "Bahamas") 
	BAHAMAS("Bahamas", "Bahamas"),
	
	/**
	 * Bahrain
	 */
	@RosettaEnumValue(value = "Bahrain", displayName = "Bahrain") 
	BAHRAIN("Bahrain", "Bahrain"),
	
	/**
	 * Bangladesh
	 */
	@RosettaEnumValue(value = "Bangladesh", displayName = "Bangladesh") 
	BANGLADESH("Bangladesh", "Bangladesh"),
	
	/**
	 * Barbados
	 */
	@RosettaEnumValue(value = "Barbados", displayName = "Barbados") 
	BARBADOS("Barbados", "Barbados"),
	
	/**
	 * Belarus
	 */
	@RosettaEnumValue(value = "Belarus", displayName = "Belarus") 
	BELARUS("Belarus", "Belarus"),
	
	/**
	 * Belgium
	 */
	@RosettaEnumValue(value = "Belgium", displayName = "Belgium") 
	BELGIUM("Belgium", "Belgium"),
	
	/**
	 * Belize
	 */
	@RosettaEnumValue(value = "Belize", displayName = "Belize") 
	BELIZE("Belize", "Belize"),
	
	/**
	 * Benin
	 */
	@RosettaEnumValue(value = "Benin", displayName = "Benin") 
	BENIN("Benin", "Benin"),
	
	/**
	 * Bermuda
	 */
	@RosettaEnumValue(value = "Bermuda", displayName = "Bermuda") 
	BERMUDA("Bermuda", "Bermuda"),
	
	/**
	 * Bhutan
	 */
	@RosettaEnumValue(value = "Bhutan", displayName = "Bhutan") 
	BHUTAN("Bhutan", "Bhutan"),
	
	/**
	 * Bolivia, Plurinational State of
	 */
	@RosettaEnumValue(value = "Bolivia_Plurinational_State_of", displayName = "Bolivia, Plurinational State of") 
	BOLIVIA_PLURINATIONAL_STATE_OF("Bolivia_Plurinational_State_of", "Bolivia, Plurinational State of"),
	
	/**
	 * Bonaire, Sint Eustatius and Saba
	 */
	@RosettaEnumValue(value = "Bonaire_Sint_Eustatius_and_Saba", displayName = "Bonaire, Sint Eustatius and Saba") 
	BONAIRE_SINT_EUSTATIUS_AND_SABA("Bonaire_Sint_Eustatius_and_Saba", "Bonaire, Sint Eustatius and Saba"),
	
	/**
	 * Bosnia and Herzegovina
	 */
	@RosettaEnumValue(value = "Bosnia_and_Herzegovina", displayName = "Bosnia and Herzegovina") 
	BOSNIA_AND_HERZEGOVINA("Bosnia_and_Herzegovina", "Bosnia and Herzegovina"),
	
	/**
	 * Botswana
	 */
	@RosettaEnumValue(value = "Botswana", displayName = "Botswana") 
	BOTSWANA("Botswana", "Botswana"),
	
	/**
	 * Bouvet Island
	 */
	@RosettaEnumValue(value = "Bouvet_Island", displayName = "Bouvet Island") 
	BOUVET_ISLAND("Bouvet_Island", "Bouvet Island"),
	
	/**
	 * Brazil
	 */
	@RosettaEnumValue(value = "Brazil", displayName = "Brazil") 
	BRAZIL("Brazil", "Brazil"),
	
	/**
	 * British Indian Ocean Territory
	 */
	@RosettaEnumValue(value = "British_Indian_Ocean_Territory", displayName = "British Indian Ocean Territory") 
	BRITISH_INDIAN_OCEAN_TERRITORY("British_Indian_Ocean_Territory", "British Indian Ocean Territory"),
	
	/**
	 * Brunei Darussalam
	 */
	@RosettaEnumValue(value = "Brunei_Darussalam", displayName = "Brunei Darussalam") 
	BRUNEI_DARUSSALAM("Brunei_Darussalam", "Brunei Darussalam"),
	
	/**
	 * Bulgaria
	 */
	@RosettaEnumValue(value = "Bulgaria", displayName = "Bulgaria") 
	BULGARIA("Bulgaria", "Bulgaria"),
	
	/**
	 * Burkina Faso
	 */
	@RosettaEnumValue(value = "Burkina_Faso", displayName = "Burkina Faso") 
	BURKINA_FASO("Burkina_Faso", "Burkina Faso"),
	
	/**
	 * Burundi
	 */
	@RosettaEnumValue(value = "Burundi", displayName = "Burundi") 
	BURUNDI("Burundi", "Burundi"),
	
	/**
	 * Cambodia
	 */
	@RosettaEnumValue(value = "Cambodia", displayName = "Cambodia") 
	CAMBODIA("Cambodia", "Cambodia"),
	
	/**
	 * Cameroon
	 */
	@RosettaEnumValue(value = "Cameroon", displayName = "Cameroon") 
	CAMEROON("Cameroon", "Cameroon"),
	
	/**
	 * Canada
	 */
	@RosettaEnumValue(value = "Canada", displayName = "Canada") 
	CANADA("Canada", "Canada"),
	
	/**
	 * Cape Verde
	 */
	@RosettaEnumValue(value = "Cape_Verde", displayName = "Cape Verde") 
	CAPE_VERDE("Cape_Verde", "Cape Verde"),
	
	/**
	 * Cayman Islands
	 */
	@RosettaEnumValue(value = "Cayman_Islands", displayName = "Cayman Islands") 
	CAYMAN_ISLANDS("Cayman_Islands", "Cayman Islands"),
	
	/**
	 * Central African Republic
	 */
	@RosettaEnumValue(value = "Central_African_Republic", displayName = "Central African Republic") 
	CENTRAL_AFRICAN_REPUBLIC("Central_African_Republic", "Central African Republic"),
	
	/**
	 * Chad
	 */
	@RosettaEnumValue(value = "Chad", displayName = "Chad") 
	CHAD("Chad", "Chad"),
	
	/**
	 * Chile
	 */
	@RosettaEnumValue(value = "Chile", displayName = "Chile") 
	CHILE("Chile", "Chile"),
	
	/**
	 * China
	 */
	@RosettaEnumValue(value = "China", displayName = "China") 
	CHINA("China", "China"),
	
	/**
	 * Christmas Island
	 */
	@RosettaEnumValue(value = "Christmas_Island", displayName = "Christmas Island") 
	CHRISTMAS_ISLAND("Christmas_Island", "Christmas Island"),
	
	/**
	 * Cocos (Keeling) Islands
	 */
	@RosettaEnumValue(value = "Cocos_Keeling_Islands", displayName = "Cocos (Keeling) Islands") 
	COCOS_KEELING_ISLANDS("Cocos_Keeling_Islands", "Cocos (Keeling) Islands"),
	
	/**
	 * Colombia
	 */
	@RosettaEnumValue(value = "Colombia", displayName = "Colombia") 
	COLOMBIA("Colombia", "Colombia"),
	
	/**
	 * Comoros
	 */
	@RosettaEnumValue(value = "Comoros", displayName = "Comoros") 
	COMOROS("Comoros", "Comoros"),
	
	/**
	 * Congo
	 */
	@RosettaEnumValue(value = "Congo", displayName = "Congo") 
	CONGO("Congo", "Congo"),
	
	/**
	 * Congo, the Democratic Republic of the
	 */
	@RosettaEnumValue(value = "Congo_the_Democratic_Republic_of_the", displayName = "Congo, the Democratic Republic of the") 
	CONGO_THE_DEMOCRATIC_REPUBLIC_OF_THE("Congo_the_Democratic_Republic_of_the", "Congo, the Democratic Republic of the"),
	
	/**
	 * Cook Islands
	 */
	@RosettaEnumValue(value = "Cook_Islands", displayName = "Cook Islands") 
	COOK_ISLANDS("Cook_Islands", "Cook Islands"),
	
	/**
	 * Costa Rica
	 */
	@RosettaEnumValue(value = "Costa_Rica", displayName = "Costa Rica") 
	COSTA_RICA("Costa_Rica", "Costa Rica"),
	
	/**
	 * Cote d&#39;Ivoire
	 */
	@RosettaEnumValue(value = "Cote_d_Ivoire", displayName = "Cote d'Ivoire") 
	COTE_D_IVOIRE("Cote_d_Ivoire", "Cote d'Ivoire"),
	
	/**
	 * Croatia
	 */
	@RosettaEnumValue(value = "Croatia", displayName = "Croatia") 
	CROATIA("Croatia", "Croatia"),
	
	/**
	 * Cuba
	 */
	@RosettaEnumValue(value = "Cuba", displayName = "Cuba") 
	CUBA("Cuba", "Cuba"),
	
	/**
	 * Curacao
	 */
	@RosettaEnumValue(value = "Curacao", displayName = "Curacao") 
	CURACAO("Curacao", "Curacao"),
	
	/**
	 * Cyprus
	 */
	@RosettaEnumValue(value = "Cyprus", displayName = "Cyprus") 
	CYPRUS("Cyprus", "Cyprus"),
	
	/**
	 * Czech Republic
	 */
	@RosettaEnumValue(value = "Czech_Republic", displayName = "Czech Republic") 
	CZECH_REPUBLIC("Czech_Republic", "Czech Republic"),
	
	/**
	 * Denmark
	 */
	@RosettaEnumValue(value = "Denmark", displayName = "Denmark") 
	DENMARK("Denmark", "Denmark"),
	
	/**
	 * Djibouti
	 */
	@RosettaEnumValue(value = "Djibouti", displayName = "Djibouti") 
	DJIBOUTI("Djibouti", "Djibouti"),
	
	/**
	 * Dominica
	 */
	@RosettaEnumValue(value = "Dominica", displayName = "Dominica") 
	DOMINICA("Dominica", "Dominica"),
	
	/**
	 * Dominican Republic
	 */
	@RosettaEnumValue(value = "Dominican_Republic", displayName = "Dominican Republic") 
	DOMINICAN_REPUBLIC("Dominican_Republic", "Dominican Republic"),
	
	/**
	 * Ecuador
	 */
	@RosettaEnumValue(value = "Ecuador", displayName = "Ecuador") 
	ECUADOR("Ecuador", "Ecuador"),
	
	/**
	 * Egypt
	 */
	@RosettaEnumValue(value = "Egypt", displayName = "Egypt") 
	EGYPT("Egypt", "Egypt"),
	
	/**
	 * El Salvador
	 */
	@RosettaEnumValue(value = "El_Salvador", displayName = "El Salvador") 
	EL_SALVADOR("El_Salvador", "El Salvador"),
	
	/**
	 * Equatorial Guinea
	 */
	@RosettaEnumValue(value = "Equatorial_Guinea", displayName = "Equatorial Guinea") 
	EQUATORIAL_GUINEA("Equatorial_Guinea", "Equatorial Guinea"),
	
	/**
	 * Eritrea
	 */
	@RosettaEnumValue(value = "Eritrea", displayName = "Eritrea") 
	ERITREA("Eritrea", "Eritrea"),
	
	/**
	 * Estonia
	 */
	@RosettaEnumValue(value = "Estonia", displayName = "Estonia") 
	ESTONIA("Estonia", "Estonia"),
	
	/**
	 * Ethiopia
	 */
	@RosettaEnumValue(value = "Ethiopia", displayName = "Ethiopia") 
	ETHIOPIA("Ethiopia", "Ethiopia"),
	
	/**
	 * Falkland Islands (Malvinas)
	 */
	@RosettaEnumValue(value = "Falkland_Islands_Malvinas_", displayName = "Falkland Islands (Malvinas)") 
	FALKLAND_ISLANDS_MALVINAS("Falkland_Islands_Malvinas_", "Falkland Islands (Malvinas)"),
	
	/**
	 * Faroe Islands
	 */
	@RosettaEnumValue(value = "Faroe_Islands", displayName = "Faroe Islands") 
	FAROE_ISLANDS("Faroe_Islands", "Faroe Islands"),
	
	/**
	 * Fiji
	 */
	@RosettaEnumValue(value = "Fiji", displayName = "Fiji") 
	FIJI("Fiji", "Fiji"),
	
	/**
	 * Finland
	 */
	@RosettaEnumValue(value = "Finland", displayName = "Finland") 
	FINLAND("Finland", "Finland"),
	
	/**
	 * France
	 */
	@RosettaEnumValue(value = "France", displayName = "France") 
	FRANCE("France", "France"),
	
	/**
	 * French Guiana
	 */
	@RosettaEnumValue(value = "French_Guiana", displayName = "French Guiana") 
	FRENCH_GUIANA("French_Guiana", "French Guiana"),
	
	/**
	 * French Polynesia
	 */
	@RosettaEnumValue(value = "French_Polynesia", displayName = "French Polynesia") 
	FRENCH_POLYNESIA("French_Polynesia", "French Polynesia"),
	
	/**
	 * French Southern Territories
	 */
	@RosettaEnumValue(value = "French_Southern_Territories", displayName = "French Southern Territories") 
	FRENCH_SOUTHERN_TERRITORIES("French_Southern_Territories", "French Southern Territories"),
	
	/**
	 * Gabon
	 */
	@RosettaEnumValue(value = "Gabon", displayName = "Gabon") 
	GABON("Gabon", "Gabon"),
	
	/**
	 * Gambia
	 */
	@RosettaEnumValue(value = "Gambia", displayName = "Gambia") 
	GAMBIA("Gambia", "Gambia"),
	
	/**
	 * Georgia
	 */
	@RosettaEnumValue(value = "Georgia", displayName = "Georgia") 
	GEORGIA("Georgia", "Georgia"),
	
	/**
	 * Germany
	 */
	@RosettaEnumValue(value = "Germany", displayName = "Germany") 
	GERMANY("Germany", "Germany"),
	
	/**
	 * Ghana
	 */
	@RosettaEnumValue(value = "Ghana", displayName = "Ghana") 
	GHANA("Ghana", "Ghana"),
	
	/**
	 * Gibraltar
	 */
	@RosettaEnumValue(value = "Gibraltar", displayName = "Gibraltar") 
	GIBRALTAR("Gibraltar", "Gibraltar"),
	
	/**
	 * Greece
	 */
	@RosettaEnumValue(value = "Greece", displayName = "Greece") 
	GREECE("Greece", "Greece"),
	
	/**
	 * Greenland
	 */
	@RosettaEnumValue(value = "Greenland", displayName = "Greenland") 
	GREENLAND("Greenland", "Greenland"),
	
	/**
	 * Grenada
	 */
	@RosettaEnumValue(value = "Grenada", displayName = "Grenada") 
	GRENADA("Grenada", "Grenada"),
	
	/**
	 * Guadeloupe
	 */
	@RosettaEnumValue(value = "Guadeloupe", displayName = "Guadeloupe") 
	GUADELOUPE("Guadeloupe", "Guadeloupe"),
	
	/**
	 * Guam
	 */
	@RosettaEnumValue(value = "Guam", displayName = "Guam") 
	GUAM("Guam", "Guam"),
	
	/**
	 * Guatemala
	 */
	@RosettaEnumValue(value = "Guatemala", displayName = "Guatemala") 
	GUATEMALA("Guatemala", "Guatemala"),
	
	/**
	 * Guernsey
	 */
	@RosettaEnumValue(value = "Guernsey", displayName = "Guernsey") 
	GUERNSEY("Guernsey", "Guernsey"),
	
	/**
	 * Guinea
	 */
	@RosettaEnumValue(value = "Guinea", displayName = "Guinea") 
	GUINEA("Guinea", "Guinea"),
	
	/**
	 * Guinea-Bissau
	 */
	@RosettaEnumValue(value = "Guinea_Bissau", displayName = "Guinea-Bissau") 
	GUINEA_BISSAU("Guinea_Bissau", "Guinea-Bissau"),
	
	/**
	 * Guyana
	 */
	@RosettaEnumValue(value = "Guyana", displayName = "Guyana") 
	GUYANA("Guyana", "Guyana"),
	
	/**
	 * Haiti
	 */
	@RosettaEnumValue(value = "Haiti", displayName = "Haiti") 
	HAITI("Haiti", "Haiti"),
	
	/**
	 * Heard Island and McDonald Islands
	 */
	@RosettaEnumValue(value = "Heard_Island_and_McDonald_Islands", displayName = "Heard Island and McDonald Islands") 
	HEARD_ISLAND_AND_MC_DONALD_ISLANDS("Heard_Island_and_McDonald_Islands", "Heard Island and McDonald Islands"),
	
	/**
	 * Holy See (Vatican City State)
	 */
	@RosettaEnumValue(value = "Holy_See_Vatican_City_State_", displayName = "Holy See (Vatican City State)") 
	HOLY_SEE_VATICAN_CITY_STATE("Holy_See_Vatican_City_State_", "Holy See (Vatican City State)"),
	
	/**
	 * Honduras
	 */
	@RosettaEnumValue(value = "Honduras", displayName = "Honduras") 
	HONDURAS("Honduras", "Honduras"),
	
	/**
	 * Hong Kong
	 */
	@RosettaEnumValue(value = "Hong_Kong", displayName = "Hong Kong") 
	HONG_KONG("Hong_Kong", "Hong Kong"),
	
	/**
	 * Hungary
	 */
	@RosettaEnumValue(value = "Hungary", displayName = "Hungary") 
	HUNGARY("Hungary", "Hungary"),
	
	/**
	 * Iceland
	 */
	@RosettaEnumValue(value = "Iceland", displayName = "Iceland") 
	ICELAND("Iceland", "Iceland"),
	
	/**
	 * India
	 */
	@RosettaEnumValue(value = "India", displayName = "India") 
	INDIA("India", "India"),
	
	/**
	 * Indonesia
	 */
	@RosettaEnumValue(value = "Indonesia", displayName = "Indonesia") 
	INDONESIA("Indonesia", "Indonesia"),
	
	/**
	 * Iran, Islamic Republic of
	 */
	@RosettaEnumValue(value = "Iran_Islamic_Republic_of", displayName = "Iran, Islamic Republic of") 
	IRAN_ISLAMIC_REPUBLIC_OF("Iran_Islamic_Republic_of", "Iran, Islamic Republic of"),
	
	/**
	 * Iraq
	 */
	@RosettaEnumValue(value = "Iraq", displayName = "Iraq") 
	IRAQ("Iraq", "Iraq"),
	
	/**
	 * Ireland
	 */
	@RosettaEnumValue(value = "Ireland", displayName = "Ireland") 
	IRELAND("Ireland", "Ireland"),
	
	/**
	 * Isle of Man
	 */
	@RosettaEnumValue(value = "Isle_of_Man", displayName = "Isle of Man") 
	ISLE_OF_MAN("Isle_of_Man", "Isle of Man"),
	
	/**
	 * Israel
	 */
	@RosettaEnumValue(value = "Israel", displayName = "Israel") 
	ISRAEL("Israel", "Israel"),
	
	/**
	 * Italy
	 */
	@RosettaEnumValue(value = "Italy", displayName = "Italy") 
	ITALY("Italy", "Italy"),
	
	/**
	 * Jamaica
	 */
	@RosettaEnumValue(value = "Jamaica", displayName = "Jamaica") 
	JAMAICA("Jamaica", "Jamaica"),
	
	/**
	 * Japan
	 */
	@RosettaEnumValue(value = "Japan", displayName = "Japan") 
	JAPAN("Japan", "Japan"),
	
	/**
	 * Jersey
	 */
	@RosettaEnumValue(value = "Jersey", displayName = "Jersey") 
	JERSEY("Jersey", "Jersey"),
	
	/**
	 * Jordan
	 */
	@RosettaEnumValue(value = "Jordan", displayName = "Jordan") 
	JORDAN("Jordan", "Jordan"),
	
	/**
	 * Kazakhstan
	 */
	@RosettaEnumValue(value = "Kazakhstan", displayName = "Kazakhstan") 
	KAZAKHSTAN("Kazakhstan", "Kazakhstan"),
	
	/**
	 * Kenya
	 */
	@RosettaEnumValue(value = "Kenya", displayName = "Kenya") 
	KENYA("Kenya", "Kenya"),
	
	/**
	 * Kiribati
	 */
	@RosettaEnumValue(value = "Kiribati", displayName = "Kiribati") 
	KIRIBATI("Kiribati", "Kiribati"),
	
	/**
	 * Korea, Democratic People&#39;s Republic of
	 */
	@RosettaEnumValue(value = "Korea_Democratic_People_s_Republic_of", displayName = "Korea, Democratic People's Republic of") 
	KOREA_DEMOCRATIC_PEOPLE_S_REPUBLIC_OF("Korea_Democratic_People_s_Republic_of", "Korea, Democratic People's Republic of"),
	
	/**
	 * Korea, Republic of
	 */
	@RosettaEnumValue(value = "Korea_Republic_of", displayName = "Korea, Republic of") 
	KOREA_REPUBLIC_OF("Korea_Republic_of", "Korea, Republic of"),
	
	/**
	 * Kuwait
	 */
	@RosettaEnumValue(value = "Kuwait", displayName = "Kuwait") 
	KUWAIT("Kuwait", "Kuwait"),
	
	/**
	 * Kyrgyzstan
	 */
	@RosettaEnumValue(value = "Kyrgyzstan", displayName = "Kyrgyzstan") 
	KYRGYZSTAN("Kyrgyzstan", "Kyrgyzstan"),
	
	/**
	 * Lao People&#39;s Democratic Republic
	 */
	@RosettaEnumValue(value = "Lao_People_s_Democratic_Republic", displayName = "Lao People's Democratic Republic") 
	LAO_PEOPLE_S_DEMOCRATIC_REPUBLIC("Lao_People_s_Democratic_Republic", "Lao People's Democratic Republic"),
	
	/**
	 * Latvia
	 */
	@RosettaEnumValue(value = "Latvia", displayName = "Latvia") 
	LATVIA("Latvia", "Latvia"),
	
	/**
	 * Lebanon
	 */
	@RosettaEnumValue(value = "Lebanon", displayName = "Lebanon") 
	LEBANON("Lebanon", "Lebanon"),
	
	/**
	 * Lesotho
	 */
	@RosettaEnumValue(value = "Lesotho", displayName = "Lesotho") 
	LESOTHO("Lesotho", "Lesotho"),
	
	/**
	 * Liberia
	 */
	@RosettaEnumValue(value = "Liberia", displayName = "Liberia") 
	LIBERIA("Liberia", "Liberia"),
	
	/**
	 * Libya
	 */
	@RosettaEnumValue(value = "Libya", displayName = "Libya") 
	LIBYA("Libya", "Libya"),
	
	/**
	 * Liechtenstein
	 */
	@RosettaEnumValue(value = "Liechtenstein", displayName = "Liechtenstein") 
	LIECHTENSTEIN("Liechtenstein", "Liechtenstein"),
	
	/**
	 * Lithuania
	 */
	@RosettaEnumValue(value = "Lithuania", displayName = "Lithuania") 
	LITHUANIA("Lithuania", "Lithuania"),
	
	/**
	 * Luxembourg
	 */
	@RosettaEnumValue(value = "Luxembourg", displayName = "Luxembourg") 
	LUXEMBOURG("Luxembourg", "Luxembourg"),
	
	/**
	 * Macao
	 */
	@RosettaEnumValue(value = "Macao", displayName = "Macao") 
	MACAO("Macao", "Macao"),
	
	/**
	 * Macedonia, the Former Yugoslav Republic of
	 */
	@RosettaEnumValue(value = "Macedonia_the_Former_Yugoslav_Republic_of", displayName = "Macedonia, the Former Yugoslav Republic of") 
	MACEDONIA_THE_FORMER_YUGOSLAV_REPUBLIC_OF("Macedonia_the_Former_Yugoslav_Republic_of", "Macedonia, the Former Yugoslav Republic of"),
	
	/**
	 * Madagascar
	 */
	@RosettaEnumValue(value = "Madagascar", displayName = "Madagascar") 
	MADAGASCAR("Madagascar", "Madagascar"),
	
	/**
	 * Malawi
	 */
	@RosettaEnumValue(value = "Malawi", displayName = "Malawi") 
	MALAWI("Malawi", "Malawi"),
	
	/**
	 * Malaysia
	 */
	@RosettaEnumValue(value = "Malaysia", displayName = "Malaysia") 
	MALAYSIA("Malaysia", "Malaysia"),
	
	/**
	 * Maldives
	 */
	@RosettaEnumValue(value = "Maldives", displayName = "Maldives") 
	MALDIVES("Maldives", "Maldives"),
	
	/**
	 * Mali
	 */
	@RosettaEnumValue(value = "Mali", displayName = "Mali") 
	MALI("Mali", "Mali"),
	
	/**
	 * Malta
	 */
	@RosettaEnumValue(value = "Malta", displayName = "Malta") 
	MALTA("Malta", "Malta"),
	
	/**
	 * Marshall Islands
	 */
	@RosettaEnumValue(value = "Marshall_Islands", displayName = "Marshall Islands") 
	MARSHALL_ISLANDS("Marshall_Islands", "Marshall Islands"),
	
	/**
	 * Martinique
	 */
	@RosettaEnumValue(value = "Martinique", displayName = "Martinique") 
	MARTINIQUE("Martinique", "Martinique"),
	
	/**
	 * Mauritania
	 */
	@RosettaEnumValue(value = "Mauritania", displayName = "Mauritania") 
	MAURITANIA("Mauritania", "Mauritania"),
	
	/**
	 * Mauritius
	 */
	@RosettaEnumValue(value = "Mauritius", displayName = "Mauritius") 
	MAURITIUS("Mauritius", "Mauritius"),
	
	/**
	 * Mayotte
	 */
	@RosettaEnumValue(value = "Mayotte", displayName = "Mayotte") 
	MAYOTTE("Mayotte", "Mayotte"),
	
	/**
	 * Mexico
	 */
	@RosettaEnumValue(value = "Mexico", displayName = "Mexico") 
	MEXICO("Mexico", "Mexico"),
	
	/**
	 * Micronesia, Federated States of
	 */
	@RosettaEnumValue(value = "Micronesia_Federated_States_of", displayName = "Micronesia, Federated States of") 
	MICRONESIA_FEDERATED_STATES_OF("Micronesia_Federated_States_of", "Micronesia, Federated States of"),
	
	/**
	 * Moldova, Republic of
	 */
	@RosettaEnumValue(value = "Moldova_Republic_of", displayName = "Moldova, Republic of") 
	MOLDOVA_REPUBLIC_OF("Moldova_Republic_of", "Moldova, Republic of"),
	
	/**
	 * Monaco
	 */
	@RosettaEnumValue(value = "Monaco", displayName = "Monaco") 
	MONACO("Monaco", "Monaco"),
	
	/**
	 * Mongolia
	 */
	@RosettaEnumValue(value = "Mongolia", displayName = "Mongolia") 
	MONGOLIA("Mongolia", "Mongolia"),
	
	/**
	 * Montenegro
	 */
	@RosettaEnumValue(value = "Montenegro", displayName = "Montenegro") 
	MONTENEGRO("Montenegro", "Montenegro"),
	
	/**
	 * Montserrat
	 */
	@RosettaEnumValue(value = "Montserrat", displayName = "Montserrat") 
	MONTSERRAT("Montserrat", "Montserrat"),
	
	/**
	 * Morocco
	 */
	@RosettaEnumValue(value = "Morocco", displayName = "Morocco") 
	MOROCCO("Morocco", "Morocco"),
	
	/**
	 * Mozambique
	 */
	@RosettaEnumValue(value = "Mozambique", displayName = "Mozambique") 
	MOZAMBIQUE("Mozambique", "Mozambique"),
	
	/**
	 * Myanmar
	 */
	@RosettaEnumValue(value = "Myanmar", displayName = "Myanmar") 
	MYANMAR("Myanmar", "Myanmar"),
	
	/**
	 * Namibia
	 */
	@RosettaEnumValue(value = "Namibia", displayName = "Namibia") 
	NAMIBIA("Namibia", "Namibia"),
	
	/**
	 * Nauru
	 */
	@RosettaEnumValue(value = "Nauru", displayName = "Nauru") 
	NAURU("Nauru", "Nauru"),
	
	/**
	 * Nepal
	 */
	@RosettaEnumValue(value = "Nepal", displayName = "Nepal") 
	NEPAL("Nepal", "Nepal"),
	
	/**
	 * Netherlands
	 */
	@RosettaEnumValue(value = "Netherlands", displayName = "Netherlands") 
	NETHERLANDS("Netherlands", "Netherlands"),
	
	/**
	 * New Caledonia
	 */
	@RosettaEnumValue(value = "New_Caledonia", displayName = "New Caledonia") 
	NEW_CALEDONIA("New_Caledonia", "New Caledonia"),
	
	/**
	 * New Zealand
	 */
	@RosettaEnumValue(value = "New_Zealand", displayName = "New Zealand") 
	NEW_ZEALAND("New_Zealand", "New Zealand"),
	
	/**
	 * Nicaragua
	 */
	@RosettaEnumValue(value = "Nicaragua", displayName = "Nicaragua") 
	NICARAGUA("Nicaragua", "Nicaragua"),
	
	/**
	 * Niger
	 */
	@RosettaEnumValue(value = "Niger", displayName = "Niger") 
	NIGER("Niger", "Niger"),
	
	/**
	 * Nigeria
	 */
	@RosettaEnumValue(value = "Nigeria", displayName = "Nigeria") 
	NIGERIA("Nigeria", "Nigeria"),
	
	/**
	 * Niue
	 */
	@RosettaEnumValue(value = "Niue", displayName = "Niue") 
	NIUE("Niue", "Niue"),
	
	/**
	 * Norfolk Island
	 */
	@RosettaEnumValue(value = "Norfolk_Island", displayName = "Norfolk Island") 
	NORFOLK_ISLAND("Norfolk_Island", "Norfolk Island"),
	
	/**
	 * Northern Mariana Islands
	 */
	@RosettaEnumValue(value = "Northern_Mariana_Islands", displayName = "Northern Mariana Islands") 
	NORTHERN_MARIANA_ISLANDS("Northern_Mariana_Islands", "Northern Mariana Islands"),
	
	/**
	 * Norway
	 */
	@RosettaEnumValue(value = "Norway", displayName = "Norway") 
	NORWAY("Norway", "Norway"),
	
	/**
	 * Oman
	 */
	@RosettaEnumValue(value = "Oman", displayName = "Oman") 
	OMAN("Oman", "Oman"),
	
	/**
	 * Pakistan
	 */
	@RosettaEnumValue(value = "Pakistan", displayName = "Pakistan") 
	PAKISTAN("Pakistan", "Pakistan"),
	
	/**
	 * Palau
	 */
	@RosettaEnumValue(value = "Palau", displayName = "Palau") 
	PALAU("Palau", "Palau"),
	
	/**
	 * Palestine, State of
	 */
	@RosettaEnumValue(value = "Palestine_State_of", displayName = "Palestine, State of") 
	PALESTINE_STATE_OF("Palestine_State_of", "Palestine, State of"),
	
	/**
	 * Panama
	 */
	@RosettaEnumValue(value = "Panama", displayName = "Panama") 
	PANAMA("Panama", "Panama"),
	
	/**
	 * Papua New Guinea
	 */
	@RosettaEnumValue(value = "Papua_New_Guinea", displayName = "Papua New Guinea") 
	PAPUA_NEW_GUINEA("Papua_New_Guinea", "Papua New Guinea"),
	
	/**
	 * Paraguay
	 */
	@RosettaEnumValue(value = "Paraguay", displayName = "Paraguay") 
	PARAGUAY("Paraguay", "Paraguay"),
	
	/**
	 * Peru
	 */
	@RosettaEnumValue(value = "Peru", displayName = "Peru") 
	PERU("Peru", "Peru"),
	
	/**
	 * Philippines
	 */
	@RosettaEnumValue(value = "Philippines", displayName = "Philippines") 
	PHILIPPINES("Philippines", "Philippines"),
	
	/**
	 * Pitcairn
	 */
	@RosettaEnumValue(value = "Pitcairn", displayName = "Pitcairn") 
	PITCAIRN("Pitcairn", "Pitcairn"),
	
	/**
	 * Poland
	 */
	@RosettaEnumValue(value = "Poland", displayName = "Poland") 
	POLAND("Poland", "Poland"),
	
	/**
	 * Portugal
	 */
	@RosettaEnumValue(value = "Portugal", displayName = "Portugal") 
	PORTUGAL("Portugal", "Portugal"),
	
	/**
	 * Puerto Rico
	 */
	@RosettaEnumValue(value = "Puerto_Rico", displayName = "Puerto Rico") 
	PUERTO_RICO("Puerto_Rico", "Puerto Rico"),
	
	/**
	 * Qatar
	 */
	@RosettaEnumValue(value = "Qatar", displayName = "Qatar") 
	QATAR("Qatar", "Qatar"),
	
	/**
	 * Reunion
	 */
	@RosettaEnumValue(value = "Reunion", displayName = "Reunion") 
	REUNION("Reunion", "Reunion"),
	
	/**
	 * Romania
	 */
	@RosettaEnumValue(value = "Romania", displayName = "Romania") 
	ROMANIA("Romania", "Romania"),
	
	/**
	 * Russian Federation
	 */
	@RosettaEnumValue(value = "Russian_Federation", displayName = "Russian Federation") 
	RUSSIAN_FEDERATION("Russian_Federation", "Russian Federation"),
	
	/**
	 * Rwanda
	 */
	@RosettaEnumValue(value = "Rwanda", displayName = "Rwanda") 
	RWANDA("Rwanda", "Rwanda"),
	
	/**
	 * Saint Barthelemy
	 */
	@RosettaEnumValue(value = "Saint_Barthelemy", displayName = "Saint Barthelemy") 
	SAINT_BARTHELEMY("Saint_Barthelemy", "Saint Barthelemy"),
	
	/**
	 * Saint Helena, Ascension and Tristan da Cunha
	 */
	@RosettaEnumValue(value = "Saint_Helena_Ascension_and_Tristan_da_Cunha", displayName = "Saint Helena, Ascension and Tristan da Cunha") 
	SAINT_HELENA_ASCENSION_AND_TRISTAN_DA_CUNHA("Saint_Helena_Ascension_and_Tristan_da_Cunha", "Saint Helena, Ascension and Tristan da Cunha"),
	
	/**
	 * Saint Kitts and Nevis
	 */
	@RosettaEnumValue(value = "Saint_Kitts_and_Nevis", displayName = "Saint Kitts and Nevis") 
	SAINT_KITTS_AND_NEVIS("Saint_Kitts_and_Nevis", "Saint Kitts and Nevis"),
	
	/**
	 * Saint Lucia
	 */
	@RosettaEnumValue(value = "Saint_Lucia", displayName = "Saint Lucia") 
	SAINT_LUCIA("Saint_Lucia", "Saint Lucia"),
	
	/**
	 * Saint Martin (French part)
	 */
	@RosettaEnumValue(value = "Saint_Martin_French_part_", displayName = "Saint Martin (French part)") 
	SAINT_MARTIN_FRENCH_PART("Saint_Martin_French_part_", "Saint Martin (French part)"),
	
	/**
	 * Saint Pierre and Miquelon
	 */
	@RosettaEnumValue(value = "Saint_Pierre_and_Miquelon", displayName = "Saint Pierre and Miquelon") 
	SAINT_PIERRE_AND_MIQUELON("Saint_Pierre_and_Miquelon", "Saint Pierre and Miquelon"),
	
	/**
	 * Saint Vincent and the Grenadines
	 */
	@RosettaEnumValue(value = "Saint_Vincent_and_the_Grenadines", displayName = "Saint Vincent and the Grenadines") 
	SAINT_VINCENT_AND_THE_GRENADINES("Saint_Vincent_and_the_Grenadines", "Saint Vincent and the Grenadines"),
	
	/**
	 * Samoa
	 */
	@RosettaEnumValue(value = "Samoa", displayName = "Samoa") 
	SAMOA("Samoa", "Samoa"),
	
	/**
	 * San Marino
	 */
	@RosettaEnumValue(value = "San_Marino", displayName = "San Marino") 
	SAN_MARINO("San_Marino", "San Marino"),
	
	/**
	 * Sao Tome and Principe
	 */
	@RosettaEnumValue(value = "Sao_Tome_and_Principe", displayName = "Sao Tome and Principe") 
	SAO_TOME_AND_PRINCIPE("Sao_Tome_and_Principe", "Sao Tome and Principe"),
	
	/**
	 * Saudi Arabia
	 */
	@RosettaEnumValue(value = "Saudi_Arabia", displayName = "Saudi Arabia") 
	SAUDI_ARABIA("Saudi_Arabia", "Saudi Arabia"),
	
	/**
	 * Senegal
	 */
	@RosettaEnumValue(value = "Senegal", displayName = "Senegal") 
	SENEGAL("Senegal", "Senegal"),
	
	/**
	 * Serbia
	 */
	@RosettaEnumValue(value = "Serbia", displayName = "Serbia") 
	SERBIA("Serbia", "Serbia"),
	
	/**
	 * Seychelles
	 */
	@RosettaEnumValue(value = "Seychelles", displayName = "Seychelles") 
	SEYCHELLES("Seychelles", "Seychelles"),
	
	/**
	 * Sierra Leone
	 */
	@RosettaEnumValue(value = "Sierra_Leone", displayName = "Sierra Leone") 
	SIERRA_LEONE("Sierra_Leone", "Sierra Leone"),
	
	/**
	 * Singapore
	 */
	@RosettaEnumValue(value = "Singapore", displayName = "Singapore") 
	SINGAPORE("Singapore", "Singapore"),
	
	/**
	 * Sint Maarten (Dutch part)
	 */
	@RosettaEnumValue(value = "Sint_Maarten_Dutch_part_", displayName = "Sint Maarten (Dutch part)") 
	SINT_MAARTEN_DUTCH_PART("Sint_Maarten_Dutch_part_", "Sint Maarten (Dutch part)"),
	
	/**
	 * Slovakia
	 */
	@RosettaEnumValue(value = "Slovakia", displayName = "Slovakia") 
	SLOVAKIA("Slovakia", "Slovakia"),
	
	/**
	 * Slovenia
	 */
	@RosettaEnumValue(value = "Slovenia", displayName = "Slovenia") 
	SLOVENIA("Slovenia", "Slovenia"),
	
	/**
	 * Solomon Islands
	 */
	@RosettaEnumValue(value = "Solomon_Islands", displayName = "Solomon Islands") 
	SOLOMON_ISLANDS("Solomon_Islands", "Solomon Islands"),
	
	/**
	 * Somalia
	 */
	@RosettaEnumValue(value = "Somalia", displayName = "Somalia") 
	SOMALIA("Somalia", "Somalia"),
	
	/**
	 * South Africa
	 */
	@RosettaEnumValue(value = "South_Africa", displayName = "South Africa") 
	SOUTH_AFRICA("South_Africa", "South Africa"),
	
	/**
	 * South Georgia and the South Sandwich Islands
	 */
	@RosettaEnumValue(value = "South_Georgia_and_the_South_Sandwich_Islands", displayName = "South Georgia and the South Sandwich Islands") 
	SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS("South_Georgia_and_the_South_Sandwich_Islands", "South Georgia and the South Sandwich Islands"),
	
	/**
	 * South Sudan
	 */
	@RosettaEnumValue(value = "South_Sudan", displayName = "South Sudan") 
	SOUTH_SUDAN("South_Sudan", "South Sudan"),
	
	/**
	 * Spain
	 */
	@RosettaEnumValue(value = "Spain", displayName = "Spain") 
	SPAIN("Spain", "Spain"),
	
	/**
	 * Sri Lanka
	 */
	@RosettaEnumValue(value = "Sri_Lanka", displayName = "Sri Lanka") 
	SRI_LANKA("Sri_Lanka", "Sri Lanka"),
	
	/**
	 * Sudan
	 */
	@RosettaEnumValue(value = "Sudan", displayName = "Sudan") 
	SUDAN("Sudan", "Sudan"),
	
	/**
	 * Suriname
	 */
	@RosettaEnumValue(value = "Suriname", displayName = "Suriname") 
	SURINAME("Suriname", "Suriname"),
	
	/**
	 * Svalbard and Jan Mayen
	 */
	@RosettaEnumValue(value = "Svalbard_and_Jan_Mayen", displayName = "Svalbard and Jan Mayen") 
	SVALBARD_AND_JAN_MAYEN("Svalbard_and_Jan_Mayen", "Svalbard and Jan Mayen"),
	
	/**
	 * Swaziland
	 */
	@RosettaEnumValue(value = "Swaziland", displayName = "Swaziland") 
	SWAZILAND("Swaziland", "Swaziland"),
	
	/**
	 * Sweden
	 */
	@RosettaEnumValue(value = "Sweden", displayName = "Sweden") 
	SWEDEN("Sweden", "Sweden"),
	
	/**
	 * Switzerland
	 */
	@RosettaEnumValue(value = "Switzerland", displayName = "Switzerland") 
	SWITZERLAND("Switzerland", "Switzerland"),
	
	/**
	 * Syrian Arab Republic
	 */
	@RosettaEnumValue(value = "Syrian_Arab_Republic", displayName = "Syrian Arab Republic") 
	SYRIAN_ARAB_REPUBLIC("Syrian_Arab_Republic", "Syrian Arab Republic"),
	
	/**
	 * Taiwan, Province of China
	 */
	@RosettaEnumValue(value = "Taiwan_Province_of_China", displayName = "Taiwan, Province of China") 
	TAIWAN_PROVINCE_OF_CHINA("Taiwan_Province_of_China", "Taiwan, Province of China"),
	
	/**
	 * Tajikistan
	 */
	@RosettaEnumValue(value = "Tajikistan", displayName = "Tajikistan") 
	TAJIKISTAN("Tajikistan", "Tajikistan"),
	
	/**
	 * Tanzania, United Republic of
	 */
	@RosettaEnumValue(value = "Tanzania_United_Republic_of", displayName = "Tanzania, United Republic of") 
	TANZANIA_UNITED_REPUBLIC_OF("Tanzania_United_Republic_of", "Tanzania, United Republic of"),
	
	/**
	 * Thailand
	 */
	@RosettaEnumValue(value = "Thailand", displayName = "Thailand") 
	THAILAND("Thailand", "Thailand"),
	
	/**
	 * Timor-Leste
	 */
	@RosettaEnumValue(value = "Timor_Leste", displayName = "Timor-Leste") 
	TIMOR_LESTE("Timor_Leste", "Timor-Leste"),
	
	/**
	 * Togo
	 */
	@RosettaEnumValue(value = "Togo", displayName = "Togo") 
	TOGO("Togo", "Togo"),
	
	/**
	 * Tokelau
	 */
	@RosettaEnumValue(value = "Tokelau", displayName = "Tokelau") 
	TOKELAU("Tokelau", "Tokelau"),
	
	/**
	 * Tonga
	 */
	@RosettaEnumValue(value = "Tonga", displayName = "Tonga") 
	TONGA("Tonga", "Tonga"),
	
	/**
	 * Trinidad and Tobago
	 */
	@RosettaEnumValue(value = "Trinidad_and_Tobago", displayName = "Trinidad and Tobago") 
	TRINIDAD_AND_TOBAGO("Trinidad_and_Tobago", "Trinidad and Tobago"),
	
	/**
	 * Tunisia
	 */
	@RosettaEnumValue(value = "Tunisia", displayName = "Tunisia") 
	TUNISIA("Tunisia", "Tunisia"),
	
	/**
	 * Turkey
	 */
	@RosettaEnumValue(value = "Turkey", displayName = "Turkey") 
	TURKEY("Turkey", "Turkey"),
	
	/**
	 * Turkmenistan
	 */
	@RosettaEnumValue(value = "Turkmenistan", displayName = "Turkmenistan") 
	TURKMENISTAN("Turkmenistan", "Turkmenistan"),
	
	/**
	 * Turks and Caicos Islands
	 */
	@RosettaEnumValue(value = "Turks_and_Caicos_Islands", displayName = "Turks and Caicos Islands") 
	TURKS_AND_CAICOS_ISLANDS("Turks_and_Caicos_Islands", "Turks and Caicos Islands"),
	
	/**
	 * Tuvalu
	 */
	@RosettaEnumValue(value = "Tuvalu", displayName = "Tuvalu") 
	TUVALU("Tuvalu", "Tuvalu"),
	
	/**
	 * Uganda
	 */
	@RosettaEnumValue(value = "Uganda", displayName = "Uganda") 
	UGANDA("Uganda", "Uganda"),
	
	/**
	 * Ukraine
	 */
	@RosettaEnumValue(value = "Ukraine", displayName = "Ukraine") 
	UKRAINE("Ukraine", "Ukraine"),
	
	/**
	 * United Arab Emirates
	 */
	@RosettaEnumValue(value = "United_Arab_Emirates", displayName = "United Arab Emirates") 
	UNITED_ARAB_EMIRATES("United_Arab_Emirates", "United Arab Emirates"),
	
	/**
	 * United Kingdom
	 */
	@RosettaEnumValue(value = "United_Kingdom", displayName = "United Kingdom") 
	UNITED_KINGDOM("United_Kingdom", "United Kingdom"),
	
	/**
	 * United States
	 */
	@RosettaEnumValue(value = "United_States", displayName = "United States") 
	UNITED_STATES("United_States", "United States"),
	
	/**
	 * United States Minor Outlying Islands
	 */
	@RosettaEnumValue(value = "United_States_Minor_Outlying_Islands", displayName = "United States Minor Outlying Islands") 
	UNITED_STATES_MINOR_OUTLYING_ISLANDS("United_States_Minor_Outlying_Islands", "United States Minor Outlying Islands"),
	
	/**
	 * Uruguay
	 */
	@RosettaEnumValue(value = "Uruguay", displayName = "Uruguay") 
	URUGUAY("Uruguay", "Uruguay"),
	
	/**
	 * Uzbekistan
	 */
	@RosettaEnumValue(value = "Uzbekistan", displayName = "Uzbekistan") 
	UZBEKISTAN("Uzbekistan", "Uzbekistan"),
	
	/**
	 * Vanuatu
	 */
	@RosettaEnumValue(value = "Vanuatu", displayName = "Vanuatu") 
	VANUATU("Vanuatu", "Vanuatu"),
	
	/**
	 * Venezuela, Bolivarian Republic of
	 */
	@RosettaEnumValue(value = "Venezuela_Bolivarian_Republic_of", displayName = "Venezuela, Bolivarian Republic of") 
	VENEZUELA_BOLIVARIAN_REPUBLIC_OF("Venezuela_Bolivarian_Republic_of", "Venezuela, Bolivarian Republic of"),
	
	/**
	 * Viet Nam
	 */
	@RosettaEnumValue(value = "Viet_Nam", displayName = "Viet Nam") 
	VIET_NAM("Viet_Nam", "Viet Nam"),
	
	/**
	 * Virgin Islands, British
	 */
	@RosettaEnumValue(value = "Virgin_Islands_British", displayName = "Virgin Islands, British") 
	VIRGIN_ISLANDS_BRITISH("Virgin_Islands_British", "Virgin Islands, British"),
	
	/**
	 * Virgin Islands, U.S.
	 */
	@RosettaEnumValue(value = "Virgin_Islands_U_S_", displayName = "Virgin Islands, U.S.") 
	VIRGIN_ISLANDS_U_S("Virgin_Islands_U_S_", "Virgin Islands, U.S."),
	
	/**
	 * Wallis and Futuna
	 */
	@RosettaEnumValue(value = "Wallis_and_Futuna", displayName = "Wallis and Futuna") 
	WALLIS_AND_FUTUNA("Wallis_and_Futuna", "Wallis and Futuna"),
	
	/**
	 * Western Sahara
	 */
	@RosettaEnumValue(value = "Western_Sahara", displayName = "Western Sahara") 
	WESTERN_SAHARA("Western_Sahara", "Western Sahara"),
	
	/**
	 * Yemen
	 */
	@RosettaEnumValue(value = "Yemen", displayName = "Yemen") 
	YEMEN("Yemen", "Yemen"),
	
	/**
	 * Zambia
	 */
	@RosettaEnumValue(value = "Zambia", displayName = "Zambia") 
	ZAMBIA("Zambia", "Zambia"),
	
	/**
	 * Zimbabwe
	 */
	@RosettaEnumValue(value = "Zimbabwe", displayName = "Zimbabwe") 
	ZIMBABWE("Zimbabwe", "Zimbabwe")
;
	private static Map<String, AnnaDsbPlaceofSettlementEnum> values;
	static {
        Map<String, AnnaDsbPlaceofSettlementEnum> map = new ConcurrentHashMap<>();
		for (AnnaDsbPlaceofSettlementEnum instance : AnnaDsbPlaceofSettlementEnum.values()) {
			map.put(instance.toDisplayString(), instance);
		}
		values = Collections.unmodifiableMap(map);
    }

	private final String rosettaName;
	private final String displayName;

	AnnaDsbPlaceofSettlementEnum(String rosettaName, String displayName) {
		this.rosettaName = rosettaName;
		this.displayName = displayName;
	}

	public static AnnaDsbPlaceofSettlementEnum fromDisplayName(String name) {
		AnnaDsbPlaceofSettlementEnum value = values.get(name);
		if (value == null) {
			throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
		}
		return value;
	}

	@Override
	public String toString() {
		return toDisplayString();
	}

	public String toDisplayString() {
		return displayName != null ?  displayName : rosettaName;
	}
}
